/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class QuickNavigationGridScreen<T extends class_1703>
extends class_465<T> {
    public static final int TEXT_COLOR = 0xEEEEEE;
    public static final class_2960 BACKGROUND = class_2960.method_60655((String)"spectrum", (String)"textures/gui/quick_navigation.png");
    protected static final class_2561 CONTROLS_TEXT_1 = class_2561.method_43471((String)"gui.spectrum.quick_navigation.controls1");
    protected static final class_2561 CONTROLS_TEXT_2 = class_2561.method_43471((String)"gui.spectrum.quick_navigation.controls2");
    private static final List<class_3545<Integer, Integer>> SQUARE_OFFSETS = List.of(new class_3545((Object)-20, (Object)-80), new class_3545((Object)40, (Object)-20), new class_3545((Object)-20, (Object)40), new class_3545((Object)-80, (Object)-20));
    public final Stack<Grid> gridStack = new Stack();

    public QuickNavigationGridScreen(T handler, class_1661 playerInventory, class_2561 title) {
        super(handler, playerInventory, title);
        this.field_2779 = 256;
    }

    private void back() {
        this.field_22787.field_1687.method_8396(null, this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_SWITCH, class_3419.field_15254, 0.5f, 1.0f);
        if (this.gridStack.size() == 1) {
            this.field_22787.field_1724.method_7346();
        } else {
            this.gridStack.pop();
        }
    }

    protected void selectGrid(Grid grid) {
        this.field_22787.field_1687.method_8396(null, this.field_22787.field_1724.method_24515(), SpectrumSoundEvents.PAINTBRUSH_SWITCH, class_3419.field_15254, 0.5f, 1.0f);
        this.gridStack.push(grid);
    }

    public Grid current() {
        return this.gridStack.peek();
    }

    protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
        this.current().drawBackground((class_437)this, drawContext, this.field_2792 / 2, this.field_2779 / 2);
        this.current().drawForeground((class_437)this, drawContext, this.field_2792 / 2, this.field_2779 / 2);
        drawContext.method_27534(this.field_22793, CONTROLS_TEXT_1, this.field_2792 / 2, 228, 0xEEEEEE);
        drawContext.method_27534(this.field_22793, CONTROLS_TEXT_2, this.field_2792 / 2, 238, 0xEEEEEE);
    }

    protected void method_2389(class_332 drawContext, float delta, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.current().navigate(GUISelection.BACK, this);
        } else {
            int centerElementSize;
            int startX = this.field_2792 / 2;
            int startY = this.field_2779 / 2;
            mouseX -= (double)this.field_2776;
            mouseY -= (double)this.field_2800;
            int n = centerElementSize = this.gridStack.size() == 1 ? 5 : 14;
            if (mouseX >= (double)(startX - centerElementSize) && mouseX <= (double)(startX + centerElementSize) && mouseY >= (double)(startY - centerElementSize) && mouseY <= (double)(startY + centerElementSize)) {
                this.current().navigate(GUISelection.SELECT, this);
                return true;
            }
            int offsetID = 0;
            for (class_3545<Integer, Integer> offset : SQUARE_OFFSETS) {
                if (mouseX >= (double)(startX + (Integer)offset.method_15442()) && mouseX <= (double)(startX + (Integer)offset.method_15442() + 32) && mouseY >= (double)(startY + (Integer)offset.method_15441()) && mouseY <= (double)(startY + (Integer)offset.method_15441() + 32)) {
                    switch (offsetID) {
                        case 0: {
                            this.current().navigate(GUISelection.UP, this);
                            return true;
                        }
                        case 1: {
                            this.current().navigate(GUISelection.RIGHT, this);
                            return true;
                        }
                        case 2: {
                            this.current().navigate(GUISelection.DOWN, this);
                            return true;
                        }
                        case 3: {
                            this.current().navigate(GUISelection.LEFT, this);
                            return true;
                        }
                    }
                }
                ++offsetID;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_310 client = class_310.method_1551();
        class_315 options = client.field_1690;
        if (options.field_1913.method_1417(keyCode, scanCode)) {
            this.current().navigate(GUISelection.LEFT, this);
            return true;
        }
        if (options.field_1894.method_1417(keyCode, scanCode)) {
            this.current().navigate(GUISelection.UP, this);
            return true;
        }
        if (options.field_1849.method_1417(keyCode, scanCode)) {
            this.current().navigate(GUISelection.RIGHT, this);
            return true;
        }
        if (options.field_1881.method_1417(keyCode, scanCode)) {
            this.current().navigate(GUISelection.DOWN, this);
            return true;
        }
        if (options.field_1869.method_1417(keyCode, scanCode) || options.field_1822.method_1417(keyCode, scanCode)) {
            this.current().navigate(GUISelection.SELECT, this);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static class Grid {
        private final GridEntry centerEntry;
        private final GridEntry topEntry;
        private final GridEntry rightEntry;
        private final GridEntry bottomEntry;
        private final GridEntry leftEntry;

        public Grid(GridEntry centerEntry, GridEntry topEntry, GridEntry rightEntry, GridEntry bottomEntry, GridEntry leftEntry) {
            this.centerEntry = centerEntry;
            this.topEntry = topEntry;
            this.rightEntry = rightEntry;
            this.bottomEntry = bottomEntry;
            this.leftEntry = leftEntry;
        }

        void navigate(GUISelection direction, QuickNavigationGridScreen<?> screen) {
            switch (direction.ordinal()) {
                case 5: {
                    screen.back();
                    break;
                }
                case 4: {
                    this.centerEntry.whenSelected(screen);
                    break;
                }
                case 0: {
                    this.topEntry.whenSelected(screen);
                    break;
                }
                case 1: {
                    this.rightEntry.whenSelected(screen);
                    break;
                }
                case 2: {
                    this.bottomEntry.whenSelected(screen);
                    break;
                }
                default: {
                    this.leftEntry.whenSelected(screen);
                }
            }
        }

        void drawForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            this.centerEntry.drawSmallForeground(screen, drawContext, startX - 15, startY - 15);
            this.topEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(0).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(0).method_15441());
            this.rightEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(1).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(1).method_15441());
            this.bottomEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(2).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(2).method_15441());
            this.leftEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(3).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(3).method_15441());
        }

        void drawBackground(class_437 screen, class_332 drawContext, int startX, int startY) {
            this.centerEntry.drawSmallBackground(screen, drawContext, startX - 15, startY - 15);
            this.topEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(0).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(0).method_15441());
            this.rightEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(1).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(1).method_15441());
            this.bottomEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(2).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(2).method_15441());
            this.leftEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(3).method_15442(), startY + (Integer)SQUARE_OFFSETS.get(3).method_15441());
        }
    }

    public static enum GUISelection {
        UP,
        RIGHT,
        DOWN,
        LEFT,
        SELECT,
        BACK;

    }

    private static class ItemGridEntry
    extends GridEntry {
        protected final class_1799 stack;

        private ItemGridEntry(class_1792 item, class_2561 text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            this.stack = item.method_7854();
        }

        @Override
        void drawBigForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            super.drawBigForeground(screen, drawContext, startX, startY);
            drawContext.method_51427(this.stack, startX + 10, startY + 10);
        }

        @Override
        void drawSmallForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            super.drawSmallForeground(screen, drawContext, startX, startY);
            drawContext.method_51427(this.stack, startX + 5, startY + 5);
        }
    }

    public static class TextGridEntry
    extends GridEntry {
        protected final class_2561 innerText;
        protected final int innerHalfTextWidth;

        private TextGridEntry(class_2561 innerText, @Nullable class_2561 text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            class_310 client = class_310.method_1551();
            this.innerText = innerText;
            this.innerHalfTextWidth = client.field_1772.method_27525((class_5348)this.innerText) / 2;
        }

        @Override
        void drawBigForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            class_310 client = class_310.method_1551();
            drawContext.method_27534(client.field_1772, this.innerText, startX + 19, startY + 15, 0xEEEEEE);
        }

        @Override
        void drawSmallForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            class_310 client = class_310.method_1551();
            drawContext.method_27534(client.field_1772, this.innerText, startX + 14, startY + 10, 0xEEEEEE);
        }
    }

    public static class TexturedGridEntry
    extends GridEntry {
        protected final int textureStartX;
        protected final int textureStartY;

        private TexturedGridEntry(int textureStartX, int textureStartY, @Nullable class_2561 text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            this.textureStartX = textureStartX;
            this.textureStartY = textureStartY;
        }

        @Override
        void drawBigBackground(class_437 screen, class_332 drawContext, int startX, int startY) {
            super.drawBigBackground(screen, drawContext, startX, startY);
            drawContext.method_25302(BACKGROUND, startX + 11, startY + 11, this.textureStartX, this.textureStartY, 20, 20);
        }

        @Override
        void drawSmallBackground(class_437 screen, class_332 drawContext, int startX, int startY) {
            super.drawSmallBackground(screen, drawContext, startX, startY);
            drawContext.method_25302(BACKGROUND, startX, startY, this.textureStartX, this.textureStartY, 20, 20);
        }
    }

    public static class ColoredGridEntry
    extends GridEntry {
        protected final Vector3f color;

        private ColoredGridEntry(Vector3f color, class_2561 text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            this.color = color;
        }

        @Override
        void drawBigForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            super.drawBigForeground(screen, drawContext, startX, startY);
            RenderHelper.fillQuad(drawContext.method_51448(), startX + 3, startY + 3, 32, 32, this.color);
        }

        @Override
        void drawSmallForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            super.drawSmallForeground(screen, drawContext, startX, startY);
            RenderHelper.fillQuad(drawContext.method_51448(), startX + 2, startY + 2, 24, 24, this.color);
        }
    }

    public static class EmptyGridEntry
    extends GridEntry {
        protected EmptyGridEntry(@Nullable GridEntry.GridEntryCallback onClickCallback) {
            super((class_2561)class_2561.method_43473(), onClickCallback);
        }

        @Override
        void drawBigBackground(class_437 screen, class_332 drawContext, int startX, int startY) {
        }

        @Override
        void drawSmallBackground(class_437 screen, class_332 drawContext, int startX, int startY) {
            drawContext.method_25302(BACKGROUND, startX + 9, startY + 9, 0, 0, 10, 10);
        }

        @Override
        void drawBigForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
        }

        @Override
        void drawSmallForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
        }
    }

    public static abstract class GridEntry {
        public static final GridEntry CLOSE = GridEntry.empty(class_465::method_25419);
        public static final GridEntry BACK = GridEntry.empty(QuickNavigationGridScreen::back);
        public static final GridEntry EMPTY = GridEntry.empty(null);
        protected final class_2561 text;
        @Nullable
        protected final GridEntryCallback onClickCallback;

        protected GridEntry(class_2561 text, @Nullable GridEntryCallback onClickCallback) {
            this.text = text;
            this.onClickCallback = onClickCallback;
        }

        public static GridEntry empty(@Nullable GridEntryCallback callback) {
            return new EmptyGridEntry(callback);
        }

        public static GridEntry textured(int textureStartX, int textureStartY, class_2561 text, @Nullable GridEntryCallback callback) {
            return new TexturedGridEntry(textureStartX, textureStartY, text, callback);
        }

        public static GridEntry text(class_2561 innerText, class_2561 text, @Nullable GridEntryCallback callback) {
            return new TextGridEntry(innerText, text, callback);
        }

        public static GridEntry colored(Vector3f color, class_2561 text, @Nullable GridEntryCallback callback) {
            return new ColoredGridEntry(color, text, callback);
        }

        public static GridEntry item(class_1792 item, class_2561 text, @Nullable GridEntryCallback callback) {
            return new ItemGridEntry(item, text, callback);
        }

        public void whenSelected(QuickNavigationGridScreen<?> screen) {
            if (this.onClickCallback != null) {
                this.onClickCallback.whenSelected(screen);
            }
        }

        void drawBigBackground(class_437 screen, class_332 drawContext, int startX, int startY) {
            drawContext.method_25302(BACKGROUND, startX, startY, 10, 0, 38, 38);
        }

        void drawSmallBackground(class_437 screen, class_332 drawContext, int startX, int startY) {
            drawContext.method_25302(BACKGROUND, startX, startY, 48, 0, 28, 28);
        }

        void drawBigForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            class_310 client = class_310.method_1551();
            drawContext.method_27534(client.field_1772, this.text, startX + 19, startY + 40, 0xEEEEEE);
        }

        void drawSmallForeground(class_437 screen, class_332 drawContext, int startX, int startY) {
            class_310 client = class_310.method_1551();
            drawContext.method_27534(client.field_1772, this.text, startX + 14, startY + 34, 0xEEEEEE);
        }

        public static interface GridEntryCallback {
            public void whenSelected(QuickNavigationGridScreen<?> var1);
        }
    }
}

