/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.spectrum.api.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.RenderHelper;
import de.dafuqs.spectrum.helpers.Support;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class StackedInkMeterWidget
implements class_4068,
class_364,
class_6379 {
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected boolean hovered;
    protected boolean focused;
    protected final class_437 screen;
    protected final InkStorageBlockEntity<?> blockEntity;

    public StackedInkMeterWidget(int x, int y, int width, int height, class_437 screen, InkStorageBlockEntity<?> blockEntity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.blockEntity = blockEntity;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public class_6379.class_6380 method_37018() {
        return this.hovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public void drawMouseoverTooltip(class_332 drawContext, int x, int y) {
        class_310 client = class_310.method_1551();
        Object inkStorage = this.blockEntity.getEnergyStorage();
        long currentTotal = inkStorage.getCurrentTotal();
        String readableCurrentTotalString = Support.getShortenedNumberString(currentTotal);
        String percent = Support.getSensiblePercentString(inkStorage.getCurrentTotal(), inkStorage.getMaxTotal());
        drawContext.method_51437(client.field_1772, List.of(class_2561.method_43469((String)"spectrum.tooltip.ink_powered.percent_filled", (Object[])new Object[]{readableCurrentTotalString, percent})), Optional.empty(), x, y);
    }

    public void draw(class_332 drawContext) {
        Object inkStorage = this.blockEntity.getEnergyStorage();
        long currentTotal = inkStorage.getCurrentTotal();
        if (currentTotal > 0L) {
            long maxTotal = inkStorage.getMaxTotal();
            int currentHeight = this.y + this.height;
            for (InkColor color : InkColors.all()) {
                long amount = inkStorage.getEnergy(color);
                if (amount <= 0L) continue;
                int height = Math.round((float)amount / (float)maxTotal * (float)this.height);
                if (height > 0) {
                    RenderHelper.fillQuad(drawContext.method_51448(), this.x, currentHeight - height, height, this.width, color.getColorVec());
                }
                currentHeight -= height;
            }
        }
    }
}

