/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.energy;

import de.dafuqs.spectrum.api.energy.InkStorageItem;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.storage.SingleInkStorage;
import de.dafuqs.spectrum.api.item.LoomPatternProvider;
import de.dafuqs.spectrum.api.render.ExtendedItemBarProvider;
import de.dafuqs.spectrum.components.InkStorageComponent;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InkFlaskItem
extends class_1792
implements InkStorageItem<SingleInkStorage>,
LoomPatternProvider,
ExtendedItemBarProvider {
    private final long maxEnergy;

    public InkFlaskItem(class_1792.class_1793 settings, long maxEnergy) {
        super(settings);
        this.maxEnergy = maxEnergy;
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.ALWAYS;
    }

    @Override
    public SingleInkStorage getEnergyStorage(class_1799 itemStack) {
        Iterator<Map.Entry<InkColor, Long>> iterator;
        InkStorageComponent storage = (InkStorageComponent)itemStack.method_57824(SpectrumDataComponentTypes.INK_STORAGE);
        if (storage != null && (iterator = storage.storedEnergy().entrySet().iterator()).hasNext()) {
            Map.Entry<InkColor, Long> entry = iterator.next();
            return new SingleInkStorage(storage.maxEnergyTotal(), entry.getKey(), entry.getValue());
        }
        return new SingleInkStorage(this.maxEnergy);
    }

    @Override
    public class_1799 method_7854() {
        return super.method_7854();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        this.getEnergyStorage(stack).addTooltip(tooltip);
        this.addBannerPatternProviderTooltip(tooltip);
    }

    public class_1799 getFullStack(InkColor color) {
        class_1799 stack = this.method_7854();
        SingleInkStorage storage = this.getEnergyStorage(stack);
        storage.fillCompletely();
        storage.convertColor(color);
        this.setEnergyStorage(stack, storage);
        return stack;
    }

    @Override
    public class_5321<class_2582> getPattern() {
        return SpectrumBannerPatterns.INK_FLASK;
    }

    @Override
    public int barCount(class_1799 stack) {
        return 1;
    }

    @Override
    public ExtendedItemBarProvider.BarSignature getSignature(@Nullable class_1657 player, @NotNull class_1799 stack, int index) {
        SingleInkStorage storage = this.getEnergyStorage(stack);
        if (storage.isEmpty()) {
            return ExtendedItemBarProvider.PASS;
        }
        InkColor color = storage.getStoredColor();
        int progress = Support.getSensiblePercent(storage.getCurrentTotal(), storage.getMaxTotal(), 14);
        return new ExtendedItemBarProvider.BarSignature(1, 13, 14, progress, 1, color.getColorInt(), 2, -16777216);
    }
}

