/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.components.EnderSpliceComponent;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.c2s_payloads.BindEnderSpliceToPlayerPayload;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.EnderSpliceChargingSoundInstance;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2969;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5454;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class EnderSpliceItem
extends class_1792 {
    public static final class_2357 DISPENSER_BEHAVIOR = new class_2969(){

        protected class_1799 method_10135(class_2342 blockSource, class_1799 stack) {
            class_3218 serverLevel = blockSource.comp_1967();
            if (!serverLevel.method_8608()) {
                class_2338 blockPos = blockSource.comp_1968().method_10093((class_2350)blockSource.comp_1969().method_11654((class_2769)class_2315.field_10918));
                this.method_27955(1.tryTeleportPlayers(serverLevel, blockPos, stack));
                if (this.method_27954()) {
                    EnderSpliceItem.decrementWithChance(stack, (class_1937)serverLevel);
                }
            }
            return stack;
        }

        private static boolean tryTeleportPlayers(class_3218 level, class_2338 pos, class_1799 stack) {
            List list = level.method_8390(class_1309.class, new class_238(pos), class_1301.field_6155);
            for (class_1309 livingEntity : list) {
                if (!(livingEntity instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)livingEntity;
                EnderSpliceItem.teleport(stack, (class_1937)level, (class_1309)serverPlayer, serverPlayer);
            }
            return false;
        }
    };

    public EnderSpliceItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static boolean isSameWorld(class_1937 world1, class_1937 world2) {
        return world1.method_27983().method_29177().toString().equals(world2.method_27983().method_29177().toString());
    }

    public static void setTeleportTargetPos(@NotNull class_1799 itemStack, class_1937 world, class_243 pos) {
        itemStack.method_57379(SpectrumDataComponentTypes.ENDER_SPLICE, (Object)new EnderSpliceComponent(pos, (class_5321<class_1937>)world.method_27983()));
    }

    public static void setTeleportTargetPlayer(@NotNull class_1799 itemStack, class_3222 player) {
        itemStack.method_57379(SpectrumDataComponentTypes.ENDER_SPLICE, (Object)new EnderSpliceComponent(player.method_5477().getString(), player.method_5667()));
    }

    public static boolean hasTeleportTarget(class_1799 itemStack) {
        return itemStack.method_57826(SpectrumDataComponentTypes.ENDER_SPLICE);
    }

    public static void clearTeleportTarget(class_1799 itemStack) {
        itemStack.method_57381(SpectrumDataComponentTypes.ENDER_SPLICE);
    }

    public class_1799 method_7861(class_1799 itemStack, class_1937 world, class_1309 user) {
        if (world.field_9236) {
            if (EnderSpliceItem.getTeleportTargetPos(itemStack).isEmpty() && EnderSpliceItem.getTeleportTargetPlayerUUID(itemStack).isEmpty()) {
                this.interactWithEntityClient();
            }
        } else if (user instanceof class_3222) {
            class_3222 playerEntity = (class_3222)user;
            EnderSpliceItem.teleport(itemStack, world, user, playerEntity);
            playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        return itemStack;
    }

    private static void teleport(class_1799 itemStack, class_1937 world, class_1309 user, class_3222 playerEntity) {
        class_174.field_1198.method_8821(playerEntity, itemStack);
        boolean resonance = class_1890.method_60138((class_1799)itemStack, SpectrumEnchantmentTags.DIMENSIONAL_TELEPORT);
        Optional<class_3545<class_5321<class_1937>, class_243>> teleportTargetPos = EnderSpliceItem.getTeleportTargetPos(itemStack);
        if (teleportTargetPos.isPresent()) {
            class_3218 targetWorld = world.method_8503().method_3847((class_5321)teleportTargetPos.get().method_15442());
            if (EnderSpliceItem.teleportPlayerToPos(world, user, (class_1657)playerEntity, (class_1937)targetWorld, (class_243)teleportTargetPos.get().method_15441(), resonance) && !playerEntity.method_7337()) {
                EnderSpliceItem.decrementWithChance(itemStack, world);
            }
        } else {
            Optional<UUID> teleportTargetPlayerUUID = EnderSpliceItem.getTeleportTargetPlayerUUID(itemStack);
            if (teleportTargetPlayerUUID.isPresent()) {
                if (EnderSpliceItem.teleportPlayerToPlayerWithUUID(world, user, (class_1657)playerEntity, teleportTargetPlayerUUID.get(), resonance) && !playerEntity.method_7337()) {
                    EnderSpliceItem.decrementWithChance(itemStack, world);
                }
            } else {
                EnderSpliceItem.setTeleportTargetPos(itemStack, playerEntity.method_5770(), playerEntity.method_19538());
                world.method_8396(null, playerEntity.method_24515(), SpectrumSoundEvents.ENDER_SPLICE_BOUND, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    private static void decrementWithChance(class_1799 itemStack, class_1937 world) {
        if (class_1890.method_60138((class_1799)itemStack, SpectrumEnchantmentTags.INDESTRUCTIBLE_EFFECT)) {
            return;
        }
        int unbreakingLevel = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)world.method_30349(), (class_5321<class_1887>)class_1893.field_9119, itemStack);
        if (unbreakingLevel == 0) {
            itemStack.method_7934(1);
        } else {
            itemStack.method_7934(Support.getIntFromDecimalWithChance(1.0 / (double)(1 + unbreakingLevel), world.field_9229));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void interactWithEntityClient() {
        class_1297 class_12972;
        class_310 client = class_310.method_1551();
        class_239 hitResult = client.field_1765;
        if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331 && (class_12972 = ((class_3966)hitResult).method_17782()) instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_12972;
            ClientPlayNetworking.send((class_8710)new BindEnderSpliceToPlayerPayload(playerEntity.method_5628()));
        }
    }

    private static boolean teleportPlayerToPlayerWithUUID(class_1937 world, class_1309 user, class_1657 playerEntity, UUID targetPlayerUUID, boolean hasResonance) {
        class_1657 targetPlayer = PlayerOwned.getPlayerEntityIfOnline(targetPlayerUUID);
        if (targetPlayer != null) {
            return EnderSpliceItem.teleportPlayerToPos(targetPlayer.method_5770(), user, playerEntity, targetPlayer.method_5770(), targetPlayer.method_19538(), hasResonance);
        }
        return false;
    }

    private static boolean teleportPlayerToPos(class_1937 world, class_1309 user, class_1657 playerEntity, class_1937 targetWorld, class_243 targetPos, boolean hasResonance) {
        boolean isSameWorld = EnderSpliceItem.isSameWorld(user.method_5770(), targetWorld);
        class_243 currentPos = playerEntity.method_19538();
        if ((hasResonance || isSameWorld) && targetWorld instanceof class_3218) {
            class_3218 targetServerWorld = (class_3218)targetWorld;
            world.method_43128(playerEntity, currentPos.method_10216(), currentPos.method_10214(), currentPos.method_10215(), SpectrumSoundEvents.PLAYER_TELEPORTS, class_3419.field_15248, 1.0f, 1.0f);
            if (!isSameWorld) {
                user.method_5731(new class_5454(targetServerWorld, targetPos.method_1031(0.0, 0.25, 0.0), new class_243(0.0, 0.0, 0.0), user.method_36454(), user.method_36455(), class_5454.field_52245));
            } else {
                user.method_5859(targetPos.method_10216(), targetPos.field_1351 + 0.25, targetPos.field_1350);
            }
            world.method_43128(playerEntity, targetPos.method_10216(), targetPos.field_1351, targetPos.field_1350, SpectrumSoundEvents.PLAYER_TELEPORTS, class_3419.field_15248, 1.0f, 1.0f);
            if (playerEntity instanceof class_3222) {
                world.method_8396(null, playerEntity.method_24515(), SpectrumSoundEvents.PLAYER_TELEPORTS, class_3419.field_15248, 1.0f, 1.0f);
                world.method_8396(null, playerEntity.method_24515(), class_3417.field_15081, class_3419.field_15248, 1.0f, 1.0f);
            }
            return true;
        }
        user.method_6075();
        world.method_43128(null, currentPos.method_10216(), currentPos.method_10214(), currentPos.method_10215(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 1.0f);
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            this.startSoundInstance(user);
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void startSoundInstance(class_1657 user) {
        class_310.method_1551().method_1483().method_4873((class_1113)new EnderSpliceChargingSoundInstance(user));
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 48;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        Optional<class_3545<class_5321<class_1937>, class_243>> teleportTargetPos = EnderSpliceItem.getTeleportTargetPos(stack);
        if (teleportTargetPos.isPresent()) {
            String dimensionDisplayString = Support.getReadableDimensionString(((class_5321)teleportTargetPos.get().method_15442()).method_29177().toString());
            class_243 pos = (class_243)teleportTargetPos.get().method_15441();
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.ender_splice.tooltip.bound_pos", (Object[])new Object[]{(int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350, dimensionDisplayString}));
            return;
        }
        Optional<UUID> teleportTargetPlayerUUID = EnderSpliceItem.getTeleportTargetPlayerUUID(stack);
        if (teleportTargetPlayerUUID.isPresent()) {
            Optional<String> teleportTargetPlayerName = EnderSpliceItem.getTeleportTargetPlayerName(stack);
            if (teleportTargetPlayerName.isPresent()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.ender_splice.tooltip.bound_player", (Object[])new Object[]{teleportTargetPlayerName.get()}));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.ender_splice.tooltip.bound_player", (Object[])new Object[]{"???"}));
            }
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.ender_splice.tooltip.unbound"));
    }

    public static Optional<class_3545<class_5321<class_1937>, class_243>> getTeleportTargetPos(@NotNull class_1799 itemStack) {
        EnderSpliceComponent component = (EnderSpliceComponent)itemStack.method_57825(SpectrumDataComponentTypes.ENDER_SPLICE, (Object)EnderSpliceComponent.DEFAULT);
        if (component.pos().isPresent() && component.dimension().isPresent()) {
            return Optional.of(new class_3545(component.dimension().get(), (Object)component.pos().get()));
        }
        return Optional.empty();
    }

    public static Optional<UUID> getTeleportTargetPlayerUUID(@NotNull class_1799 itemStack) {
        return ((EnderSpliceComponent)itemStack.method_57825(SpectrumDataComponentTypes.ENDER_SPLICE, (Object)EnderSpliceComponent.DEFAULT)).targetUUID();
    }

    public static Optional<String> getTeleportTargetPlayerName(@NotNull class_1799 itemStack) {
        return ((EnderSpliceComponent)itemStack.method_57825(SpectrumDataComponentTypes.ENDER_SPLICE, (Object)EnderSpliceComponent.DEFAULT)).targetName();
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 50;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return super.canBeEnchantedWith(stack, enchantment, context) || enchantment.method_40225(class_1893.field_9119);
    }
}

