/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.helpers.BuildingHelper;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.items.magic_items.BuildingStaffItem;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

public class ExchangeStaffItem
extends BuildingStaffItem {
    public static final int INK_COST_PER_BLOCK = 5;
    public static final int CREATIVE_RANGE = 5;

    public ExchangeStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static int getRange(class_1657 playerEntity) {
        if (playerEntity == null || playerEntity.method_7337()) {
            return 5;
        }
        Optional<PedestalRecipeTier> highestUnlockedRecipeTier = PedestalRecipeTier.getHighestUnlockedRecipeTier(playerEntity);
        if (highestUnlockedRecipeTier.isPresent()) {
            switch (highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    return 5;
                }
                case ADVANCED: {
                    return 4;
                }
            }
            return 3;
        }
        return 2;
    }

    @Override
    public boolean canInteractWith(class_2680 state, class_1922 world, class_2338 pos, class_1657 player) {
        return super.canInteractWith(state, world, pos, player) && state.method_26214(world, pos) < 20.0f;
    }

    public static boolean exchange(class_1937 world, class_2338 pos, @NotNull class_1657 player, @NotNull class_2248 targetBlock, class_1799 exchangeStaffItemStack, class_2350 side) {
        return ExchangeStaffItem.exchange(world, pos, player, targetBlock, exchangeStaffItemStack, false, side);
    }

    public static boolean exchange(class_1937 world, class_2338 pos, @NotNull class_1657 player, @NotNull class_2248 targetBlock, class_1799 exchangeStaffItemStack, boolean single, class_2350 side) {
        Triplet<class_2248, class_1792, Integer> replaceData = ExchangeStaffItem.countSuitableReplacementItems(player, targetBlock, single, 5);
        long blocksToReplaceCount = ((Integer)replaceData.getC()).intValue();
        if (blocksToReplaceCount == 0L) {
            return false;
        }
        targetBlock = (class_2248)replaceData.getA();
        class_1792 consumedItem = (class_1792)replaceData.getB();
        int range = ExchangeStaffItem.getRange(player);
        List<class_2338> targetPositions = BuildingHelper.getConnectedBlocks(world, pos, blocksToReplaceCount, range);
        if (targetPositions.isEmpty()) {
            return false;
        }
        int blocksReplaced = 0;
        if (!world.field_9236) {
            ArrayList stacks = new ArrayList();
            for (class_2338 targetPosition : targetPositions) {
                if (!GenericClaimModsCompat.canModify(world, pos, (class_1297)player)) continue;
                if (!player.method_7337()) {
                    class_2680 droppedStacks = world.method_8320(targetPosition);
                    stacks.addAll(class_2248.method_9609((class_2680)droppedStacks, (class_3218)((class_3218)world), (class_2338)targetPosition, (class_2586)world.method_8321(targetPosition), (class_1297)player, (class_1799)exchangeStaffItemStack));
                }
                world.method_8501(targetPosition, class_2246.field_10124.method_9564());
                class_2680 stateToPlace = targetBlock.method_9605((class_1750)new BuildingStaffItem.BuildingStaffPlacementContext(world, player, new class_3965(class_243.method_24955((class_2382)targetPosition), side, targetPosition, false)));
                if (stateToPlace != null && stateToPlace.method_26184((class_4538)world, targetPosition)) {
                    if (blocksReplaced == 0) {
                        world.method_8396(null, player.method_24515(), stateToPlace.method_26231().method_10598(), class_3419.field_15248, stateToPlace.method_26231().method_10597(), stateToPlace.method_26231().method_10599());
                    }
                    if (!world.method_8501(targetPosition, stateToPlace)) {
                        class_1542 itemEntity = new class_1542(world, (double)targetPosition.method_10263(), (double)targetPosition.method_10264(), (double)targetPosition.method_10260(), new class_1799((class_1935)consumedItem));
                        itemEntity.method_48349(player.method_5667());
                        itemEntity.method_6975();
                        world.method_8649((class_1297)itemEntity);
                    }
                }
                ++blocksReplaced;
            }
            if (!player.method_7337()) {
                InventoryHelper.removeFromInventoryWithRemainders(player, new class_1799((class_1935)consumedItem, targetPositions.size()));
                for (class_1799 stack : stacks) {
                    player.method_31548().method_7398(stack);
                }
                InkPowered.tryDrainEnergy(player, USED_COLOR, (long)targetPositions.size() * 5L);
            }
        }
        return true;
    }

    public void storeBlockAsTarget(@NotNull class_1799 exchangeStaffItemStack, class_2248 block) {
        exchangeStaffItemStack.method_57379(SpectrumDataComponentTypes.STORED_BLOCK, (Object)class_7923.field_41175.method_10221((Object)block));
    }

    public static Optional<class_2248> getStoredBlock(@NotNull class_1799 exchangeStaffItemStack) {
        class_2248 targetBlock;
        class_2960 blockId = (class_2960)exchangeStaffItemStack.method_57824(SpectrumDataComponentTypes.STORED_BLOCK);
        if (blockId != null && (targetBlock = (class_2248)class_7923.field_41175.method_10223(blockId)) != class_2246.field_10124) {
            return Optional.of(targetBlock);
        }
        return Optional.empty();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.exchanging_staff.tooltip.range", (Object[])new Object[]{ExchangeStaffItem.getRange((class_1657)class_310.method_1551().field_1724)}).method_27692(class_124.field_1080));
        ExchangeStaffItem.getStoredBlock(stack).ifPresent(block -> tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.exchanging_staff.tooltip.target", (Object[])new Object[]{block.method_9518()}).method_27692(class_124.field_1080)));
        this.addInkPoweredTooltip(tooltip);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 targetBlockState = world.method_8320(pos);
        class_2248 targetBlock = targetBlockState.method_26204();
        if (!this.canInteractWith(targetBlockState, (class_1922)context.method_8045(), context.method_8037(), context.method_8036())) {
            world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5814;
        }
        class_1799 staffStack = context.method_8041();
        if (player.method_5715()) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                this.storeBlockAsTarget(staffStack, targetBlock);
                class_2350 side = context.method_8038();
                class_243 sourcePos = new class_243(context.method_17698().method_10216() + (double)side.method_10148() * 0.1, context.method_17698().method_10214() + (double)side.method_10164() * 0.1, context.method_17698().method_10215() + (double)side.method_10165() * 0.1);
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(serverWorld, sourcePos, (class_2394)SpectrumParticleTypes.SHIMMERSTONE_SPARKLE_SMALL, 15, class_243.field_1353, new class_243(0.25, 0.25, 0.25));
                world.method_8396(null, player.method_24515(), SpectrumSoundEvents.EXCHANGING_STAFF_SELECT, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        Optional<class_2248> storedBlock = ExchangeStaffItem.getStoredBlock(staffStack);
        if (storedBlock.isPresent() && storedBlock.get() != targetBlock && storedBlock.get().method_8389() != class_1802.field_8162 && ExchangeStaffItem.exchange(world, pos, player, storedBlock.get(), staffStack, context.method_8038())) {
            return class_1269.method_29236((boolean)world.field_9236);
        }
        world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
        return class_1269.field_5814;
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 3;
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return super.canBeEnchantedWith(stack, enchantment, context) || enchantment.method_40225(class_1893.field_9130) || enchantment.method_40225(class_1893.field_9099);
    }
}

