/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.blocks.decoration.PersistentLightBlock;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class RadianceStaffItem
extends class_1792
implements InkPowered {
    public static final int USE_DURATION = 12;
    public static final int REACH_STEP_DISTANCE = 4;
    public static final int MAX_REACH_STEPS = 8;
    public static final int PLACEMENT_TRIES_PER_STEP = 4;
    public static final int MIN_LIGHT_LEVEL = 10;
    public static final InkCost INK_COST = new InkCost(InkColors.YELLOW, 10L);
    public static final class_1856 COST = class_1856.method_8106(SpectrumItemTags.RADIANCE_STAFF_CONSUMABLE);

    public RadianceStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean placeLight(class_1937 world, class_2338 targetPos, class_3222 playerEntity, class_1799 radianceStaff) {
        if (!GenericClaimModsCompat.canPlaceBlock(world, targetPos, (class_1297)playerEntity)) {
            return false;
        }
        class_2680 targetBlockState = world.method_8320(targetPos);
        if (targetBlockState.method_26215()) {
            if (this.payForStaffUse((class_1657)playerEntity, radianceStaff, INK_COST, COST)) {
                world.method_8652(targetPos, SpectrumBlocks.PERSISTENT_LIGHT.method_9564(), 3);
                return true;
            }
        } else if (targetBlockState.method_27852(class_2246.field_10382) && this.payForStaffUse((class_1657)playerEntity, radianceStaff, INK_COST, COST)) {
            world.method_8652(targetPos, (class_2680)SpectrumBlocks.PERSISTENT_LIGHT.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public static void playSoundAndParticles(class_1937 world, class_2338 targetPos, class_3222 playerEntity, int useTimes, int iteration) {
        float pitch = useTimes % 2 == 0 ? Math.min(1.35f, 0.7f + 0.1f * (float)useTimes) : Math.min(1.5f, 0.7f + 0.1f * (float)useTimes);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, class_243.method_24953((class_2382)targetPos), (class_2394)SpectrumParticleTypes.SHIMMERSTONE_SPARKLE, 20, class_243.field_1353, new class_243(0.3, 0.3, 0.3));
        world.method_43128(null, playerEntity.method_23317() + 0.5, playerEntity.method_23318() + 0.5, playerEntity.method_23321() + 0.5, SpectrumSoundEvents.RADIANCE_STAFF_PLACE, class_3419.field_15248, (float)Math.max(0.25, (double)(1.0f - (float)iteration * 0.1f)), pitch);
    }

    public static void playDenySound(class_1937 world, class_1657 playerEntity) {
        world.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 0.8f + playerEntity.method_59922().method_43057() * 0.4f);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (InkPowered.canUseClient()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.radiance_staff.tooltip.ink", (Object[])new Object[]{INK_COST.color().getColoredInkName()}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.radiance_staff.tooltip"));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.radiance_staff.tooltip2"));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.radiance_staff.tooltip3"));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.RADIANCE_STAFF_CHARGING, class_3419.field_15248, 1.0f, 1.0f);
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (user instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)user;
            if (user.method_6048() > 12 && user.method_6048() % 12 == 0) {
                this.usage(world, serverPlayerEntity, stack);
            }
        }
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }
        class_2338 pos = context.method_8037();
        class_2350 direction = context.method_8038();
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof PersistentLightBlock) {
            class_2680 newState = (class_2680)state.method_28493((class_2769)class_2741.field_12538);
            if ((Integer)newState.method_11654((class_2769)class_2741.field_12538) == 0) {
                newState = (class_2680)newState.method_28493((class_2769)class_2741.field_12538);
            }
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, SpectrumSoundEvents.RADIANCE_STAFF_PLACE, class_3419.field_15248, 1.0f, (float)(0.75 + 0.05 * (double)((Integer)newState.method_11654((class_2769)class_2741.field_12538)).intValue()));
            world.method_8652(pos, newState, 2);
        } else {
            class_2338 targetPos = pos.method_10093(direction);
            if (this.placeLight(world, targetPos, (class_3222)player, context.method_8041())) {
                RadianceStaffItem.playSoundAndParticles(world, targetPos, (class_3222)player, world.field_9229.method_43048(5), world.field_9229.method_43048(5));
            } else {
                RadianceStaffItem.playDenySound(world, player);
            }
        }
        return class_1269.field_21466;
    }

    public void usage(class_1937 world, class_3222 user, class_1799 radianceStaff) {
        int useTimes = user.method_6048() / 12;
        int maxCheckDistance = Math.min(8, useTimes);
        class_2338 sourcePos = user.method_24515();
        class_243 cameraVec = user.method_5828(0.0f);
        for (int iteration = 1; iteration < maxCheckDistance; ++iteration) {
            class_2338 targetPos = sourcePos.method_10069(class_3532.method_15357((double)(cameraVec.field_1352 * (double)iteration * 4.0)), class_3532.method_15357((double)(cameraVec.field_1351 * (double)iteration * 4.0)), class_3532.method_15357((double)(cameraVec.field_1350 * (double)iteration * 4.0)));
            boolean success = false;
            for (int tries = 0; tries < 4; ++tries) {
                if (world.method_8314(class_1944.field_9282, targetPos = targetPos.method_10069(iteration - world.method_8409().method_43048(2 * iteration), iteration - world.method_8409().method_43048(2 * iteration), iteration - world.method_8409().method_43048(2 * iteration))) >= 10 || !this.placeLight(world, targetPos, user, radianceStaff)) continue;
                success = true;
                RadianceStaffItem.playSoundAndParticles(world, targetPos, user, useTimes, iteration);
            }
            if (success) continue;
            RadianceStaffItem.playDenySound(world, (class_1657)user);
        }
    }

    public int method_7837() {
        return 8;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return super.canBeEnchantedWith(stack, enchantment, context) || enchantment.method_40225(class_1893.field_9131);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(INK_COST.color());
    }
}

