/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.item.PrioritizedEntityInteraction;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.particle.effect.ColoredExplosionParticleEffect;
import de.dafuqs.spectrum.particle.effect.ColoredSparkleRisingParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumAdvancements;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEntityTypeTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class StaffOfRemembranceItem
extends class_1792
implements InkPowered,
PrioritizedEntityInteraction {
    public static final InkColor USED_COLOR = InkColors.LIGHT_GRAY;
    public static final InkCost TURN_NEUTRAL_TO_MEMORY_COST = new InkCost(USED_COLOR, 1000L);
    public static final InkCost TURN_HOSTILE_TO_MEMORY_COST = new InkCost(USED_COLOR, 5000L);
    public static final InkCost CREATE_PLAYER_MEMORY_COST = new InkCost(USED_COLOR, 5000L);

    public StaffOfRemembranceItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.staff_of_remembrance.tooltip").method_27692(class_124.field_1080));
        this.addInkPoweredTooltip(tooltip);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        class_1937 world = user.method_37908();
        class_243 pos = entity.method_19538();
        if (!GenericClaimModsCompat.canInteract(world, (class_1297)entity, (class_1297)user)) {
            return class_1269.field_5814;
        }
        if (!world.field_9236) {
            if (this.turnEntityToMemory(user, entity)) {
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, entity.method_19538(), ColoredSparkleRisingParticleEffect.LIGHT_GRAY, 10, class_243.field_1353, new class_243(0.2, 0.2, 0.2));
                PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity((class_3218)world, entity.method_19538(), ColoredExplosionParticleEffect.LIGHT_GRAY, 1, class_243.field_1353);
                world.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), SpectrumSoundEvents.RADIANCE_STAFF_PLACE, class_3419.field_15248, 1.0f, 0.8f + world.field_9229.method_43057() * 0.4f);
            } else {
                world.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 0.8f + world.field_9229.method_43057() * 0.4f);
            }
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    private boolean turnEntityToMemory(class_1657 user, class_1309 entity) {
        if (!entity.method_5805() || entity.method_31481() || entity.method_5782()) {
            return false;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (!InkPowered.tryDrainEnergy(user, CREATE_PLAYER_MEMORY_COST)) {
                return false;
            }
            entity.method_5643(SpectrumDamageTypes.remembrance(user.method_37908(), (class_1309)user), 4.0f);
            class_1799 memoryStack = MemoryItem.getForPlayer(player, 4);
            MemoryItem.setTicksToManifest(memoryStack, 1);
            class_243 entityPos = entity.method_19538();
            class_1542 itemEntity = new class_1542(entity.method_37908(), entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), memoryStack);
            itemEntity.method_18799(new class_243(0.0, 0.15, 0.0));
            entity.method_37908().method_8649((class_1297)itemEntity);
            return true;
        }
        if (!(entity instanceof class_1308)) {
            return false;
        }
        class_1308 mob = (class_1308)entity;
        class_1299 entityType = mob.method_5864();
        if (entityType.method_20210(SpectrumEntityTypeTags.STAFF_OF_REMEMBRANCE_BLACKLISTED)) {
            return false;
        }
        class_1311 spawnGroup = entityType.method_5891();
        if (spawnGroup == class_1311.field_6302) {
            if (!user.method_7337() && !AdvancementHelper.hasAdvancement((class_1657)user, (class_2960)SpectrumAdvancements.HOSTILE_MEMORIZING)) {
                return false;
            }
            if (!InkPowered.tryDrainEnergy(user, TURN_HOSTILE_TO_MEMORY_COST)) {
                return false;
            }
        } else if (!InkPowered.tryDrainEnergy(user, TURN_NEUTRAL_TO_MEMORY_COST)) {
            return false;
        }
        mob.method_5932(true, true);
        mob.method_5966();
        mob.method_5990();
        class_1799 memoryStack = MemoryItem.getMemoryForEntity(entity);
        MemoryItem.setTicksToManifest(memoryStack, 1);
        MemoryItem.setSpawnAsAdult(memoryStack, true);
        class_243 entityPos = mob.method_19538();
        class_1542 itemEntity = new class_1542(mob.method_37908(), entityPos.method_10216(), entityPos.method_10214(), entityPos.method_10215(), memoryStack);
        itemEntity.method_18799(new class_243(0.0, 0.15, 0.0));
        mob.method_37908().method_8649((class_1297)itemEntity);
        mob.method_5650(class_1297.class_5529.field_26999);
        return true;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }
}

