/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.tools.MalachiteBidentItem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FerociousBidentItem
extends MalachiteBidentItem
implements SlotBackgroundEffectProvider,
InkPowered {
    public static final InkCost RIPTIDE_COST = new InkCost(InkColors.WHITE, 10L);
    public static final int BUILTIN_RIPTIDE_LEVEL = 1;

    public FerociousBidentItem(class_1792.class_1793 settings, double attackSpeed, double damage, float armorPierce, float protPierce) {
        super(settings, attackSpeed, damage, armorPierce, protPierce);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(RIPTIDE_COST.color());
    }

    @Override
    public int getRiptideLevel(class_7225.class_7874 lookup, class_1799 stack) {
        return Math.max(SpectrumEnchantmentHelper.getLevel(lookup, (class_5321<class_1887>)class_1893.field_9104, stack), 1);
    }

    @Override
    public boolean canStartRiptide(class_1657 player, class_1799 stack) {
        return !this.isDisabled(stack) && (super.canStartRiptide(player, stack) || InkPowered.tryDrainEnergy(player, RIPTIDE_COST));
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
        if (user.method_6123() && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int useTime = this.method_7881(stack, user) - remainingUseTicks;
            if (useTime % 10 == 0) {
                if (InkPowered.tryDrainEnergy(player, RIPTIDE_COST)) {
                    stack.method_7970(1, user, class_1309.method_56079((class_1268)user.method_6058()));
                } else {
                    user.method_6075();
                    return;
                }
            }
            this.yeetPlayer(player, (float)this.getRiptideLevel((class_7225.class_7874)world.method_30349(), stack) / 128.0f - 0.75f);
            player.method_40126(20, 12.0f, stack);
            for (class_1309 entityAround : world.method_18023(class_5575.method_31795(class_1309.class), player.method_5829().method_1014(2.0), class_1309::method_5805)) {
                if (entityAround == player) continue;
                entityAround.method_5643(world.method_48963().method_48802(player), 2.0f);
            }
        }
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.ferocious_glass_crest_bident.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.ferocious_glass_crest_bident.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.ferocious_glass_crest_bident.tooltip3").method_27692(class_124.field_1080));
        this.addInkPoweredTooltip(tooltip);
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        boolean usable = InkPowered.hasAvailableInk(player, RIPTIDE_COST);
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return -427219;
    }

    @Override
    public float getDefenseMultiplier(class_1309 target, class_1799 stack) {
        return 0.66f;
    }

    @Override
    public float getProtReduction(class_1309 target, class_1799 stack) {
        return 0.33f;
    }
}

