/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.interaction.OmniAcceleratorProjectile;
import de.dafuqs.spectrum.api.render.DynamicItemRenderer;
import de.dafuqs.spectrum.api.render.ExtendedItemBarProvider;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5328;
import net.minecraft.class_5537;
import net.minecraft.class_7225;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OmniAcceleratorItem
extends class_5537
implements InkPowered,
ExtendedItemBarProvider,
SlotBackgroundEffectProvider {
    protected static final InkCost COST = new InkCost(InkColors.YELLOW, 20L);
    protected static final int CHARGE_TIME = 10;

    public OmniAcceleratorItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 10;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!(user instanceof class_3222)) {
            return stack;
        }
        class_3222 player = (class_3222)user;
        Optional<class_1799> shootStackOptional = OmniAcceleratorItem.getFirstStack((class_7225.class_7874)world.method_30349(), stack);
        if (shootStackOptional.isEmpty()) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
            return stack;
        }
        if (!InkPowered.tryDrainEnergy((class_1657)player, COST)) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 1.0f);
            return stack;
        }
        class_1799 shootStack = shootStackOptional.get();
        OmniAcceleratorProjectile projectile = OmniAcceleratorProjectile.get(shootStack);
        if (projectile.createProjectile(shootStack, user, world, stack) != null) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), projectile.getSoundEffect(), class_3419.field_15248, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
            if (!player.method_7337()) {
                OmniAcceleratorItem.decrementFirstItem(stack);
            }
        }
        return stack;
    }

    public static void decrementFirstItem(class_1799 acceleratorStack) {
        class_9276 comp = (class_9276)acceleratorStack.method_57824(class_9334.field_49650);
        if (comp == null) {
            return;
        }
        class_9276.class_9277 builder = new class_9276.class_9277(class_9276.field_49289);
        boolean first = true;
        for (class_1799 stack : comp.method_59708()) {
            if (first) {
                stack.method_7934(1);
                first = false;
            }
            if (stack.method_7960()) continue;
            builder.method_57432(stack);
        }
        acceleratorStack.method_57379(class_9334.field_49650, (Object)builder.method_57435());
    }

    public static Optional<class_1799> getFirstStack(class_7225.class_7874 wrapperLookup, class_1799 stack) {
        class_9276 contents = (class_9276)stack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289);
        return contents.method_57429() ? Optional.empty() : Optional.of(contents.method_57422(0).method_7972());
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(COST.color());
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        this.addInkPoweredTooltip(tooltip);
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        boolean usable = InkPowered.hasAvailableInk(player, COST);
        return usable ? SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE : SlotBackgroundEffectProvider.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return 0xFFFFFF;
    }

    @Override
    public int barCount(class_1799 stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable class_1657 player, class_1799 stack) {
        if (player == null || player.method_5998(player.method_6058()) != stack) {
            return true;
        }
        return !player.method_6115();
    }

    @Override
    public ExtendedItemBarProvider.BarSignature getSignature(@Nullable class_1657 player, @NotNull class_1799 stack, int index) {
        if (player == null || !player.method_6115()) {
            return ExtendedItemBarProvider.PASS;
        }
        class_1799 activeStack = player.method_5998(player.method_6058());
        if (activeStack != stack) {
            return ExtendedItemBarProvider.PASS;
        }
        int progress = Math.round(class_3532.method_37166((float)0.0f, (float)13.0f, (float)((float)player.method_6048() / 10.0f)));
        return new ExtendedItemBarProvider.BarSignature(2, 13, 13, progress, 1, -1, 2, -16777216);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Renderer
    implements DynamicItemRenderer {
        @Override
        public void render(class_918 renderer, class_1799 stack, class_811 mode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1087 model) {
            renderer.method_23179(stack, mode, leftHanded, matrices, vertexConsumers, light, overlay, model);
            class_310 client = class_310.method_1551();
            if (mode != class_811.field_4317 || client.field_1687 == null) {
                return;
            }
            Optional<class_1799> optionalStack = OmniAcceleratorItem.getFirstStack((class_7225.class_7874)client.field_1687.method_30349(), stack);
            if (optionalStack.isEmpty()) {
                return;
            }
            class_1799 bundledStack = optionalStack.get();
            class_1087 bundledModel = renderer.method_4019(bundledStack, (class_1937)client.field_1687, (class_1309)client.field_1724, 0);
            matrices.method_22903();
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            renderer.method_23179(bundledStack, mode, leftHanded, matrices, vertexConsumers, light, overlay, bundledModel);
            matrices.method_22909();
        }
    }
}

