/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tooltip;

import de.dafuqs.spectrum.api.gui.SpectrumTooltipComponent;
import de.dafuqs.spectrum.items.tooltip.BottomlessBundleTooltipData;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class BottomlessBundleTooltipComponent
implements SpectrumTooltipComponent {
    private static final int MAX_DISPLAYED_SLOTS = 5;
    private final List<class_1799> itemStacks;
    private final int displayedSlotCount;
    private final boolean drawDots;

    public BottomlessBundleTooltipComponent(BottomlessBundleTooltipData data) {
        long amount = data.amount();
        long maxCount = data.variant().getItem().method_7882();
        double totalStacks = (float)amount / (float)maxCount;
        this.displayedSlotCount = Math.max(2, Math.min(6, (int)Math.ceil(totalStacks) + 1));
        this.itemStacks = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        for (int i = 0; i < Math.min(5, this.displayedSlotCount + 1); ++i) {
            class_1799 slotStack = data.variant().toStack();
            long stackAmount = Math.min(Math.min(maxCount, amount - (long)i * maxCount), Integer.MAX_VALUE);
            slotStack.method_7939((int)stackAmount);
            this.itemStacks.set(i, slotStack);
        }
        this.drawDots = totalStacks > 5.0;
    }

    public int method_32661() {
        return 26;
    }

    public int method_32664(class_327 textRenderer) {
        return this.displayedSlotCount * 20 + 2 + 4;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        int n = x + 1;
        int o = y + 1;
        for (int i = 0; i < Math.min(6, this.displayedSlotCount); ++i) {
            if (i == this.displayedSlotCount - 1) {
                if (this.displayedSlotCount == 6) {
                    if (this.drawDots) {
                        SpectrumTooltipComponent.drawDottedSlot(context, n + 90, o);
                        continue;
                    }
                    SpectrumTooltipComponent.drawSlot(context, n + i * 18, o, i, class_1799.field_8037, textRenderer);
                    continue;
                }
                if (this.itemStacks.size() - 1 < i) {
                    SpectrumTooltipComponent.drawSlot(context, n + i * 18, o, i, class_1799.field_8037, textRenderer);
                    continue;
                }
                SpectrumTooltipComponent.drawSlot(context, n + i * 18, o, i, this.itemStacks.get(i), textRenderer);
                continue;
            }
            SpectrumTooltipComponent.drawSlot(context, n + i * 18, o, i, this.itemStacks.get(i), textRenderer);
        }
        SpectrumTooltipComponent.drawOutline(context, x, y, this.displayedSlotCount, 1);
    }
}

