/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import com.google.common.collect.Multimap;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.render.SlotBackgroundEffectProvider;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeProvider;
import de.dafuqs.spectrum.items.trinkets.AzureDikeTrinketItem;
import de.dafuqs.spectrum.items.trinkets.SingleSlotGlove;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class AetherGracedNectarGlovesItem
extends AzureDikeTrinketItem
implements SlotBackgroundEffectProvider,
SingleSlotGlove {
    public static final int HARMFUL_EFFECT_COST = 7;
    public static class_2960 MENTAL_PRESENCE_ATTRIBUTE_ID = SpectrumCommon.locate("nectar_gloves_sleep");

    public AetherGracedNectarGlovesItem(class_1792.class_1793 settings, class_2960 unlockIdentifier) {
        super(settings, unlockIdentifier);
    }

    @Override
    public int maxAzureDike(class_1799 stack) {
        return 10;
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.aether_graced_nectar_gloves.tooltip"));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.aether_graced_nectar_gloves.tooltip2"));
    }

    public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
        modifiers.put(SpectrumEntityAttributes.MENTAL_PRESENCE, (Object)new class_1322(MENTAL_PRESENCE_ATTRIBUTE_ID, -1.0, class_1322.class_1323.field_6328));
        SingleSlotGlove.disableSecondGloveSlot((Multimap<class_6880<class_1320>, class_1322>)modifiers);
        return modifiers;
    }

    public static boolean testEffectFor(class_1309 entity, class_6880<class_1291> effect) {
        if (((class_1291)effect.comp_349()).method_5573()) {
            return false;
        }
        if (effect.method_40220(SpectrumStatusEffectTags.BYPASSES_NECTAR_GLOVES)) {
            return false;
        }
        Optional trinkets = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (trinkets.isEmpty()) {
            return false;
        }
        TrinketComponent component = (TrinketComponent)trinkets.get();
        return component.isEquipped(SpectrumItems.AETHER_GRACED_NECTAR_GLOVES) && (((class_1291)effect.comp_349()).method_18792() == class_4081.field_18272 || effect == SpectrumStatusEffects.FRENZY);
    }

    public static boolean tryBlockEffect(class_1309 entity, int cost) {
        if (AzureDikeProvider.getAzureDikeCharges(entity) == 0.0f) {
            return false;
        }
        return AzureDikeProvider.absorbDamage(entity, cost) == 0.0f;
    }

    @Override
    public SlotBackgroundEffectProvider.SlotEffect backgroundType(@Nullable class_1657 player, class_1799 stack) {
        return SlotBackgroundEffectProvider.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable class_1657 player, class_1799 stack, float tickDelta) {
        return 12804078;
    }
}

