/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import de.dafuqs.spectrum.networking.s2c_payloads.PlayTakeOffBeltSoundInstancePayload;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.particle.effect.ColoredCraftingParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import dev.emi.trinkets.api.SlotReference;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public class TakeOffBeltItem
extends SpectrumTrinketItem {
    public static final int CHARGE_TIME_TICKS = 20;
    public static final int MAX_CHARGES = 8;
    private static final HashMap<class_1309, Long> sneakingTimes = new HashMap();

    public TakeOffBeltItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/take_off_belt"));
    }

    public static int getJumpBoostAmplifier(int sneakTime, int powerEnchantmentLevel) {
        return (int)Math.floor((double)sneakTime * (2.0 + (double)powerEnchantmentLevel * 0.5));
    }

    public static int getCurrentCharge(class_1657 playerEntity) {
        if (sneakingTimes.containsKey(playerEntity)) {
            return (int)(playerEntity.method_37908().method_8510() - sneakingTimes.get(playerEntity)) / 20;
        }
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.take_off_belt.tooltip").method_27692(class_124.field_1080));
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        class_1937 world = entity.method_37908();
        super.tick(stack, slot, entity);
        if (!world.field_9236) {
            long lastSneakingTime;
            if (entity.method_5715() && entity.method_24828()) {
                if (sneakingTimes.containsKey(entity)) {
                    long sneakTicks = world.method_8510() - sneakingTimes.get(entity);
                    if (sneakTicks % 20L == 0L) {
                        if (sneakTicks > 160L) {
                            world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 4.0f, 1.05f);
                            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((class_3218)world, entity.method_19538(), ColoredCraftingParticleEffect.BLACK, 20, new class_243(0.0, 0.0, 0.0), new class_243(0.1, 0.05, 0.1));
                            entity.method_6016(class_1294.field_5913);
                        } else {
                            int sneakTimeMod = (int)sneakTicks / 20;
                            world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), SpectrumSoundEvents.BLOCK_TOPAZ_BLOCK_HIT, class_3419.field_15254, 1.0f, 1.0f);
                            for (class_243 vec : VectorPattern.SIXTEEN.getVectors()) {
                                PlayParticleWithExactVelocityPayload.playParticleWithExactVelocity((class_3218)world, entity.method_19538(), (class_2394)SpectrumParticleTypes.LIQUID_CRYSTAL_SPARKLE, 1, vec.method_1021(0.5));
                            }
                            int powerEnchantmentLevel = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)world.method_30349(), (class_5321<class_1887>)class_1893.field_9103, stack);
                            int featherFallingEnchantmentLevel = SpectrumEnchantmentHelper.getLevel((class_7225.class_7874)world.method_30349(), (class_5321<class_1887>)class_1893.field_9129, stack);
                            entity.method_6092(new class_1293(class_1294.field_5913, 20, TakeOffBeltItem.getJumpBoostAmplifier(sneakTimeMod, powerEnchantmentLevel), true, true));
                            if (featherFallingEnchantmentLevel > 0) {
                                entity.method_6092(new class_1293(class_1294.field_5906, 20 + featherFallingEnchantmentLevel * 20, 0, true, true));
                            }
                        }
                    }
                } else {
                    sneakingTimes.put(entity, world.method_8510());
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)entity;
                        PlayTakeOffBeltSoundInstancePayload.sendPlayTakeOffBeltSoundInstance(serverPlayerEntity);
                    }
                }
            } else if (world.method_8510() % 20L == 0L && sneakingTimes.containsKey(entity) && (lastSneakingTime = sneakingTimes.get(entity).longValue()) < world.method_8510() + 20L) {
                sneakingTimes.remove(entity);
            }
        }
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 8;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return super.canBeEnchantedWith(stack, enchantment, context) || enchantment.method_40225(class_1893.field_9103) || enchantment.method_40225(class_1893.field_9129);
    }
}

