/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.loot.SpectrumLootFunctionTypes;
import de.dafuqs.spectrum.mixin.accessors.BiomeAccessor;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1860;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

public class FermentRandomlyLootFunction
extends class_120 {
    public static final MapCodec<FermentRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(i -> FermentRandomlyLootFunction.method_53344((RecordCodecBuilder.Instance)i).and(i.group((App)Codec.either((Codec)class_2960.field_25139, FermentationData.CODEC).fieldOf("fermentation").forGetter(c -> c.fermentation), (App)class_5659.field_45888.fieldOf("days_fermented").forGetter(c -> c.daysFermented), (App)class_5659.field_45888.fieldOf("thickness").forGetter(c -> c.thickness))).apply((Applicative)i, FermentRandomlyLootFunction::new));
    private final Either<class_2960, FermentationData> fermentation;
    private final class_5658 daysFermented;
    private final class_5658 thickness;

    public FermentRandomlyLootFunction(List<class_5341> conditions, Either<class_2960, FermentationData> fermentation, class_5658 daysFermented, class_5658 thickness) {
        super(conditions);
        this.fermentation = fermentation;
        this.daysFermented = daysFermented;
        this.thickness = thickness;
    }

    public FermentRandomlyLootFunction(List<class_5341> conditions, @NotNull class_2960 fermentationRecipeIdentifier, class_5658 daysFermented, class_5658 thickness) {
        this(conditions, (Either<class_2960, FermentationData>)Either.left((Object)fermentationRecipeIdentifier), daysFermented, thickness);
    }

    public FermentRandomlyLootFunction(List<class_5341> conditions, @NotNull FermentationData fermentationData, class_5658 daysFermented, class_5658 thickness) {
        this(conditions, (Either<class_2960, FermentationData>)Either.right((Object)fermentationData), daysFermented, thickness);
    }

    public class_5339<? extends class_120> method_29321() {
        return SpectrumLootFunctionTypes.FERMENT_RANDOMLY;
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        FermentationData fermentationData = (FermentationData)this.fermentation.map(id -> {
            class_1860 patt0$temp;
            Optional recipe = context.method_299().method_8433().method_8130(id);
            if (recipe.isPresent() && (patt0$temp = ((class_8786)recipe.get()).comp_1933()) instanceof TitrationBarrelRecipe) {
                TitrationBarrelRecipe titrationBarrelRecipe = (TitrationBarrelRecipe)patt0$temp;
                return titrationBarrelRecipe.getFermentationData();
            }
            SpectrumCommon.logError("A 'spectrum:ferment_randomly' loot function has set an invalid 'fermentation_recipe_id': " + String.valueOf(id) + " It has to match an existing Titration Barrel recipe.");
            return null;
        }, data -> this.fermentation.right().orElse(null));
        if (fermentationData != null) {
            class_243 origin = (class_243)context.method_296(class_181.field_24424);
            if (origin != null) {
                class_2338 pos = class_2338.method_49638((class_2374)origin);
                class_1959 biome = (class_1959)context.method_299().method_23753(pos).comp_349();
                float downfall = ((BiomeAccessor)biome).getClimateSettings().comp_846();
                return TitrationBarrelRecipe.getFermentedStack(fermentationData, this.thickness.method_366(context), TimeHelper.secondsFromMinecraftDays(this.daysFermented.method_366(context)), downfall, stack);
            }
            SpectrumCommon.logError("A 'spectrum:ferment_randomly' loot function does not have access to 'origin'.");
        }
        return stack;
    }

    public static class_120.class_121<?> builder(FermentationData fermentationData, class_5658 daysFermented, class_5658 thickness) {
        return FermentRandomlyLootFunction.method_520(conditions -> new FermentRandomlyLootFunction((List<class_5341>)conditions, fermentationData, daysFermented, thickness));
    }

    public static class_120.class_121<?> builder(class_2960 fermentationRecipeIdentifier, class_5658 daysFermented, class_5658 thickness) {
        return FermentRandomlyLootFunction.method_520(conditions -> new FermentRandomlyLootFunction((List<class_5341>)conditions, fermentationRecipeIdentifier, daysFermented, thickness));
    }
}

