/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import de.dafuqs.spectrum.api.item.DamageAwareItem;
import de.dafuqs.spectrum.api.item.GravitableItem;
import de.dafuqs.spectrum.api.item.ItemDamageImmunity;
import de.dafuqs.spectrum.api.item.TickAwareItem;
import de.dafuqs.spectrum.recipe.primordial_fire_burning.PrimordialFireBurningRecipe;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantmentTags;
import net.minecraft.class_1282;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_6862;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin {
    @Shadow
    public abstract class_1799 method_6983();

    @Shadow
    public abstract void method_35190();

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"})
    public void ItemEntity(class_1937 world, double x, double y, double z, class_1799 stack, double velocityX, double velocityY, double velocityZ, CallbackInfo ci) {
        if (class_1890.method_60138((class_1799)stack, SpectrumEnchantmentTags.PREVENTS_ITEM_DAMAGE)) {
            this.method_35190();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        class_1792 class_17922;
        class_1542 thisItemEntity = (class_1542)this;
        if (!thisItemEntity.method_5740() && thisItemEntity.method_37908().method_8510() % 8L == 0L) {
            int worldMinY = thisItemEntity.method_37908().method_31607();
            if (!thisItemEntity.method_24828() && thisItemEntity.method_19538().method_10214() < (double)(worldMinY + 2) && class_1890.method_60138((class_1799)thisItemEntity.method_6983(), SpectrumEnchantmentTags.PREVENTS_ITEM_DAMAGE)) {
                if (thisItemEntity.method_19538().method_10214() < (double)(worldMinY + 1)) {
                    thisItemEntity.method_5814(thisItemEntity.method_19538().field_1352, (double)(worldMinY + 1), thisItemEntity.method_19538().field_1350);
                }
                thisItemEntity.method_18800(0.0, 0.0, 0.0);
                thisItemEntity.method_5875(true);
            }
        }
        if ((class_17922 = thisItemEntity.method_6983().method_7909()) instanceof TickAwareItem) {
            TickAwareItem tickingItem = (TickAwareItem)class_17922;
            tickingItem.onItemEntityTicked(thisItemEntity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    public void spectrumItemStackDamageActions(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        class_1792 class_17922;
        if (amount > 0.0f && (class_17922 = this.method_6983().method_7909()) instanceof DamageAwareItem) {
            DamageAwareItem damageAwareItem = (DamageAwareItem)class_17922;
            damageAwareItem.onItemEntityDamaged(source, amount, (class_1542)this);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void isDamageProof(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        class_1937 world;
        class_1542 thisItemEntity = (class_1542)this;
        if (ItemDamageImmunity.isImmuneTo(thisItemEntity.method_6983(), source)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
        if (source.method_49708(SpectrumDamageTypes.PRIMORDIAL_FIRE) && PrimordialFireBurningRecipe.processItemEntity(world = thisItemEntity.method_37908(), thisItemEntity)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void isFireProof(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (ItemDamageImmunity.isImmuneTo(((class_1542)this).method_6983(), (class_6862<class_8110>)class_8103.field_42246)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void doGravityEffects(CallbackInfo ci) {
        class_1542 itemEntity = (class_1542)this;
        if (itemEntity.method_5740()) {
            return;
        }
        class_1799 stack = itemEntity.method_6983();
        class_1792 item = stack.method_7909();
        if (item instanceof GravitableItem) {
            GravitableItem gravitableItem = (GravitableItem)item;
            gravitableItem.applyGravity(stack, itemEntity.method_37908(), itemEntity);
        }
    }
}

