/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking.s2c_payloads;

import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.blocks.pastel_network.network.ClientPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public record PastelNetworkEdgeSyncPayload(UUID networkUUID, int color, Graph<class_2338, DefaultEdge> graph) implements class_8710
{
    public static final class_9139<class_9129, Graph<class_2338, DefaultEdge>> GRAPH_PACKET_CODEC = new class_9139<class_9129, Graph<class_2338, DefaultEdge>>(){

        public void encode(class_9129 buf, Graph<class_2338, DefaultEdge> graph) {
            ArrayList vertices = new ArrayList(graph.vertexSet());
            buf.method_53002(vertices.size());
            for (class_2338 vertex : vertices) {
                buf.method_10807(vertex);
            }
            Set edges = graph.edgeSet();
            buf.method_53002(edges.size());
            for (DefaultEdge edge : edges) {
                buf.method_53002(vertices.indexOf(graph.getEdgeSource((Object)edge)));
                buf.method_53002(vertices.indexOf(graph.getEdgeTarget((Object)edge)));
            }
        }

        public Graph<class_2338, DefaultEdge> decode(class_9129 buf) {
            SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
            int vertexCount = buf.readInt();
            class_2338[] vertices = new class_2338[vertexCount];
            for (int i = 0; i < vertexCount; ++i) {
                class_2338 vertex;
                vertices[i] = vertex = buf.method_10811();
                graph.addVertex((Object)vertex);
            }
            int edgeCount = buf.readInt();
            for (int i = 0; i < edgeCount; ++i) {
                class_2338 source = vertices[buf.readInt()];
                class_2338 target = vertices[buf.readInt()];
                graph.addEdge((Object)source, (Object)target);
            }
            return graph;
        }
    };
    public static final class_8710.class_9154<PastelNetworkEdgeSyncPayload> ID = SpectrumC2SPackets.makeId("pastel_network_edge_sync");
    public static final class_9139<class_9129, PastelNetworkEdgeSyncPayload> CODEC = class_9139.method_56436((class_9139)class_4844.field_48453, PastelNetworkEdgeSyncPayload::networkUUID, (class_9139)class_9135.field_49675, PastelNetworkEdgeSyncPayload::color, GRAPH_PACKET_CODEC, PastelNetworkEdgeSyncPayload::graph, PastelNetworkEdgeSyncPayload::new);

    public static void send(ServerPastelNetwork network, class_2338 pos) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)network.getWorld()), (class_2338)pos)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PastelNetworkEdgeSyncPayload(network.getUUID(), network.getColor(), network.getGraph()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void execute(PastelNetworkEdgeSyncPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            Optional<? extends ClientPastelNetwork> network = Pastel.getClientInstance().getNetwork(payload.networkUUID);
            if (network.isPresent()) {
                network.get().setGraph(payload.graph);
            } else {
                ClientPastelNetwork newNetwork = Pastel.getClientInstance().createNetwork(client.field_1687, payload.networkUUID, payload.color);
                newNetwork.setGraph(payload.graph);
            }
        });
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

