/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkStorage;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.CodecHelper;
import de.dafuqs.spectrum.progression.advancement.InkColorPredicate;
import de.dafuqs.spectrum.progression.advancement.LongRange;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class InkContainerInteractionCriterion
extends class_4558<Conditions> {
    public static final class_2960 ID = SpectrumCommon.locate("ink_container_interaction");

    public void trigger(class_3222 player, class_1799 stack, InkStorage storage, InkColor changeColor, long changeAmount) {
        this.method_22510(player, conditions -> conditions.matches(stack, storage.getEnergy(), changeColor, changeAmount));
    }

    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public static final class Conditions
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final class_2073 itemPredicate;
        private final Map<InkColor, LongRange> colorRanges;
        private final InkColorPredicate changeInkColorPredicate;
        private final LongRange changeRange;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5258.field_47234.optionalFieldOf("player").forGetter(Conditions::comp_2029), (App)class_2073.field_45754.optionalFieldOf("item", (Object)class_2073.class_2074.method_8973().method_8976()).forGetter(Conditions::itemPredicate), (App)CodecHelper.registryMap(SpectrumRegistries.INK_COLOR, LongRange.CODEC).forGetter(Conditions::colorRanges), (App)InkColorPredicate.CODEC.optionalFieldOf("change_color", (Object)InkColorPredicate.ANY).forGetter(Conditions::changeInkColorPredicate), (App)LongRange.CODEC.optionalFieldOf("change_amount", (Object)LongRange.ANY).forGetter(Conditions::changeRange)).apply((Applicative)instance, Conditions::new));

        public Conditions(Optional<class_5258> player, class_2073 itemPredicate, Map<InkColor, LongRange> colorRanges, InkColorPredicate changeInkColorPredicate, LongRange changeRange) {
            this.player = player;
            this.itemPredicate = itemPredicate;
            this.colorRanges = colorRanges;
            this.changeInkColorPredicate = changeInkColorPredicate;
            this.changeRange = changeRange;
        }

        public boolean matches(class_1799 stack, Map<InkColor, Long> colors, InkColor changeColor, long change) {
            return this.itemPredicate.method_8970(stack) && this.changeRange.test(change) && this.changeInkColorPredicate.test(changeColor) && this.colorRanges.entrySet().stream().allMatch(entry -> this.colorRanges.get(entry.getKey()).test((Long)colors.get(entry.getKey())));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Conditions.class, "player;itemPredicate;colorRanges;changeInkColorPredicate;changeRange", "player", "itemPredicate", "colorRanges", "changeInkColorPredicate", "changeRange"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Conditions.class, "player;itemPredicate;colorRanges;changeInkColorPredicate;changeRange", "player", "itemPredicate", "colorRanges", "changeInkColorPredicate", "changeRange"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Conditions.class, "player;itemPredicate;colorRanges;changeInkColorPredicate;changeRange", "player", "itemPredicate", "colorRanges", "changeInkColorPredicate", "changeRange"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public class_2073 itemPredicate() {
            return this.itemPredicate;
        }

        public Map<InkColor, LongRange> colorRanges() {
            return this.colorRanges;
        }

        public InkColorPredicate changeInkColorPredicate() {
            return this.changeInkColorPredicate;
        }

        public LongRange changeRange() {
            return this.changeRange;
        }
    }
}

