/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_2096;

public final class LongRange
extends Record
implements class_2096<Long> {
    private final Optional<Long> min;
    private final Optional<Long> max;
    private final Optional<Long> minSquared;
    private final Optional<Long> maxSquared;
    public static final Codec<LongRange> CODEC = class_2096.method_53191((Codec)Codec.LONG, LongRange::new);
    public static final LongRange ANY = new LongRange(Optional.empty(), Optional.empty());

    private LongRange(Optional<Long> min, Optional<Long> max) {
        this(min, max, LongRange.square(min), LongRange.square(max));
    }

    public LongRange(Optional<Long> min, Optional<Long> max, Optional<Long> minSquared, Optional<Long> maxSquared) {
        this.min = min;
        this.max = max;
        this.minSquared = minSquared;
        this.maxSquared = maxSquared;
    }

    private static Optional<Long> square(Optional<Long> value) {
        return value.map(d -> d * d);
    }

    public static LongRange exactly(long value) {
        return new LongRange(Optional.of(value), Optional.of(value));
    }

    public static LongRange between(long min, long max) {
        return new LongRange(Optional.of(min), Optional.of(max));
    }

    public static LongRange atLeast(long value) {
        return new LongRange(Optional.of(value), Optional.empty());
    }

    public static LongRange atMost(long value) {
        return new LongRange(Optional.empty(), Optional.of(value));
    }

    public boolean test(long value) {
        return !(!this.min.isEmpty() && this.min.get() > value || !this.max.isEmpty() && this.max.get() < value);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LongRange.class, "min;max;minSquared;maxSquared", "min", "max", "minSquared", "maxSquared"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongRange.class, "min;max;minSquared;maxSquared", "min", "max", "minSquared", "maxSquared"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongRange.class, "min;max;minSquared;maxSquared", "min", "max", "minSquared", "maxSquared"}, this, o);
    }

    public Optional<Long> comp_1805() {
        return this.min;
    }

    public Optional<Long> comp_1806() {
        return this.max;
    }

    public Optional<Long> minSquared() {
        return this.minSquared;
    }

    public Optional<Long> maxSquared() {
        return this.maxSquared;
    }
}

