/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class TitrationBarrelTappingCriterion
extends class_4558<Conditions> {
    public static final class_2960 ID = SpectrumCommon.locate("titration_barrel_tapping");

    public void trigger(class_3222 player, class_1799 itemStack, int ingameDaysAge, int ingredientCount) {
        this.method_22510(player, conditions -> conditions.matches(itemStack, ingameDaysAge, ingredientCount));
    }

    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public static final class Conditions
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<List<class_2073>> tappedItemsPredicate;
        private final Optional<class_2096.class_2100> ingameDaysAgeRange;
        private final Optional<class_2096.class_2100> ingredientCountRange;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5258.field_47234.optionalFieldOf("player").forGetter(Conditions::comp_2029), (App)class_2073.field_45754.listOf().optionalFieldOf("items").forGetter(Conditions::tappedItemsPredicate), (App)class_2096.class_2100.field_45763.optionalFieldOf("age_ingame_days").forGetter(Conditions::ingameDaysAgeRange), (App)class_2096.class_2100.field_45763.optionalFieldOf("ingredient_count").forGetter(Conditions::ingredientCountRange)).apply((Applicative)instance, Conditions::new));

        public Conditions(Optional<class_5258> player, Optional<List<class_2073>> tappedItemsPredicate, Optional<class_2096.class_2100> ingameDaysAgeRange, Optional<class_2096.class_2100> ingredientCountRange) {
            this.player = player;
            this.tappedItemsPredicate = tappedItemsPredicate;
            this.ingameDaysAgeRange = ingameDaysAgeRange;
            this.ingredientCountRange = ingredientCountRange;
        }

        public boolean matches(class_1799 itemStack, int ingameDaysAge, int ingredientCount) {
            if (this.ingameDaysAgeRange.isEmpty()) {
                return false;
            }
            if (this.ingredientCountRange.isEmpty()) {
                return false;
            }
            if (this.ingameDaysAgeRange.get().method_9054(ingameDaysAge) && this.ingredientCountRange.get().method_9054(ingredientCount)) {
                ObjectArrayList list = new ObjectArrayList((Collection)this.tappedItemsPredicate.orElse(List.of()));
                if (list.isEmpty()) {
                    return true;
                }
                if (!itemStack.method_7960()) {
                    list.removeIf(itemPredicate -> itemPredicate.method_8970(itemStack));
                }
                return list.isEmpty();
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Conditions.class, "player;tappedItemsPredicate;ingameDaysAgeRange;ingredientCountRange", "player", "tappedItemsPredicate", "ingameDaysAgeRange", "ingredientCountRange"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Conditions.class, "player;tappedItemsPredicate;ingameDaysAgeRange;ingredientCountRange", "player", "tappedItemsPredicate", "ingameDaysAgeRange", "ingredientCountRange"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Conditions.class, "player;tappedItemsPredicate;ingameDaysAgeRange;ingredientCountRange", "player", "tappedItemsPredicate", "ingameDaysAgeRange", "ingredientCountRange"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<List<class_2073>> tappedItemsPredicate() {
            return this.tappedItemsPredicate;
        }

        public Optional<class_2096.class_2100> ingameDaysAgeRange() {
            return this.ingameDaysAgeRange;
        }

        public Optional<class_2096.class_2100> ingredientCountRange() {
            return this.ingredientCountRange;
        }
    }
}

