/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import de.dafuqs.spectrum.registries.SpectrumRegistryKeys;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class RecipeScaling {
    public static final Codec<ScalingData> CODEC = RecordCodecBuilder.create(i -> i.group((App)SpectrumRegistries.RECIPE_SCALING.method_39673().fieldOf("type").forGetter(d -> d.type), (App)Codec.INT.optionalFieldOf("start", (Object)0).forGetter(d -> d.start), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("scaling_value", (Object)0).forGetter(d -> d.scalingValue), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf("scaling_factor", (Object)1.0).forGetter(d -> d.scalingFactor), (App)Codec.INT.listOf(0, 255).optionalFieldOf("indexes", Collections.emptyList()).forGetter(d -> d.indexes)).apply((Applicative)i, ScalingData::new));
    public static final class_9139<class_9129, ScalingData> PACKET_CODEC = class_9139.method_56906((class_9139)class_9135.method_56365(SpectrumRegistryKeys.RECIPE_SCALING), d -> d.type, (class_9139)class_9135.field_48550, d -> d.start, (class_9139)class_9135.field_48550, d -> d.scalingValue, (class_9139)class_9135.field_48553, d -> d.scalingFactor, (class_9139)class_9135.field_48550.method_56433(class_9135.method_56363()), d -> d.indexes, ScalingData::new);
    public static final RecipeScaling LINEAR = new RecipeScaling(SpectrumCommon.locate("linear")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            return data.start + (int)Math.round((double)data.scalingValue * scaling * data.scalingFactor);
        }
    };
    public static final RecipeScaling DOUBLING = new RecipeScaling(SpectrumCommon.locate("doubling")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            return data.start + data.scalingValue << (int)Math.round((scaling - 1.0) * data.scalingFactor);
        }
    };
    public static final RecipeScaling EXPONENTIAL = new RecipeScaling(SpectrumCommon.locate("exponential")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            return (int)((long)data.start + Math.round(Math.pow(data.scalingValue, scaling * data.scalingFactor)));
        }
    };
    public static final RecipeScaling INDEXED = new RecipeScaling(SpectrumCommon.locate("indexed")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            int size = data.indexes.size();
            return data.indexes.get(Math.clamp((long)((int)Math.round(scaling - 1.0)), 0, size - 1));
        }
    };
    private final class_2960 id;

    public RecipeScaling(class_2960 id) {
        this.id = id;
    }

    abstract int getInputCount(double var1, ScalingData var3);

    public class_2960 getId() {
        return this.id;
    }

    public static ScalingData linear(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(LINEAR, start, scalingValue, scalingFactor, List.of(indices));
    }

    public static ScalingData doubling(int scalingValue, Integer ... indices) {
        return new ScalingData(DOUBLING, 0, scalingValue, 1.0, List.of(indices));
    }

    public static ScalingData doubling(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(DOUBLING, start, scalingValue, scalingFactor, List.of(indices));
    }

    public static ScalingData exponential(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(EXPONENTIAL, start, scalingValue, scalingFactor, List.of(indices));
    }

    public static ScalingData indices(Integer ... indices) {
        return RecipeScaling.indexed(0, 0, 1.0, indices);
    }

    public static ScalingData indexed(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(INDEXED, start, scalingValue, scalingFactor, List.of(indices));
    }

    public record ScalingData(RecipeScaling type, int start, int scalingValue, double scalingFactor, List<Integer> indexes) {
        public int apply(double scaling) {
            return this.type.getInputCount(scaling, this);
        }
    }
}

