/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.crystallarieum;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.crystallarieum.CrystallarieumCatalyst;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class CrystallarieumRecipe
extends GatedSpectrumRecipe<class_9696> {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/blocks/crystallarieum");
    public static final int GROWTH_SPEED_V = 0;
    public static final int CONSUMPTION_V = 7;
    public static final int CONSUME_CHANCE_V = 14;
    protected static final Map<class_2680, class_8786<CrystallarieumRecipe>> STATE_CACHE = new HashMap<class_2680, class_8786<CrystallarieumRecipe>>();
    protected static final FluidVariant LIQUID_CRYSTAL = FluidVariant.of((class_3611)SpectrumFluids.LIQUID_CRYSTAL);
    protected final class_1856 ingredient;
    protected final List<class_2680> growthStages;
    protected final int secondsPerGrowthStage;
    protected final InkColor inkColor;
    protected final int inkPerSecond;
    protected final boolean growsWithoutCatalyst;
    protected final List<CrystallarieumCatalyst> catalysts;
    protected final FluidVariant medium;
    protected final List<class_1799> additionalResults;

    public CrystallarieumRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, class_1856 ingredient, List<class_2680> growthStages, int secondsPerGrowthStage, InkColor inkColor, int inkPerSecond, boolean growsWithoutCatalyst, List<CrystallarieumCatalyst> catalysts, FluidVariant medium, List<class_1799> additionalResults) {
        super(group, secret, requiredAdvancementIdentifier);
        this.ingredient = ingredient;
        this.growthStages = growthStages;
        this.secondsPerGrowthStage = secondsPerGrowthStage;
        this.inkColor = inkColor;
        this.inkPerSecond = inkPerSecond;
        this.growsWithoutCatalyst = growsWithoutCatalyst;
        this.catalysts = catalysts;
        this.medium = medium;
        this.additionalResults = additionalResults;
        this.registerInToastManager(this.method_17716(), this);
    }

    @Nullable
    public static class_8786<CrystallarieumRecipe> getRecipeForState(class_1937 world, class_2680 state) {
        return STATE_CACHE.computeIfAbsent(state, s -> {
            List recipes = world.method_8433().method_30027(SpectrumRecipeTypes.CRYSTALLARIEUM);
            for (class_8786 recipe : recipes) {
                if (!((CrystallarieumRecipe)recipe.comp_1933()).growthStages.contains(s)) continue;
                return recipe;
            }
            return null;
        });
    }

    public static int growthSpeedOffsetU(CrystallarieumCatalyst catalyst) {
        int offset = 0;
        float accel = catalyst.growthAccelerationMod();
        if ((double)accel > 0.2) {
            if (accel >= 5.0f) {
                offset = 98;
            } else if (accel > 1.0f) {
                offset = 91;
            } else if (accel == 1.0f) {
                offset = 84;
            } else if (accel < 1.0f) {
                offset = 77;
            }
        }
        return offset;
    }

    public static int consumptionOffsetU(CrystallarieumCatalyst catalyst, int offsetU) {
        float drain = catalyst.inkConsumptionMod();
        if (drain >= 5.0f) {
            offsetU = 0;
        } else if (drain > 1.0f) {
            offsetU = 7;
        } else if (drain == 1.0f) {
            offsetU = 14;
        } else if ((double)drain < 0.2) {
            offsetU = 28;
        } else if (drain < 1.0f) {
            offsetU = 21;
        }
        return 70 + offsetU;
    }

    public static int consumeChanceOffsetU(CrystallarieumCatalyst catalyst, int offsetU) {
        float chance = catalyst.consumeChancePerSecond();
        if ((double)chance >= 0.25) {
            offsetU = 0;
        } else if ((double)chance < 1.0E-4) {
            offsetU = 28;
        } else if ((double)chance <= 0.02) {
            offsetU = 21;
        } else if ((double)chance < 0.05) {
            offsetU = 14;
        } else if ((double)chance < 0.25) {
            offsetU = 7;
        }
        return 70 + offsetU;
    }

    public boolean matches(class_9696 input, class_1937 world) {
        return this.ingredient.method_8093(input.method_59984(0));
    }

    @Deprecated
    public class_1799 assemble(class_9696 inv, class_7225.class_7874 registryLookup) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_7225.class_7874 registryLookup) {
        List<class_2680> states = this.getGrowthStages();
        return states.getLast().method_26204().method_8389().method_7854();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.CRYSTALLARIEUM);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.CRYSTALLARIEUM_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.CRYSTALLARIEUM;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "crystallarieum_growing";
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.ingredient);
        return defaultedList;
    }

    public FluidVariant getFluidMedium() {
        return this.medium;
    }

    public class_1856 getIngredientStack() {
        return this.ingredient;
    }

    public CrystallarieumCatalyst getCatalyst(class_1799 itemStack) {
        for (CrystallarieumCatalyst catalyst : this.catalysts) {
            if (!catalyst.ingredient().method_8093(itemStack)) continue;
            return catalyst;
        }
        return CrystallarieumCatalyst.EMPTY;
    }

    public List<class_2680> getGrowthStages() {
        return this.growthStages;
    }

    public int getSecondsPerGrowthStage() {
        return this.secondsPerGrowthStage;
    }

    public InkColor getInkColor() {
        return this.inkColor;
    }

    public int getInkPerSecond() {
        return this.inkPerSecond;
    }

    public boolean growsWithoutCatalyst() {
        return this.growsWithoutCatalyst;
    }

    public List<CrystallarieumCatalyst> getCatalysts() {
        return this.catalysts;
    }

    public List<class_1799> getAdditionalResults() {
        return this.additionalResults;
    }

    public Optional<class_2680> getNextState(class_8786<CrystallarieumRecipe> recipe, class_2680 currentState) {
        Iterator<class_2680> it = ((CrystallarieumRecipe)recipe.comp_1933()).getGrowthStages().iterator();
        while (it.hasNext()) {
            class_2680 state = it.next();
            if (!state.equals(currentState) || !it.hasNext()) continue;
            return Optional.of(it.next());
        }
        return Optional.empty();
    }

    public static class Serializer
    implements class_1865<CrystallarieumRecipe> {
        private static final MapCodec<CrystallarieumRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)class_1856.field_46096.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)class_2680.field_24734.listOf().fieldOf("growth_stage_states").forGetter(recipe -> recipe.growthStages), (App)Codec.INT.fieldOf("seconds_per_growth_stage").forGetter(recipe -> recipe.secondsPerGrowthStage), (App)InkColor.CODEC.fieldOf("ink_color").forGetter(recipe -> recipe.inkColor), (App)Codec.INT.xmap(d -> d == 0 ? 0 : 1 << d - 1, e -> e == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(e) + 1).fieldOf("ink_cost_tier").forGetter(recipe -> recipe.inkPerSecond), (App)Codec.BOOL.optionalFieldOf("grows_without_catalyst", (Object)false).forGetter(recipe -> recipe.growsWithoutCatalyst), (App)CrystallarieumCatalyst.CODEC.listOf().fieldOf("catalysts").forGetter(recipe -> recipe.catalysts), (App)FluidVariant.CODEC.optionalFieldOf("fluid_medium", (Object)LIQUID_CRYSTAL).forGetter(recipe -> recipe.medium), (App)class_1799.field_24671.listOf().optionalFieldOf("additional_recipe_manager_results", (Object)ImmutableList.of()).forGetter(recipe -> recipe.additionalResults)).apply((Applicative)i, CrystallarieumRecipe::new));
        private static final class_9139<class_9129, CrystallarieumRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, recipe -> recipe.group, class_9135.field_48547, recipe -> recipe.secret, class_9135.method_56382((class_9139)class_2960.field_48267), recipe -> recipe.requiredAdvancementIdentifier, class_1856.field_48355, recipe -> recipe.ingredient, PacketCodecHelper.BLOCK_STATE.method_56433(class_9135.method_56363()), recipe -> recipe.growthStages, class_9135.field_48550, recipe -> recipe.secondsPerGrowthStage, InkColor.PACKET_CODEC, recipe -> recipe.inkColor, class_9135.field_48550, recipe -> recipe.inkPerSecond, class_9135.field_48547, recipe -> recipe.growsWithoutCatalyst, CrystallarieumCatalyst.PACKET_CODEC.method_56433(class_9135.method_56363()), recipe -> recipe.catalysts, FluidVariant.PACKET_CODEC, recipe -> recipe.medium, class_1799.field_48349.method_56433(class_9135.method_56363()), recipe -> recipe.additionalResults, CrystallarieumRecipe::new);

        public MapCodec<CrystallarieumRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CrystallarieumRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

