/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class RawShapedPedestalRecipe {
    public static final MapCodec<RawShapedPedestalRecipe> CODEC = Data.CODEC.flatXmap(RawShapedPedestalRecipe::fromData, recipe -> recipe.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final class_9139<class_9129, RawShapedPedestalRecipe> PACKET_CODEC = class_9139.method_56438(RawShapedPedestalRecipe::writeToBuf, RawShapedPedestalRecipe::readFromBuf);
    private final int width;
    private final int height;
    private final class_2371<IngredientStack> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public RawShapedPedestalRecipe(int width, int height, class_2371<IngredientStack> ingredients, Optional<Data> data) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.data = data;
        int i = 0;
        for (IngredientStack ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            ++i;
        }
        this.ingredientCount = i;
        this.symmetrical = class_156.method_59901((int)width, (int)height, ingredients);
    }

    public static RawShapedPedestalRecipe create(Map<Character, IngredientStack> key, String ... pattern) {
        return RawShapedPedestalRecipe.create(key, List.of(pattern));
    }

    public static RawShapedPedestalRecipe create(Map<Character, IngredientStack> key, List<String> pattern) {
        Data data = new Data(key, pattern);
        return (RawShapedPedestalRecipe)RawShapedPedestalRecipe.fromData(data).getOrThrow();
    }

    private static DataResult<RawShapedPedestalRecipe> fromData(Data data) {
        String[] strings = RawShapedPedestalRecipe.removePadding(data.pattern);
        int i = strings[0].length();
        int j = strings.length;
        class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)IngredientStack.EMPTY);
        CharArraySet charSet = new CharArraySet(data.key.keySet());
        for (int k = 0; k < strings.length; ++k) {
            String string = strings[k];
            for (int l = 0; l < string.length(); ++l) {
                IngredientStack ingredient;
                char c = string.charAt(l);
                IngredientStack ingredientStack = ingredient = c == ' ' ? IngredientStack.EMPTY : data.key.get(Character.valueOf(c));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                }
                charSet.remove(c);
                defaultedList.set(l + i * k, (Object)ingredient);
            }
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> RawShapedPedestalRecipe.lambda$fromData$4((CharSet)charSet));
        }
        return DataResult.success((Object)new RawShapedPedestalRecipe(i, j, (class_2371<IngredientStack>)defaultedList, Optional.of(data)));
    }

    static String[] removePadding(List<String> pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.size(); ++m) {
            String string = pattern.get(m);
            i = Math.min(i, RawShapedPedestalRecipe.findFirstSymbol(string));
            int n = RawShapedPedestalRecipe.findLastSymbol(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.size() == l) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = pattern.get(o + k).substring(i, j + 1);
        }
        return strings;
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String line) {
        int i;
        for (i = line.length() - 1; i >= 0 && line.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public boolean matches(class_9694 input) {
        if (input.method_59990() != this.ingredientCount) {
            return false;
        }
        if (input.method_59991() == this.width && input.method_59992() == this.height) {
            if (!this.symmetrical && this.matches(input, true)) {
                return true;
            }
            return this.matches(input, false);
        }
        return false;
    }

    public boolean matches(class_9694 input, boolean mirrored) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                class_1799 itemStack;
                IngredientStack ingredient = mirrored ? (IngredientStack)this.ingredients.get(this.width - j - 1 + i * this.width) : (IngredientStack)this.ingredients.get(j + i * this.width);
                if (ingredient.test(itemStack = input.method_59985(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeToBuf(class_9129 buf) {
        buf.method_10804(this.width);
        buf.method_10804(this.height);
        for (IngredientStack ingredient : this.ingredients) {
            IngredientStack.Serializer.PACKET_CODEC.encode((Object)buf, (Object)ingredient);
        }
    }

    private static RawShapedPedestalRecipe readFromBuf(class_9129 buf) {
        int i = buf.method_10816();
        int j = buf.method_10816();
        class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)IngredientStack.EMPTY);
        defaultedList.replaceAll(ingredient -> (IngredientStack)IngredientStack.Serializer.PACKET_CODEC.decode((Object)buf));
        return new RawShapedPedestalRecipe(i, j, (class_2371<IngredientStack>)defaultedList, Optional.empty());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_2371<IngredientStack> getIngredients() {
        return this.ingredients;
    }

    private static /* synthetic */ String lambda$fromData$4(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
    }

    public record Data(Map<Character, IngredientStack> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
            if (pattern.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)pattern.getFirst()).length();
            for (String string : pattern) {
                if (i == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)pattern);
        }, Function.identity());
        private static final Codec<Character> KEY_ENTRY_CODEC = Codec.STRING.comapFlatMap(keyEntry -> {
            if (keyEntry.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(keyEntry) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_5699.method_53703(KEY_ENTRY_CODEC, IngredientStack.Serializer.CODEC).fieldOf("key").forGetter(data -> data.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)).apply((Applicative)i, Data::new));
    }
}

