/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.spirit_instiller;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.PacketCodecHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.recipe.InstanceRecipeInput;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SpiritInstillerRecipe
extends GatedStackSpectrumRecipe<InstanceRecipeInput<SpiritInstillerBlockEntity>> {
    public static final int CENTER_INGREDIENT = 0;
    public static final int FIRST_INGREDIENT = 1;
    public static final int SECOND_INGREDIENT = 2;
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("midgame/build_spirit_instiller_structure");
    protected final IngredientStack centerIngredient;
    protected final IngredientStack bowlIngredient1;
    protected final IngredientStack bowlIngredient2;
    protected final class_1799 output;
    protected final int craftingTime;
    protected final float experience;
    protected final boolean noBenefitsFromYieldAndEfficiencyUpgrades;

    public SpiritInstillerRecipe(String group, boolean secret, Optional<class_2960> requiredAdvancementIdentifier, IngredientStack centerIngredient, IngredientStack bowlIngredient1, IngredientStack bowlIngredient2, class_1799 output, int craftingTime, float experience, boolean noBenefitsFromYieldAndEfficiencyUpgrades) {
        super(group, secret, requiredAdvancementIdentifier);
        this.centerIngredient = centerIngredient;
        this.bowlIngredient1 = bowlIngredient1;
        this.bowlIngredient2 = bowlIngredient2;
        this.output = output;
        this.craftingTime = craftingTime;
        this.experience = experience;
        this.noBenefitsFromYieldAndEfficiencyUpgrades = noBenefitsFromYieldAndEfficiencyUpgrades;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean matches(InstanceRecipeInput recipeInput, class_1937 world) {
        List<IngredientStack> ingredientStacks = this.getIngredientStacks();
        if (recipeInput.method_59983() > 2 && ingredientStacks.get(0).test(recipeInput.method_59984(0))) {
            if (ingredientStacks.get(1).test(recipeInput.method_59984(1))) {
                return ingredientStacks.get(2).test(recipeInput.method_59984(2));
            }
            if (ingredientStacks.get(1).test(recipeInput.method_59984(2))) {
                return ingredientStacks.get(2).test(recipeInput.method_59984(1));
            }
        }
        return false;
    }

    public class_1799 method_8110(class_7225.class_7874 registryManager) {
        return this.output;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.SPIRIT_INSTILLING_SERIALIZER;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.centerIngredient);
        defaultedList.add((Object)this.bowlIngredient1);
        defaultedList.add((Object)this.bowlIngredient2);
        return defaultedList;
    }

    public class_1799 assemble(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, class_7225.class_7874 drm) {
        boolean makeUnrecognizable;
        class_1799 resultStack = class_1799.field_8037;
        SpiritInstillerBlockEntity spiritInstillerBlockEntity = recipeInput.getInstance();
        Upgradeable.UpgradeHolder upgradeHolder = spiritInstillerBlockEntity.getUpgradeHolder();
        class_1937 world = spiritInstillerBlockEntity.method_10997();
        if (world == null) {
            return class_1799.field_8037;
        }
        class_2338 pos = spiritInstillerBlockEntity.method_11016();
        resultStack = this.method_8110(drm).method_7972();
        if (!this.areYieldAndEfficiencyUpgradesDisabled() && (double)upgradeHolder.getEffectiveValue(Upgradeable.UpgradeType.YIELD) != 1.0) {
            int resultCountMod = Support.getIntFromDecimalWithChance((float)resultStack.method_7947() * upgradeHolder.getEffectiveValue(Upgradeable.UpgradeType.YIELD), world.field_9229);
            resultStack.method_7939(resultCountMod);
        }
        if (resultStack.method_31574(SpectrumBlocks.MEMORY.method_8389()) && (makeUnrecognizable = spiritInstillerBlockEntity.method_5438(0).method_31573(SpectrumItemTags.MEMORY_BONDING_AGENTS_CONCEALABLE))) {
            MemoryItem.makeUnrecognizable(resultStack);
        }
        this.spawnXPAndGrantAdvancements(resultStack, spiritInstillerBlockEntity, upgradeHolder, world, pos);
        return resultStack;
    }

    protected void spawnXPAndGrantAdvancements(class_1799 resultStack, SpiritInstillerBlockEntity spiritInstillerBlockEntity, Upgradeable.UpgradeHolder upgradeHolder, class_1937 world, class_2338 pos) {
        int awardedExperience = 0;
        if (this.getExperience() > 0.0f) {
            double experienceModifier = upgradeHolder.getEffectiveValue(Upgradeable.UpgradeType.EXPERIENCE);
            float recipeExperienceBeforeMod = this.getExperience();
            awardedExperience = Support.getIntFromDecimalWithChance((double)recipeExperienceBeforeMod * experienceModifier, world.field_9229);
            MultiblockCrafter.spawnExperience(world, pos.method_10084(), awardedExperience);
        }
        SpiritInstillerRecipe.grantPlayerSpiritInstillingAdvancementCriterion(spiritInstillerBlockEntity.getOwnerUUID(), resultStack, awardedExperience);
    }

    protected static void grantPlayerSpiritInstillingAdvancementCriterion(UUID playerUUID, class_1799 resultStack, int experience) {
        class_3222 serverPlayerEntity = (class_3222)PlayerOwned.getPlayerEntityIfOnline(playerUUID);
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.SPIRIT_INSTILLER_CRAFTING.trigger(serverPlayerEntity, resultStack, experience);
        }
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public boolean areYieldAndEfficiencyUpgradesDisabled() {
        return this.noBenefitsFromYieldAndEfficiencyUpgrades;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "spirit_instiller";
    }

    public boolean canCraftWithStacks(InstanceRecipeInput<SpiritInstillerBlockEntity> inventory) {
        return true;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.SPIRIT_INSTILLER);
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.SPIRIT_INSTILLING;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 3;
    }

    public static class Serializer
    implements class_1865<SpiritInstillerRecipe> {
        public static final MapCodec<SpiritInstillerRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)class_2960.field_25139.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.Serializer.CODEC.fieldOf("center_ingredient").forGetter(recipe -> recipe.centerIngredient), (App)IngredientStack.Serializer.CODEC.fieldOf("ingredient1").forGetter(recipe -> recipe.bowlIngredient1), (App)IngredientStack.Serializer.CODEC.fieldOf("ingredient2").forGetter(recipe -> recipe.bowlIngredient2), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.BOOL.optionalFieldOf("disable_yield_and_efficiency_upgrades", (Object)false).forGetter(recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades)).apply((Applicative)i, SpiritInstillerRecipe::new));
        private static final class_9139<class_9129, SpiritInstillerRecipe> PACKET_CODEC = PacketCodecHelper.tuple(class_9135.field_48554, c -> c.group, class_9135.field_48547, c -> c.secret, class_9135.method_56382((class_9139)class_2960.field_48267), c -> c.requiredAdvancementIdentifier, IngredientStack.Serializer.PACKET_CODEC, c -> c.centerIngredient, IngredientStack.Serializer.PACKET_CODEC, c -> c.bowlIngredient1, IngredientStack.Serializer.PACKET_CODEC, c -> c.bowlIngredient2, class_1799.field_48349, c -> c.output, class_9135.field_48550, recipe -> recipe.craftingTime, class_9135.field_48552, recipe -> Float.valueOf(recipe.experience), class_9135.field_48547, recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades, SpiritInstillerRecipe::new);

        public MapCodec<SpiritInstillerRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, SpiritInstillerRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

