/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.spirit_instiller.dynamic;

import com.mojang.authlib.GameProfile;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import de.dafuqs.spectrum.cca.HardcoreDeathComponent;
import de.dafuqs.spectrum.recipe.InstanceRecipeInput;
import de.dafuqs.spectrum.recipe.spirit_instiller.SpiritInstillerRecipe;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7225;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class HardcorePlayerRevivalRecipe
extends SpiritInstillerRecipe {
    public HardcorePlayerRevivalRecipe() {
        super("", false, Optional.empty(), IngredientStack.ofItems(class_2246.field_10432.method_8389()), IngredientStack.ofItems(class_1802.field_8288), IngredientStack.ofItems(class_1802.field_8367), class_1799.field_8037, 1200, 100.0f, true);
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.SPIRIT_INSTILLER_HARDCORE_PLAYER_REVIVAL;
    }

    @Override
    public class_1799 assemble(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, class_7225.class_7874 drm) {
        class_3222 revivedPlayer;
        SpiritInstillerBlockEntity spiritInstillerBlockEntity = recipeInput.getInstance();
        GameProfile gameProfile = this.getSkullOwner(recipeInput.method_59984(0));
        if (gameProfile != null && SpectrumCommon.minecraftServer != null && (revivedPlayer = SpectrumCommon.minecraftServer.method_3760().method_14566(gameProfile.getName())) != null) {
            HardcoreDeathComponent.removeHardcoreDeath(gameProfile);
            revivedPlayer.method_7336(SpectrumCommon.minecraftServer.method_3790());
            class_2470 blockRotation = spiritInstillerBlockEntity.getMultiblockRotation();
            float yaw = 0.0f;
            switch (blockRotation) {
                case field_11467: {
                    yaw = -90.0f;
                    break;
                }
                case field_11463: {
                    yaw = 0.0f;
                    break;
                }
                case field_11464: {
                    yaw = 900.0f;
                    break;
                }
                case field_11465: {
                    yaw = 180.0f;
                }
            }
            class_2338 pos = spiritInstillerBlockEntity.method_11016();
            revivedPlayer.method_14251((class_3218)spiritInstillerBlockEntity.method_10997(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), revivedPlayer.method_36454(), revivedPlayer.method_36455());
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean canCraftWithStacks(InstanceRecipeInput<SpiritInstillerBlockEntity> inventory) {
        class_1799 instillerStack = inventory.method_59984(0);
        if (instillerStack.method_31574(class_2246.field_10432.method_8389())) {
            GameProfile gameProfile = this.getSkullOwner(instillerStack);
            if (gameProfile == null || SpectrumCommon.minecraftServer == null) {
                return false;
            }
            class_3324 playerManager = SpectrumCommon.minecraftServer.method_3760();
            class_3222 playerToRevive = gameProfile.getId() == null ? playerManager.method_14566(gameProfile.getName()) : playerManager.method_14602(gameProfile.getId());
            return playerToRevive != null && HardcoreDeathComponent.hasHardcoreDeath(gameProfile);
        }
        return false;
    }

    @Override
    public boolean canPlayerCraft(class_1657 playerEntity) {
        return true;
    }

    @Nullable
    private GameProfile getSkullOwner(class_1799 instillerStack) {
        class_9296 profile = (class_9296)instillerStack.method_57824(class_9334.field_49617);
        return profile == null ? null : profile.comp_2413();
    }
}

