/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel.dynamic;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.recipe.StorageRecipeInput;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.dynamic.SweetenableTitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;

public class NecteredViognierRecipe
extends SweetenableTitrationBarrelRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("hidden/collect_cookbooks/imperial_cookbook");
    public static final int MIN_FERMENTATION_TIME_HOURS = 24;
    public static final class_1799 OUTPUT_STACK = NecteredViognierRecipe.getDefaultStackWithCount(SpectrumItems.NECTERED_VIOGNIER, 4);
    public static final class_1792 TAPPING_ITEM = class_1802.field_8469;
    public static final List<IngredientStack> INGREDIENT_STACKS = new ArrayList<IngredientStack>(){
        {
            this.add(IngredientStack.ofItems(SpectrumBlocks.NEPHRITE_BLOSSOM_BULB.method_8389()));
            this.add(IngredientStack.ofItems(SpectrumItems.GLASS_PEACH, 4));
        }
    };

    public NecteredViognierRecipe() {
        super("", false, Optional.of(UNLOCK_IDENTIFIER), INGREDIENT_STACKS, FluidIngredient.of((class_3611)class_3612.field_15910), OUTPUT_STACK, TAPPING_ITEM, 24, new FermentationData(0.15f, 0.01f, List.of()));
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall) {
        int bulbCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumBlocks.NEPHRITE_BLOSSOM_BULB.method_8389());
        int petalCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.GLASS_PEACH);
        boolean nectar = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.MOONSTRUCK_NECTAR) > 0;
        float thickness = this.getThickness(bulbCount, petalCount);
        return this.tapWith(bulbCount, petalCount, nectar, thickness, secondsFermented, downfall);
    }

    @Override
    @NotNull
    protected List<class_1293> getEffects(boolean nectar, double bloominess, double alcPercent) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        int effectDuration = (int)(150L * Math.round(alcPercent / 10.0));
        if (alcPercent >= 35.0) {
            effects.add(new class_1293(SpectrumStatusEffects.MAGIC_ANNULATION, effectDuration, (int)(alcPercent / 10.0)));
        }
        if (alcPercent >= 35.0) {
            effects.add(new class_1293(SpectrumStatusEffects.TOUGHNESS, effectDuration, (int)(alcPercent / 10.0)));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (alcPercent >= 30.0) {
            effects.add(new class_1293(class_1294.field_5910, effectDuration, (int)(alcPercent / 10.0)));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (alcPercent >= 20.0) {
            effects.add(new class_1293(class_1294.field_5907, effectDuration, (int)(alcPercent / 45.0)));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (alcPercent >= 10.0) {
            effects.add(new class_1293(SpectrumStatusEffects.NOURISHING, effectDuration));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (nectar) {
            effects.add(new class_1293(SpectrumStatusEffects.IMMUNITY, effectDuration / 2));
        }
        int nectarMod = nectar ? 3 : 1;
        effectDuration = 1200;
        int alcAfterBloominess = (int)(alcPercent / ((double)nectarMod + bloominess));
        if (alcAfterBloominess >= 40) {
            effects.add(new class_1293(class_1294.field_5919, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 30) {
            effects.add(new class_1293(class_1294.field_5899, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 20) {
            effects.add(new class_1293(class_1294.field_5916, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 10) {
            effects.add(new class_1293(class_1294.field_5911, effectDuration));
        }
        return effects;
    }

    @Override
    public boolean matches(StorageRecipeInput<SingleVariantStorage<FluidVariant>> recipeInput, class_1937 world) {
        boolean bulbsFound = false;
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            class_1799 stack = recipeInput.method_59984(i);
            if (stack.method_7960()) continue;
            if (stack.method_31574(SpectrumBlocks.NEPHRITE_BLOSSOM_BULB.method_8389())) {
                bulbsFound = true;
                continue;
            }
            if (stack.method_31574(SpectrumItems.GLASS_PEACH) || stack.method_31574(SpectrumItems.MOONSTRUCK_NECTAR)) continue;
            return false;
        }
        return bulbsFound;
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.TITRATION_BARREL_NECTERED_VIOGNIER;
    }
}

