/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel.dynamic;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.recipe.FluidIngredient;
import de.dafuqs.spectrum.api.recipe.IngredientStack;
import de.dafuqs.spectrum.components.BeverageComponent;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.recipe.StorageRecipeInput;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumRecipeSerializers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2356;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7917;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SuspiciousBrewRecipe
extends TitrationBarrelRecipe {
    public static final class_1792 TAPPING_ITEM = class_1802.field_8469;
    public static final int MIN_FERMENTATION_TIME_HOURS = 4;
    public static final class_1799 OUTPUT_STACK = SuspiciousBrewRecipe.getDefaultStackWithCount(SpectrumItems.SUSPICIOUS_BREW, 4);
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/food/suspicious_brew");
    public static final List<IngredientStack> INGREDIENT_STACKS = new ArrayList<IngredientStack>(){
        {
            this.add(IngredientStack.ofTag((class_6862<class_1792>)class_3489.field_15543, 1));
            this.add(IngredientStack.ofTag((class_6862<class_1792>)class_3489.field_15543, 1));
            this.add(IngredientStack.ofTag((class_6862<class_1792>)class_3489.field_15543, 1));
            this.add(IngredientStack.ofTag((class_6862<class_1792>)class_3489.field_15543, 1));
        }
    };

    public SuspiciousBrewRecipe() {
        super("", false, Optional.of(UNLOCK_IDENTIFIER), INGREDIENT_STACKS, FluidIngredient.of((class_3611)class_3612.field_15910), OUTPUT_STACK, TAPPING_ITEM, 4, new FermentationData(1.25f, 0.01f, List.of()));
    }

    @Override
    public class_1799 getPreviewTap(int timeMultiplier) {
        class_1799 flowerStack = class_1802.field_8880.method_7854();
        flowerStack.method_7939(4);
        return this.tapWith(List.of(flowerStack), 1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int itemCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            stacks.add(stack);
            itemCount += stack.method_7947();
        }
        float thickness = this.getThickness(itemCount);
        return this.tapWith(stacks, thickness, secondsFermented, downfall);
    }

    public class_1799 tapWith(List<class_1799> stacks, float thickness, long secondsFermented, float downfall) {
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        double alcPercent = SuspiciousBrewRecipe.getAlcPercent(this.fermentationData.fermentationSpeedMod(), thickness, downfall, ageIngameDays);
        if (alcPercent >= 100.0) {
            return SpectrumItems.PURE_ALCOHOL.method_7854();
        }
        HashMap<class_6880, Double> stewEffects = new HashMap<class_6880, Double>();
        for (class_1799 stack : stacks) {
            @Nullable class_7917 suspiciousEffectHolder = class_7917.method_47380((class_1935)stack.method_7909());
            if (suspiciousEffectHolder == null) continue;
            for (class_9298.class_8751 effect : suspiciousEffectHolder.method_53233().comp_2416()) {
                class_6880 key = effect.comp_1838();
                double duration = (double)effect.comp_1839() * Support.logBase(2.0, 1 + stack.method_7947());
                stewEffects.put(key, stewEffects.getOrDefault(key, 0.0) + duration);
            }
        }
        ArrayList<class_1293> finalStatusEffects = new ArrayList<class_1293>();
        double clampedAlcPercent = class_3532.method_15350((double)alcPercent, (double)1.0, (double)20.0);
        for (Map.Entry entry : stewEffects.entrySet()) {
            double finalDurationTicks = (Double)entry.getValue() * Math.pow(2.0, clampedAlcPercent);
            finalStatusEffects.add(new class_1293((class_6880)entry.getKey(), (int)finalDurationTicks, 0));
        }
        class_1799 outputStack = OUTPUT_STACK.method_7972();
        outputStack.method_7939(1);
        outputStack.method_57379(SpectrumDataComponentTypes.BEVERAGE, (Object)new BeverageComponent((long)ageIngameDays, (int)alcPercent, thickness));
        outputStack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), finalStatusEffects));
        return outputStack;
    }

    @Override
    public boolean matches(StorageRecipeInput<SingleVariantStorage<FluidVariant>> recipeInput, class_1937 world) {
        boolean flowerFound = false;
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            class_1747 blockItem;
            class_1799 stack = recipeInput.method_59984(i);
            if (stack.method_7960()) continue;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2356) {
                flowerFound = true;
                continue;
            }
            return false;
        }
        return flowerFound;
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeSerializers.TITRATION_BARREL_SUSPICIOUS_BREW;
    }
}

