/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class DeferredRegistrar {
    private final ArrayList<Runnable> deferred = new ArrayList();

    public void flush() {
        this.deferred.forEach(Runnable::run);
        this.deferred.clear();
        this.deferred.trimToSize();
    }

    public <T> T defer(T value, Consumer<T> callback) {
        this.deferred.add(() -> callback.accept(value));
        return value;
    }

    public void defer(Runnable callback) {
        this.deferred.add(callback);
    }

    public static <T> Chain<T> chain(T value) {
        return new Chain<T>(value);
    }

    public record Chain<T>(T value) {
        public void defer(DeferredRegistrar registrar, Consumer<T> callback) {
            registrar.defer(() -> callback.accept(this.value));
        }

        public <D> void defer(Contextual<D> registrar, BiConsumer<D, T> callback) {
            registrar.defer(ctx -> callback.accept(ctx, this.value));
        }

        public <D> void defer(KeyedContextual<T, D> registrar, BiConsumer<T, D> callback) {
            registrar.defer(this.value, callback);
        }
    }

    public static class KeyedContextual<T, D> {
        private HashMap<T, BiConsumer<T, D>> deferred;

        public KeyedContextual() {
            this(true);
        }

        public KeyedContextual(boolean active) {
            this.deferred = active ? new HashMap() : null;
        }

        public void flush(D data) {
            if (this.deferred != null) {
                this.deferred.forEach((value, consumer) -> consumer.accept(value, data));
                this.deferred = new HashMap();
            }
        }

        public Stream<T> streamKeys() {
            return this.deferred == null ? Stream.empty() : this.deferred.keySet().stream();
        }

        public T defer(T value, BiConsumer<T, D> callback) {
            if (this.deferred != null) {
                this.deferred.put(value, callback);
            }
            return value;
        }
    }

    public static class Contextual<D> {
        private ArrayList<Consumer<D>> deferred;

        public Contextual() {
            this(true);
        }

        public Contextual(boolean active) {
            this.deferred = active ? new ArrayList() : null;
        }

        public void flush(D data) {
            if (this.deferred != null) {
                this.deferred.forEach((Consumer<Consumer<D>>)((Consumer<Consumer>)c -> c.accept(data)));
                this.deferred = new ArrayList();
            }
        }

        public void defer(Consumer<D> callback) {
            if (this.deferred != null) {
                this.deferred.add(callback);
            }
        }
    }
}

