/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.color.ItemColors;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.blocks.fluid.DragonrotFluid;
import de.dafuqs.spectrum.blocks.fluid.LiquidCrystalFluid;
import de.dafuqs.spectrum.blocks.fluid.MidnightSolutionFluid;
import de.dafuqs.spectrum.blocks.fluid.SludgeFluid;
import de.dafuqs.spectrum.blocks.fluid.SpectrumFluid;
import de.dafuqs.spectrum.helpers.SpectrumColorHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.joml.Vector3f;

public class SpectrumFluids {
    public static final Object2ObjectArrayMap<FluidRenderHandler, class_3611[]> HANDLER_MAP = new Object2ObjectArrayMap(4);
    public static final SpectrumFluid LIQUID_CRYSTAL = new LiquidCrystalFluid.Still();
    public static final SpectrumFluid FLOWING_LIQUID_CRYSTAL = new LiquidCrystalFluid.Flowing();
    public static final int LIQUID_CRYSTAL_TINT = 0xCBBBCB;
    public static final Vector3f LIQUID_CRYSTAL_COLOR_VEC = SpectrumColorHelper.colorIntToVec(0xCBBBCB);
    public static final class_2960 LIQUID_CRYSTAL_OVERLAY_TEXTURE = SpectrumCommon.locate("textures/misc/liquid_crystal_overlay.png");
    public static final float LIQUID_CRYSTAL_OVERLAY_ALPHA = 0.6f;
    public static final SpectrumFluid SLUDGE = new SludgeFluid.StillSludge();
    public static final SpectrumFluid FLOWING_SLUDGE = new SludgeFluid.FlowingSludge();
    public static final int SLUDGE_TINT = 5123594;
    public static final Vector3f SLUDGE_COLOR_VEC = SpectrumColorHelper.colorIntToVec(5123594);
    public static final class_2960 SLUDGE_OVERLAY_TEXTURE = SpectrumCommon.locate("textures/misc/sludge_overlay.png");
    public static final float SLUDGE_OVERLAY_ALPHA = 0.995f;
    public static final SpectrumFluid MIDNIGHT_SOLUTION = new MidnightSolutionFluid.Still();
    public static final SpectrumFluid FLOWING_MIDNIGHT_SOLUTION = new MidnightSolutionFluid.Flowing();
    public static final int MIDNIGHT_SOLUTION_TINT = 1120315;
    public static final Vector3f MIDNIGHT_SOLUTION_COLOR_VEC = SpectrumColorHelper.colorIntToVec(1120315);
    public static final class_2960 MIDNIGHT_SOLUTION_OVERLAY_TEXTURE = SpectrumCommon.locate("textures/misc/midnight_solution_overlay.png");
    public static final float MIDNIGHT_SOLUTION_OVERLAY_ALPHA = 0.995f;
    public static final SpectrumFluid DRAGONROT = new DragonrotFluid.Still();
    public static final SpectrumFluid FLOWING_DRAGONROT = new DragonrotFluid.Flowing();
    public static final int DRAGONROT_TINT = 14907183;
    public static final Vector3f DRAGONROT_COLOR_VEC = SpectrumColorHelper.colorIntToVec(14907183);
    public static final class_2960 DRAGONROT_OVERLAY_TEXTURE = SpectrumCommon.locate("textures/misc/dragonrot_overlay.png");
    public static final float DRAGONROT_OVERLAY_ALPHA = 0.98f;

    public static void register() {
        SpectrumFluids.registerFluid("liquid_crystal", (class_3611)LIQUID_CRYSTAL, (class_3611)FLOWING_LIQUID_CRYSTAL, InkColors.LIGHT_GRAY);
        SpectrumFluids.registerFluid("sludge", (class_3611)SLUDGE, (class_3611)FLOWING_SLUDGE, InkColors.BROWN);
        SpectrumFluids.registerFluid("midnight_solution", (class_3611)MIDNIGHT_SOLUTION, (class_3611)FLOWING_MIDNIGHT_SOLUTION, InkColors.GRAY);
        SpectrumFluids.registerFluid("dragonrot", (class_3611)DRAGONROT, (class_3611)FLOWING_DRAGONROT, InkColors.GRAY);
    }

    private static void registerFluid(String name, class_3611 stillFluid, class_3611 flowingFluid, InkColor color) {
        class_2378.method_10230((class_2378)class_7923.field_41173, (class_2960)SpectrumCommon.locate(name), (Object)stillFluid);
        class_2378.method_10230((class_2378)class_7923.field_41173, (class_2960)SpectrumCommon.locate("flowing_" + name), (Object)flowingFluid);
        ItemColors.FLUID_COLORS.registerColorMapping(stillFluid, color);
        ItemColors.FLUID_COLORS.registerColorMapping(flowingFluid, color);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        SpectrumFluids.setupFluidRendering((class_3611)LIQUID_CRYSTAL, (class_3611)FLOWING_LIQUID_CRYSTAL, "liquid_crystal", 0xCBBBCB);
        SpectrumFluids.setupFluidRendering((class_3611)SLUDGE, (class_3611)FLOWING_SLUDGE, "sludge", 5123594);
        SpectrumFluids.setupFluidRendering((class_3611)MIDNIGHT_SOLUTION, (class_3611)FLOWING_MIDNIGHT_SOLUTION, "midnight_solution", 1120315);
        SpectrumFluids.setupFluidRendering((class_3611)DRAGONROT, (class_3611)FLOWING_DRAGONROT, "dragonrot", 14907183);
    }

    @Environment(value=EnvType.CLIENT)
    private static void setupFluidRendering(class_3611 stillFluid, class_3611 flowingFluid, String name, int tint) {
        SimpleFluidRenderHandler handler = new SimpleFluidRenderHandler(SpectrumCommon.locate("block/" + name + "_still"), SpectrumCommon.locate("block/" + name + "_flow"), tint);
        HANDLER_MAP.put((Object)handler, (Object)new class_3611[]{stillFluid, flowingFluid});
        FluidRenderHandlerRegistry.INSTANCE.register(stillFluid, flowingFluid, (FluidRenderHandler)handler);
        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), new class_3611[]{stillFluid, flowingFluid});
    }
}

