/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.spectrum.api.interaction.ItemProvider;
import de.dafuqs.spectrum.api.interaction.ItemProviderRegistry;
import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SpectrumItemProviders {
    public static void register() {
        ItemProviderRegistry.register(class_1802.field_8545, SpectrumItemProviders.iterableProvider((player, stack) -> ((class_9288)stack.method_57825(class_9334.field_49622, (Object)class_9288.field_49334)).method_59714()));
        ItemProviderRegistry.register(class_1802.field_27023, SpectrumItemProviders.iterableProvider((player, stack) -> ((class_9276)stack.method_57825(class_9334.field_49650, (Object)class_9276.field_49289)).method_57421()));
        ItemProviderRegistry.register(SpectrumBlocks.BOTTOMLESS_BUNDLE.method_8389(), new ItemProvider(){

            @Override
            public int provideItems(class_1657 player, class_1799 stack, class_1792 requestedItem, int amount) {
                BottomlessBundleItem.BottomlessStack.Builder builder = BottomlessBundleItem.BottomlessStack.Builder.of(player.method_37908(), stack);
                class_1799 removed = builder.remove(amount);
                if (!removed.method_31574(requestedItem)) {
                    return 0;
                }
                builder.buildAndSet(stack);
                return removed.method_7947();
            }

            @Override
            public int getItemCount(class_1657 player, class_1799 stack, class_1792 requestedItem) {
                BottomlessBundleItem.BottomlessStack bottomlessStack = (BottomlessBundleItem.BottomlessStack)stack.method_57825(SpectrumDataComponentTypes.BOTTOMLESS_STACK, (Object)BottomlessBundleItem.BottomlessStack.DEFAULT);
                if (!bottomlessStack.variant().isOf((Object)requestedItem)) {
                    return 0;
                }
                return (int)Math.min(Integer.MAX_VALUE, bottomlessStack.count());
            }
        });
        ItemProviderRegistry.register(SpectrumItems.BAG_OF_HOLDING, SpectrumItemProviders.iterableProvider((player, stack) -> player == null ? List.of() : player.method_7274().method_54454()));
    }

    public static ItemProvider iterableProvider(final BiFunction<@Nullable class_1657, class_1799, Iterable<class_1799>> iterableFactory) {
        return new ItemProvider(){

            @Override
            public int provideItems(class_1657 player, class_1799 stack, class_1792 requestedItem, int amount) {
                int removedCount = 0;
                for (class_1799 s : (Iterable)iterableFactory.apply(player, stack)) {
                    if (!s.method_31574(requestedItem)) continue;
                    int amountToRemove = Math.min(s.method_7947(), amount - removedCount);
                    s.method_7934(amountToRemove);
                    if ((removedCount += amountToRemove) != amount) continue;
                    break;
                }
                return removedCount;
            }

            @Override
            public int getItemCount(class_1657 player, class_1799 stack, class_1792 requestedItem) {
                int count = 0;
                for (class_1799 s : (Iterable)iterableFactory.apply(player, stack)) {
                    if (!s.method_31574(requestedItem)) continue;
                    count += s.method_7947();
                }
                return count;
            }
        };
    }
}

