/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.client;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkPowered;
import de.dafuqs.spectrum.api.interaction.ItemProvider;
import de.dafuqs.spectrum.api.interaction.ItemProviderRegistry;
import de.dafuqs.spectrum.api.render.DynamicItemRenderer;
import de.dafuqs.spectrum.api.render.DynamicRenderModel;
import de.dafuqs.spectrum.blocks.bottomless_bundle.BottomlessBundleItem;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.data_loaders.ParticleSpawnerParticlesDataLoader;
import de.dafuqs.spectrum.deeper_down.DimensionRenderEffects;
import de.dafuqs.spectrum.deeper_down.HowlingSpireEffects;
import de.dafuqs.spectrum.helpers.BuildingHelper;
import de.dafuqs.spectrum.helpers.TooltipHelper;
import de.dafuqs.spectrum.items.magic_items.BuildingStaffItem;
import de.dafuqs.spectrum.items.magic_items.ConstructorsStaffItem;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.tools.OmniAcceleratorItem;
import de.dafuqs.spectrum.mixin.accessors.WorldRendererAccessor;
import de.dafuqs.spectrum.particle.render.ExtendedParticleManager;
import de.dafuqs.spectrum.progression.UnlockToastManager;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDimensions;
import de.dafuqs.spectrum.registries.SpectrumItemTags;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.client.SpectrumColorProviders;
import de.dafuqs.spectrum.registries.client.SpectrumShaders;
import de.dafuqs.spectrum.render.HudRenderers;
import de.dafuqs.spectrum.sound.BiomeAttenuatingSoundInstance;
import de.dafuqs.spectrum.sound.BlockAuraSoundInstance;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1091;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Triplet;

@Environment(value=EnvType.CLIENT)
public class SpectrumClientEventListeners {
    public static final ObjectOpenHashSet<class_1091> CUSTOM_ITEM_MODELS = new ObjectOpenHashSet();
    private static boolean postProcessWasOn = SpectrumCommon.CONFIG.PostProcess;
    private static int lookingAtUniverseSpyholeTicks = 0;
    @Nullable
    private static class_3965 lookingAtUniverseSpyholeHitResult = null;
    private static boolean lookingAtUniverseSpyholeeffectsPlayed = false;

    private static void registerCustomItemRenderer(String id, class_1792 item, Supplier<DynamicItemRenderer> renderer) {
        CUSTOM_ITEM_MODELS.add((Object)new class_1091(SpectrumCommon.locate(id), "inventory"));
        DynamicItemRenderer.RENDERERS.put((Object)item, (Object)renderer.get());
    }

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ParticleSpawnerParticlesDataLoader.INSTANCE);
        SpectrumClientEventListeners.registerCustomItemRenderer("bottomless_bundle", SpectrumBlocks.BOTTOMLESS_BUNDLE.method_8389(), BottomlessBundleItem.Renderer::new);
        SpectrumClientEventListeners.registerCustomItemRenderer("omni_accelerator", SpectrumItems.OMNI_ACCELERATOR, OmniAcceleratorItem.Renderer::new);
        WorldRenderEvents.START.register(SpectrumClientEventListeners::lambda$register$0);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> ((ExtendedParticleManager)class_310.method_1551().field_1713).render(context.matrixStack(), context.consumers(), context.camera(), context.tickCounter().method_60637(true)));
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            class_1297 focusedEntity = context.camera().method_19331();
            if (focusedEntity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)focusedEntity;
                boolean paintbrushInHand = livingEntity.method_6047().method_31574(SpectrumItems.PAINTBRUSH) || livingEntity.method_6079().method_31574(SpectrumItems.PAINTBRUSH);
                Pastel.getClientInstance().renderLines(context, livingEntity, paintbrushInHand);
            }
        });
        WorldRenderEvents.BLOCK_OUTLINE.register(SpectrumClientEventListeners::renderExtendedBlockOutline);
        BiomeAttenuatingSoundInstance.clear();
        ModelLoadingPlugin.register(ctx -> ctx.modifyModelAfterBake().register((orig, c) -> {
            class_1091 mid;
            class_1091 id = c.topLevelId();
            if (id instanceof class_1091 && CUSTOM_ITEM_MODELS.contains((Object)(mid = id))) {
                return new DynamicRenderModel(orig);
            }
            return orig;
        }));
        ClientLifecycleEvents.CLIENT_STARTED.register(minecraftClient -> SpectrumColorProviders.registerClient());
        ClientPlayConnectionEvents.DISCONNECT.register((clientPacketListener, minecraft) -> {
            Pastel.clearClientInstance();
            UnlockToastManager.clear();
        });
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            if (stack.method_57826(class_9334.field_50075) && class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().equals("spectrum")) {
                TooltipHelper.addFoodComponentEffectTooltip(stack, lines, tooltipContext.method_59531());
            }
            if (stack.method_31573(SpectrumItemTags.COMING_SOON_TOOLTIP)) {
                lines.add(class_2561.method_43471((String)"spectrum.tooltip.coming_soon").method_27692(class_124.field_1061));
            }
        });
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> {
            if (SpectrumCommon.CONFIG.PostProcess && world.method_27983().equals(SpectrumDimensions.DIMENSION_KEY)) {
                SpectrumClientEventListeners.initializeColorGrading(client);
            } else {
                SpectrumShaders.clearDimensionShaders();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_638 world = client.field_1687;
            class_1297 cameraEntity = client.method_1560();
            if (world == null || cameraEntity == null) {
                BiomeAttenuatingSoundInstance.clear();
                BlockAuraSoundInstance.clear();
                return;
            }
            class_6880 biome = world.method_23753(client.method_1560().method_24515());
            HowlingSpireEffects.clientTick(world, cameraEntity, (class_6880<class_1959>)biome);
            DimensionRenderEffects.clientTick(world, cameraEntity, (class_6880<class_1959>)biome);
            if (lookingAtUniverseSpyholeTicks > 0 && lookingAtUniverseSpyholeHitResult != null) {
                SpectrumClientEventListeners.playLookingAtUniverseSpyholeParticles(cameraEntity, world);
            }
            if (SpectrumCommon.CONFIG.PostProcess) {
                if (!postProcessWasOn) {
                    SpectrumClientEventListeners.initializeColorGrading(client);
                    postProcessWasOn = true;
                }
                SpectrumShaders.updateDimensionShaders(world);
            } else if (postProcessWasOn) {
                SpectrumShaders.clearDimensionShaders();
                postProcessWasOn = false;
            }
        });
    }

    private static void playLookingAtUniverseSpyholeParticles(class_1297 cameraEntity, class_638 world) {
        int particleCountPerSide;
        class_2400 particleType = class_2398.field_11214;
        if (!lookingAtUniverseSpyholeeffectsPlayed) {
            particleType = class_2398.field_23190;
            cameraEntity.method_5783(SpectrumSoundEvents.SOFT_HUM, 1.0f, 1.0f);
            particleCountPerSide = 20;
            lookingAtUniverseSpyholeeffectsPlayed = true;
        } else {
            particleCountPerSide = Math.max(1, 10 - lookingAtUniverseSpyholeTicks);
        }
        class_2338 pos = lookingAtUniverseSpyholeHitResult.method_17777();
        class_5819 random = world.method_8409();
        for (int i = 0; i < particleCountPerSide; ++i) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 blockPos = pos.method_10093(direction);
                class_2680 blockState = world.method_8320(blockPos);
                if (blockState.method_26206((class_1922)world, blockPos, direction.method_10153())) continue;
                double d = direction.method_10148() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10148() * 0.6;
                double e = direction.method_10164() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10164() * 0.6;
                double f = direction.method_10165() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10165() * 0.6;
                world.method_8406((class_2394)particleType, (double)pos.method_10263() + d, (double)pos.method_10264() + e, (double)pos.method_10260() + f, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void initializeColorGrading(class_310 client) {
        if (SpectrumShaders.colorGradingPostProcess.isEmpty()) {
            SpectrumShaders.colorGradingPostProcess = SpectrumShaders.loadPostProcess(client, SpectrumShaders.COLOR_GRADING_ID);
        }
    }

    private static boolean renderExtendedBlockOutline(WorldRenderContext context, WorldRenderContext.BlockOutlineContext hitResult) {
        boolean shouldCancel = false;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && context.blockOutlines()) {
            for (class_1799 handStack : client.field_1724.method_5877()) {
                class_1792 handItem = handStack.method_7909();
                if (handItem instanceof ConstructorsStaffItem) {
                    class_239 class_2393;
                    if (hitResult == null || !((class_2393 = client.field_1765) instanceof class_3965)) break;
                    class_3965 blockHitResult = (class_3965)class_2393;
                    shouldCancel = SpectrumClientEventListeners.renderPlacementStaffOutline(context.matrixStack(), context.camera(), hitResult.cameraX(), hitResult.cameraY(), hitResult.cameraZ(), context.consumers(), blockHitResult);
                    break;
                }
                if (!(handItem instanceof ExchangeStaffItem)) continue;
                if (hitResult == null) break;
                shouldCancel = SpectrumClientEventListeners.renderExchangeStaffOutline(context.matrixStack(), context.camera(), hitResult.cameraX(), hitResult.cameraY(), hitResult.cameraZ(), context.consumers(), handStack, hitResult);
                break;
            }
        }
        return !shouldCancel;
    }

    private static boolean renderPlacementStaffOutline(class_4587 matrices, class_4184 camera, double d, double e, double f, class_4597 consumers, @NotNull class_3965 hitResult) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (player == null || world == null) {
            return false;
        }
        class_2338 lookingAtPos = hitResult.method_17777();
        class_2680 lookingAtState = world.method_8320(lookingAtPos);
        class_1792 class_17922 = player.method_6047().method_7909();
        if (class_17922 instanceof BuildingStaffItem) {
            BuildingStaffItem staff = (BuildingStaffItem)class_17922;
            if (player.method_7337() || staff.canInteractWith(lookingAtState, (class_1922)world, lookingAtPos, (class_1657)player)) {
                class_2248 lookingAtBlock = lookingAtState.method_26204();
                class_1792 item = lookingAtBlock.method_8389();
                class_265 shape = class_259.method_1073();
                if (item != class_1802.field_8162) {
                    int itemCountInInventory = Integer.MAX_VALUE;
                    long inkLimit = Long.MAX_VALUE;
                    if (!player.method_7337()) {
                        Triplet<class_2248, class_1792, Integer> inventoryItemAndCount = BuildingHelper.getBuildingItemCountInInventoryIncludingSimilars((class_1657)player, lookingAtBlock, Integer.MAX_VALUE);
                        item = (class_1792)inventoryItemAndCount.getB();
                        itemCountInInventory = (Integer)inventoryItemAndCount.getC();
                        inkLimit = InkPowered.getAvailableInk((class_1657)player, ConstructorsStaffItem.USED_COLOR) / 1L;
                    }
                    boolean sneaking = player.method_5715();
                    if (itemCountInInventory == 0) {
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)item), 0, false);
                    } else if (inkLimit == 0L) {
                        HudRenderers.setItemStackToRender(new class_1799((class_1935)item), 1, true);
                    } else {
                        long usableCount = Math.min((long)itemCountInInventory, inkLimit);
                        List<class_2338> positions = BuildingHelper.calculateBuildingStaffSelection((class_1937)world, lookingAtPos, hitResult.method_17780(), usableCount, ConstructorsStaffItem.getRange((class_1657)player), !sneaking);
                        if (!positions.isEmpty()) {
                            for (class_2338 newPosition : positions) {
                                if (!world.method_8621().method_11952(newPosition)) continue;
                                class_2338 testPos = lookingAtPos.method_10059((class_2382)newPosition);
                                shape = class_259.method_1084((class_265)shape, (class_265)lookingAtState.method_26172((class_1922)world, lookingAtPos, class_3726.method_16195((class_1297)camera.method_19331())).method_1096((double)(-testPos.method_10263()), (double)(-testPos.method_10264()), (double)(-testPos.method_10260())));
                            }
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)item), positions.size(), false);
                            class_4588 linesBuffer = consumers.getBuffer(class_1921.method_23594());
                            WorldRendererAccessor.invokeRenderShape(matrices, linesBuffer, shape, (double)lookingAtPos.method_10263() - d, (double)lookingAtPos.method_10264() - e, (double)lookingAtPos.method_10260() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean renderExchangeStaffOutline(class_4587 matrices, class_4184 camera, double d, double e, double f, class_4597 consumers, class_1799 exchangeStaffItemStack, WorldRenderContext.BlockOutlineContext hitResult) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_2338 lookingAtPos = hitResult.blockPos();
        class_2680 lookingAtState = hitResult.blockState();
        class_746 player = client.field_1724;
        if (player == null || world == null) {
            return false;
        }
        class_1792 class_17922 = player.method_6047().method_7909();
        if (class_17922 instanceof BuildingStaffItem) {
            BuildingStaffItem staff = (BuildingStaffItem)class_17922;
            if (player.method_7337() || staff.canInteractWith(lookingAtState, (class_1922)world, lookingAtPos, (class_1657)player)) {
                class_2248 lookingAtBlock = lookingAtState.method_26204();
                Optional<class_2248> exchangeBlock = ExchangeStaffItem.getStoredBlock(exchangeStaffItemStack);
                if (exchangeBlock.isPresent() && exchangeBlock.get() != lookingAtBlock) {
                    class_1792 exchangeBlockItem = exchangeBlock.get().method_8389();
                    class_265 shape = class_259.method_1073();
                    if (exchangeBlockItem != class_1802.field_8162) {
                        int itemCountInInventory = Integer.MAX_VALUE;
                        long inkLimit = Integer.MAX_VALUE;
                        if (!player.method_7337()) {
                            class_1661 playerInventory = player.method_31548();
                            itemCountInInventory = playerInventory.method_18861(exchangeBlockItem);
                            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                                class_1799 currentStack = playerInventory.method_5438(i);
                                ItemProvider itemProvider = ItemProviderRegistry.getProvider(currentStack);
                                if (itemProvider == null) continue;
                                itemCountInInventory += itemProvider.getItemCount((class_1657)player, currentStack, exchangeBlockItem);
                            }
                            inkLimit = InkPowered.getAvailableInk((class_1657)player, ExchangeStaffItem.USED_COLOR) / 5L;
                        }
                        if (itemCountInInventory == 0) {
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), 0, false);
                        } else if (inkLimit == 0L) {
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), 1, true);
                        } else {
                            long usableCount = Math.min((long)itemCountInInventory, inkLimit);
                            List<class_2338> positions = BuildingHelper.getConnectedBlocks((class_1937)world, lookingAtPos, usableCount, ExchangeStaffItem.getRange((class_1657)player));
                            for (class_2338 newPosition : positions) {
                                if (!world.method_8621().method_11952(newPosition)) continue;
                                class_2338 testPos = lookingAtPos.method_10059((class_2382)newPosition);
                                shape = class_259.method_1084((class_265)shape, (class_265)lookingAtState.method_26172((class_1922)world, lookingAtPos, class_3726.method_16195((class_1297)camera.method_19331())).method_1096((double)(-testPos.method_10263()), (double)(-testPos.method_10264()), (double)(-testPos.method_10260())));
                            }
                            HudRenderers.setItemStackToRender(new class_1799((class_1935)exchangeBlockItem), positions.size(), false);
                            class_4588 linesBuffer = consumers.getBuffer(class_1921.method_23594());
                            WorldRendererAccessor.invokeRenderShape(matrices, linesBuffer, shape, (double)lookingAtPos.method_10263() - d, (double)lookingAtPos.method_10264() - e, (double)lookingAtPos.method_10260() - f, 0.0f, 0.0f, 0.0f, 0.4f);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$register$0(WorldRenderContext context) {
        block6: {
            HudRenderers.clearItemStackOverlay();
            client = class_310.method_1551();
            if (client.field_1724 == null) break block6;
            patt0$temp = client.field_1765;
            if (!(patt0$temp instanceof class_3965)) ** GOTO lbl-1000
            blockHitResult = (class_3965)patt0$temp;
            if (client.field_1724.method_37908().method_8320(blockHitResult.method_17777()).method_26204() == SpectrumBlocks.UNIVERSE_SPYHOLE) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = lookingAtUniverseSpyhole = false;
            }
            if (lookingAtUniverseSpyhole) {
                ++SpectrumClientEventListeners.lookingAtUniverseSpyholeTicks;
                SpectrumClientEventListeners.lookingAtUniverseSpyholeHitResult = (class_3965)client.field_1765;
            } else {
                SpectrumClientEventListeners.lookingAtUniverseSpyholeTicks = 0;
                SpectrumClientEventListeners.lookingAtUniverseSpyholeHitResult = null;
                SpectrumClientEventListeners.lookingAtUniverseSpyholeeffectsPlayed = false;
            }
            v1 = newSmartCull = lookingAtUniverseSpyhole == false;
            if (client.field_1730 != newSmartCull) {
                client.field_1730 = newSmartCull;
                if (!newSmartCull) {
                    client.field_1769.method_3292();
                }
            }
        }
    }
}

