/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.client;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.energy.storage.SingleInkStorage;
import de.dafuqs.spectrum.blocks.conditional.colored_tree.ColoredLeavesBlock;
import de.dafuqs.spectrum.blocks.memory.MemoryBlockEntity;
import de.dafuqs.spectrum.blocks.memory.MemoryItem;
import de.dafuqs.spectrum.components.InfusedBeverageComponent;
import de.dafuqs.spectrum.items.energy.InkFlaskItem;
import de.dafuqs.spectrum.progression.ToggleableBlockColorProvider;
import de.dafuqs.spectrum.progression.ToggleableItemColorProvider;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumDataComponentTypes;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_5253;

public class SpectrumColorProviders {
    public static ToggleableBlockColorProvider coloredLeavesBlockColorProvider;
    public static ToggleableItemColorProvider coloredLeavesItemColorProvider;
    public static ToggleableBlockColorProvider amaranthBushelBlockColorProvider;
    public static ToggleableItemColorProvider amaranthBushelItemColorProvider;
    public static ToggleableBlockColorProvider amaranthCropBlockColorProvider;
    public static ToggleableItemColorProvider amaranthCropItemColorProvider;

    public static void registerClient() {
        SpectrumCommon.logInfo("Registering Block and Item Color Providers...");
        SpectrumColorProviders.registerColoredLeaves();
        SpectrumColorProviders.registerAmaranth();
        SpectrumColorProviders.registerClovers(SpectrumBlocks.CLOVER, SpectrumBlocks.FOUR_LEAF_CLOVER);
        SpectrumColorProviders.registerMemory(SpectrumBlocks.MEMORY);
        SpectrumColorProviders.registerPotionFillables(SpectrumItems.LESSER_POTION_PENDANT, SpectrumItems.GREATER_POTION_PENDANT, SpectrumItems.MALACHITE_GLASS_AMPOULE);
        SpectrumColorProviders.registerPickyPotionFillables(new class_1792[]{SpectrumItems.NIGHTFALLS_BLADE, SpectrumItems.CONCEALING_OILS});
        SpectrumColorProviders.registerSingleInkStorages(SpectrumItems.INK_FLASK);
        SpectrumColorProviders.registerBrewColors(SpectrumItems.INFUSED_BEVERAGE);
        SpectrumColorProviders.registerOptionalInkColor(SpectrumItems.PAINTBRUSH);
    }

    private static void registerColoredLeaves() {
        class_322 leavesBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10503);
        class_326 leavesItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10503);
        if (leavesBlockColorProvider != null && leavesItemColorProvider != null) {
            coloredLeavesBlockColorProvider = new ToggleableBlockColorProvider(leavesBlockColorProvider);
            coloredLeavesItemColorProvider = new ToggleableItemColorProvider(leavesItemColorProvider);
            for (InkColor color : InkColors.all()) {
                ColoredLeavesBlock block = ColoredLeavesBlock.byColor(color);
                ColorProviderRegistry.BLOCK.register((Object)coloredLeavesBlockColorProvider, (Object[])new class_2248[]{block});
                ColorProviderRegistry.ITEM.register((Object)coloredLeavesItemColorProvider, (Object[])new class_1935[]{block});
            }
        }
    }

    private static void registerAmaranth() {
        class_322 fernBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10112);
        class_326 fernItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10112);
        if (fernBlockColorProvider != null && fernItemColorProvider != null) {
            amaranthBushelBlockColorProvider = new ToggleableBlockColorProvider(fernBlockColorProvider);
            amaranthBushelItemColorProvider = new ToggleableItemColorProvider(fernItemColorProvider);
            ColorProviderRegistry.BLOCK.register((Object)amaranthBushelBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.AMARANTH_BUSHEL});
            ColorProviderRegistry.ITEM.register((Object)amaranthBushelItemColorProvider, (Object[])new class_1935[]{SpectrumBlocks.AMARANTH_BUSHEL});
            ColorProviderRegistry.BLOCK.register((Object)amaranthBushelBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.POTTED_AMARANTH_BUSHEL});
        }
        class_322 largeFernBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10313);
        class_326 largeFernItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10313);
        if (largeFernBlockColorProvider != null && largeFernItemColorProvider != null) {
            amaranthCropBlockColorProvider = new ToggleableBlockColorProvider(largeFernBlockColorProvider);
            amaranthCropItemColorProvider = new ToggleableItemColorProvider(largeFernItemColorProvider);
            ColorProviderRegistry.BLOCK.register((Object)amaranthCropBlockColorProvider, (Object[])new class_2248[]{SpectrumBlocks.AMARANTH});
            ColorProviderRegistry.ITEM.register((Object)amaranthCropItemColorProvider, (Object[])new class_1935[]{SpectrumBlocks.AMARANTH});
        }
    }

    private static void registerClovers(class_2248 ... clovers) {
        class_322 grassBlockColorProvider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10479);
        class_326 grassItemColorProvider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10479.method_8389());
        if (grassBlockColorProvider != null && grassItemColorProvider != null) {
            ColorProviderRegistry.BLOCK.register((Object)grassBlockColorProvider, (Object[])clovers);
        }
    }

    private static void registerSingleInkStorages(class_1792 ... items) {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                InkFlaskItem i = (InkFlaskItem)stack.method_7909();
                SingleInkStorage storage = i.getEnergyStorage(stack);
                return class_5253.class_5254.method_57174((int)storage.getStoredColor().getColorInt());
            }
            return -1;
        }, (Object[])items);
    }

    private static void registerPickyPotionFillables(class_1792 ... items) {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            List<InkPoweredStatusEffectInstance> effects;
            if (tintIndex == 1 && !(effects = InkPoweredStatusEffectInstance.getEffects(stack)).isEmpty()) {
                return class_5253.class_5254.method_57174((int)effects.getFirst().getColor());
            }
            return -1;
        }, (Object[])items);
    }

    private static void registerPotionFillables(class_1792 ... items) {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            List<InkPoweredStatusEffectInstance> effects;
            if (tintIndex > 0 && (effects = InkPoweredStatusEffectInstance.getEffects(stack)).size() > tintIndex - 1) {
                return class_5253.class_5254.method_57174((int)effects.get(tintIndex - 1).getColor());
            }
            return -1;
        }, (Object[])items);
    }

    private static void registerMemory(class_2248 memory) {
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world == null) {
                return 0;
            }
            class_2586 patt0$temp = world.method_8321(pos);
            if (patt0$temp instanceof MemoryBlockEntity) {
                MemoryBlockEntity memoryBlockEntity = (MemoryBlockEntity)patt0$temp;
                return memoryBlockEntity.getEggColor(tintIndex);
            }
            return 0;
        }, (Object[])new class_2248[]{memory});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 2) {
                return -1;
            }
            return class_5253.class_5254.method_57174((int)MemoryItem.getEggColor(stack, tintIndex));
        }, (Object[])new class_1935[]{memory.method_8389()});
    }

    public static void registerBrewColors(class_1792 brew) {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return class_5253.class_5254.method_57174((int)-1);
            }
            return class_5253.class_5254.method_57174((int)((InfusedBeverageComponent)stack.method_57825(SpectrumDataComponentTypes.INFUSED_BEVERAGE, (Object)InfusedBeverageComponent.DEFAULT)).color());
        }, (Object[])new class_1935[]{brew});
    }

    public static void registerOptionalInkColor(class_1792 item) {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                InkColor color = (InkColor)stack.method_57824(SpectrumDataComponentTypes.INK_COLOR);
                return class_5253.class_5254.method_57174((int)(color == null ? -1 : color.getColorInt()));
            }
            return -1;
        }, (Object[])new class_1935[]{item});
    }

    public static void resetToggleableProviders() {
        coloredLeavesBlockColorProvider.setShouldApply(true);
        coloredLeavesItemColorProvider.setShouldApply(true);
        amaranthBushelBlockColorProvider.setShouldApply(true);
        amaranthBushelItemColorProvider.setShouldApply(true);
        amaranthCropBlockColorProvider.setShouldApply(true);
        amaranthCropItemColorProvider.setShouldApply(true);
    }
}

