/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.render;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeComponent;
import de.dafuqs.spectrum.cca.azure_dike.AzureDikeProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class HudRenderers {
    private static final class_2561 missingInkText = class_2561.method_43471((String)"item.spectrum.constructors_staff.tooltip.missing_ink");
    private static final class_2561 noneText = class_2561.method_43471((String)"item.spectrum.constructors_staff.tooltip.none_in_inventory");
    private static class_1799 itemStackToRender;
    private static int amount;
    private static boolean missingInk;
    private static final int SPECTRUM$_DIKE_HEARTS_PER_ROW = 10;
    private static final int SPECTRUM$_DIKE_PER_ROW = 20;

    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> HudRenderers.renderSelectedStaffStack(drawContext));
    }

    public static void renderAzureDike(class_332 drawContext, class_1657 cameraPlayer, int x, int y) {
        AzureDikeComponent azureDikeComponent = AzureDikeProvider.getAzureDikeComponent((class_1309)cameraPlayer);
        int maxCharges = (int)Math.ceil(azureDikeComponent.getMaxProtection());
        if (maxCharges > 0) {
            int i;
            int charges = (int)Math.ceil(azureDikeComponent.getCurrentProtection());
            boolean blink = false;
            if (cameraPlayer.method_6081() != null && cameraPlayer.method_37908() != null) {
                blink = (cameraPlayer.method_37908().method_8510() >> 2) % 2L == 0L;
            }
            int totalDikeCanisters = (maxCharges - 1) / 20;
            int filledDikeCanisters = (charges - 1) / 20;
            int displayedDike = (charges - 1) % 20 + 1;
            int dikeHeartOutlinesThisRow = totalDikeCanisters > filledDikeCanisters ? 10 : (maxCharges - 1) % 20 / 2 + 1;
            boolean renderBackRow = filledDikeCanisters > 0;
            boolean hasArmor = cameraPlayer.method_6096() > 0;
            class_2960 texture = AzureDikeComponent.AZURE_DIKE_BAR_TEXTURE;
            x += SpectrumCommon.CONFIG.AzureDikeHudOffsetX;
            y += hasArmor ? SpectrumCommon.CONFIG.AzureDikeHudOffsetYWithArmor : SpectrumCommon.CONFIG.AzureDikeHudOffsetY;
            RenderSystem.enableBlend();
            if (renderBackRow) {
                for (i = displayedDike / 2; i < 10; ++i) {
                    drawContext.method_25290(texture, x + i * 8, y, 36.0f, 9.0f, 9, 9, 256, 256);
                }
            }
            for (i = 0; i < dikeHeartOutlinesThisRow; ++i) {
                if (renderBackRow) {
                    if (blink) {
                        drawContext.method_25290(texture, x + i * 8, y, 54.0f, 9.0f, 9, 9, 256, 256);
                        continue;
                    }
                    drawContext.method_25290(texture, x + i * 8, y, 45.0f, 9.0f, 9, 9, 256, 256);
                    continue;
                }
                if (blink) {
                    drawContext.method_25290(texture, x + i * 8, y, 9.0f, 9.0f, 9, 9, 256, 256);
                    continue;
                }
                drawContext.method_25290(texture, x + i * 8, y, 0.0f, 9.0f, 9, 9, 256, 256);
            }
            for (i = 0; i < displayedDike; i += 2) {
                if (i + 1 < displayedDike) {
                    drawContext.method_25290(texture, x + i * 4, y, 18.0f, 9.0f, 9, 9, 256, 256);
                    continue;
                }
                drawContext.method_25290(texture, x + i * 4, y, 27.0f, 9.0f, 9, 9, 256, 256);
            }
            for (i = 0; i < filledDikeCanisters; ++i) {
                drawContext.method_25290(texture, x + i * 6, y - 9, 0.0f, 0.0f, 9, 9, 256, 256);
            }
            for (i = filledDikeCanisters; i < totalDikeCanisters; ++i) {
                drawContext.method_25290(texture, x + i * 6, y - 9, 9.0f, 0.0f, 9, 9, 256, 256);
            }
            RenderSystem.disableBlend();
        }
    }

    private static void renderSelectedStaffStack(class_332 drawContext) {
        class_310 client = class_310.method_1551();
        if (amount > -1 && itemStackToRender != null) {
            class_1041 window = class_310.method_1551().method_22683();
            int x = window.method_4486() / 2 + 3;
            int y = window.method_4502() / 2 + 3;
            class_4587 poseStack = drawContext.method_51448();
            poseStack.method_22903();
            poseStack.method_22905(0.5f, 0.5f, 1.0f);
            class_327 textRenderer = client.field_1772;
            drawContext.method_51427(itemStackToRender, (x + 8) * 2, (y + 8) * 2);
            poseStack.method_22905(2.0f, 2.0f, 1.0f);
            drawContext.method_51439(textRenderer, itemStackToRender.method_7964(), x + 18, y + 8, 0xFFFFFF, false);
            if (amount == 0) {
                drawContext.method_51439(textRenderer, noneText, x + 18, y + 19, 0xDDDDDD, false);
            } else if (missingInk) {
                drawContext.method_51439(textRenderer, missingInkText, x + 18, y + 19, 0xDDDDDD, false);
            } else {
                drawContext.method_51433(textRenderer, amount + "x", x + 18, y + 19, 0xDDDDDD, false);
            }
            poseStack.method_22909();
        }
    }

    public static void setItemStackToRender(class_1799 itemStack, int amount, boolean missingInk) {
        itemStackToRender = itemStack;
        HudRenderers.amount = amount;
        HudRenderers.missingInk = missingInk;
    }

    public static void clearItemStackOverlay() {
        amount = -1;
    }
}

