/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.sound;

import de.dafuqs.spectrum.registries.SpectrumBiomes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class BiomeAttenuatingSoundInstance
extends class_1102
implements class_1117 {
    @Nullable
    public static BiomeAttenuatingSoundInstance WIND_HIGH = null;
    @Nullable
    public static BiomeAttenuatingSoundInstance WIND_LOW = null;
    @Nullable
    public static BiomeAttenuatingSoundInstance SHOWER = null;
    @Nullable
    public static BiomeAttenuatingSoundInstance LAMENTS = null;
    private static boolean clear = true;
    private final class_310 client = class_310.method_1551();
    private static final int MAX_DURATION = 80;
    private final class_5321<class_1959> biome;
    private final float volumeMod;
    private float coverage;
    private float lastCoverage;
    private int biomeTicks = 1;
    private int coverageUpdateTicks;
    private final boolean altPitch;
    private boolean finished;

    protected BiomeAttenuatingSoundInstance(class_5321<class_1959> biome, class_3414 sound, float volumeMod, boolean altMod) {
        super(sound, class_3419.field_15256, class_1113.method_43221());
        this.field_5446 = true;
        this.field_5451 = 0;
        this.biome = biome;
        this.volumeMod = volumeMod;
        this.altPitch = altMod;
        this.field_18936 = true;
        class_1297 camera = this.client.method_1560();
        if (camera != null) {
            this.updateCoverage(camera.method_37908(), camera);
        }
        this.updateVolumeAndPitch();
    }

    public void method_16896() {
        class_1297 camera = this.client.method_1560();
        if (camera == null) {
            this.finished = true;
            return;
        }
        class_1937 world = camera.method_37908();
        if (this.coverageUpdateTicks < 15) {
            ++this.coverageUpdateTicks;
        }
        if (this.coverageUpdateTicks == 15) {
            this.coverageUpdateTicks = 0;
            this.updateCoverage(world, camera);
        }
        if (world.method_23753(camera.method_24515()).method_40225(this.biome) && this.biomeTicks < 80) {
            ++this.biomeTicks;
        } else if (this.biomeTicks > 0) {
            --this.biomeTicks;
        }
        this.updateVolumeAndPitch();
    }

    private void updateCoverage(class_1937 world, class_1297 camera) {
        class_2338 pos = class_2338.method_49638((class_2374)camera.method_33571());
        this.lastCoverage = this.coverage;
        this.coverage = 0.0f;
        block0: for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11033) continue;
            boolean up = direction == class_2350.field_11036;
            int max = up ? 13 : 7;
            for (int i = 1; i < max; ++i) {
                class_2338 offPos = pos.method_10079(direction, i);
                class_2680 state = world.method_8320(offPos);
                if (up) {
                    if (!state.method_26206((class_1922)world, offPos, direction.method_10153()) && !state.method_26206((class_1922)world, offPos, direction)) continue;
                    this.coverage += 0.1334f / (float)i;
                    continue block0;
                }
                if (!state.method_26206((class_1922)world, offPos, direction.method_10153()) && !state.method_26206((class_1922)world, offPos, direction)) continue;
                this.coverage += 0.16f / (float)i;
                continue block0;
            }
        }
    }

    private void updateVolumeAndPitch() {
        float coverageMod = class_3532.method_37166((float)this.lastCoverage, (float)this.coverage, (float)((float)this.coverageUpdateTicks / 15.0f)) + 0.1f;
        if (!this.altPitch) {
            coverageMod *= 1.5f;
        }
        coverageMod = Math.max(1.0f - coverageMod, 0.0f);
        this.field_5442 = Math.max(0.0f, (float)this.biomeTicks / 80.0f) * this.volumeMod * coverageMod;
        this.field_5441 = (this.altPitch ? 0.9f : 0.65f) * class_3532.method_15363((float)(coverageMod * 2.0f), (float)0.5f, (float)1.0f);
    }

    public boolean method_4793() {
        return this.biomeTicks == 0 || this.finished;
    }

    public static void update(class_6880<class_1959> biome) {
        class_310 client = class_310.method_1551();
        clear = false;
        if (WIND_HIGH != null && WIND_HIGH.method_4793()) {
            WIND_HIGH = null;
        }
        if (WIND_LOW != null && WIND_LOW.method_4793()) {
            WIND_LOW = null;
        }
        if (SHOWER != null && SHOWER.method_4793()) {
            SHOWER = null;
        }
        if (LAMENTS != null && LAMENTS.method_4793()) {
            LAMENTS = null;
        }
        if (biome.method_40225(SpectrumBiomes.HOWLING_SPIRES)) {
            if (WIND_HIGH == null) {
                WIND_HIGH = new BiomeAttenuatingSoundInstance(SpectrumBiomes.HOWLING_SPIRES, SpectrumSoundEvents.HOWLING_WIND_HIGH, 0.525f, false);
                client.method_1483().method_4873((class_1113)WIND_HIGH);
            }
            if (WIND_LOW == null) {
                WIND_LOW = new BiomeAttenuatingSoundInstance(SpectrumBiomes.HOWLING_SPIRES, SpectrumSoundEvents.HOWLING_WIND_LOW, 1.8f, true);
                client.method_1483().method_4873((class_1113)WIND_LOW);
            }
        } else if (biome.method_40225(SpectrumBiomes.DEEP_DRIPSTONE_CAVES)) {
            if (SHOWER == null) {
                SHOWER = new BiomeAttenuatingSoundInstance(SpectrumBiomes.DEEP_DRIPSTONE_CAVES, SpectrumSoundEvents.SHOWER, 2.0f, false);
                client.method_1483().method_4873((class_1113)SHOWER);
            }
        } else if (biome.method_40225(SpectrumBiomes.DRAGONROT_SWAMP)) {
            if (LAMENTS == null) {
                LAMENTS = new BiomeAttenuatingSoundInstance(SpectrumBiomes.DRAGONROT_SWAMP, SpectrumSoundEvents.LAMENTS, 1.25f, true);
                client.method_1483().method_4873((class_1113)LAMENTS);
            }
            if (SHOWER == null) {
                SHOWER = new BiomeAttenuatingSoundInstance(SpectrumBiomes.DRAGONROT_SWAMP, SpectrumSoundEvents.SHOWER, 2.0f, false);
                client.method_1483().method_4873((class_1113)SHOWER);
            }
        }
    }

    public static void clear() {
        if (clear) {
            return;
        }
        if (WIND_HIGH != null) {
            BiomeAttenuatingSoundInstance.WIND_HIGH.finished = true;
            WIND_HIGH = null;
        }
        if (WIND_LOW != null) {
            BiomeAttenuatingSoundInstance.WIND_LOW.finished = true;
            WIND_LOW = null;
        }
        if (SHOWER != null) {
            BiomeAttenuatingSoundInstance.SHOWER.finished = true;
            SHOWER = null;
        }
        if (LAMENTS != null) {
            BiomeAttenuatingSoundInstance.LAMENTS.finished = true;
            LAMENTS = null;
        }
        clear = true;
    }
}

