/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.spells;

import com.google.common.collect.Maps;
import de.dafuqs.spectrum.api.block.MoonstoneStrikeableBlock;
import de.dafuqs.spectrum.networking.s2c_payloads.MoonstoneBlastPayload;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class MoonstoneStrike {
    private final class_1937 world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    public final class_1297 entity;
    public final float power;
    public final float knockbackMod;
    private final class_1282 damageSource;
    protected final Map<class_1657, class_243> affectedPlayers = Maps.newHashMap();

    public MoonstoneStrike(class_1937 world, @Nullable class_1297 entity, @Nullable class_1282 damageSource, double x, double y, double z, float power, float knockbackMod) {
        this.world = world;
        this.entity = entity;
        this.power = power;
        this.knockbackMod = knockbackMod;
        this.x = x;
        this.y = y;
        this.z = z;
        this.damageSource = damageSource == null ? SpectrumDamageTypes.moonstoneStrike(world, this) : damageSource;
    }

    public static void create(class_1937 world, class_1297 entity, @Nullable class_1282 damageSource, double x, double y, double z, float power) {
        MoonstoneStrike.create(world, entity, damageSource, x, y, z, power, power);
    }

    public static void create(class_1937 world, class_1297 entity, @Nullable class_1282 damageSource, double x, double y, double z, float power, float knockbackMod) {
        MoonstoneStrike moonstoneStrike = new MoonstoneStrike(world, entity, damageSource, x, y, z, power, knockbackMod);
        if (world.field_9236) {
            world.method_8486(x, y, z, SpectrumSoundEvents.MOONSTONE_STRIKE, class_3419.field_15245, 4.0f, (1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2f) * 0.7f, false);
            world.method_8486(x, y, z, SpectrumSoundEvents.SOFT_HUM, class_3419.field_15245, 0.5f, (1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2f) * 0.7f, false);
            world.method_8406((class_2394)SpectrumParticleTypes.MOONSTONE_STRIKE, x, y, z, 1.0, 0.0, 0.0);
        } else {
            moonstoneStrike.damageAndKnockbackEntities();
            MoonstoneBlastPayload.sendMoonstoneBlast((class_3218)world, moonstoneStrike);
            moonstoneStrike.affectWorld();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPower() {
        return this.power;
    }

    public float getKnockbackMod() {
        return this.knockbackMod;
    }

    public class_1282 getDamageSource() {
        return this.damageSource;
    }

    public Map<class_1657, class_243> getAffectedPlayers() {
        return this.affectedPlayers;
    }

    public void damageAndKnockbackEntities() {
        this.world.method_43275(this.entity, (class_6880)class_5712.field_28178, new class_243(this.x, this.y, this.z));
        float reach = this.power * 2.0f;
        int minX = class_3532.method_15357((double)(this.x - (double)reach - 1.0));
        int maxX = class_3532.method_15357((double)(this.x + (double)reach + 1.0));
        int minY = class_3532.method_15357((double)(this.y - (double)reach - 1.0));
        int maxY = class_3532.method_15357((double)(this.y + (double)reach + 1.0));
        int minZ = class_3532.method_15357((double)(this.z - (double)reach - 1.0));
        int maxZ = class_3532.method_15357((double)(this.z + (double)reach + 1.0));
        class_243 center = new class_243(this.x, this.y, this.z);
        for (class_1297 entity : this.world.method_8335(this.entity, new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ))) {
            class_1657 playerEntity;
            double dz;
            double dy;
            double dx;
            double dLen;
            double unitDist;
            if (entity.method_5659(null) || !((unitDist = Math.sqrt(entity.method_5707(center)) / (double)reach) <= 1.0) || (dLen = Math.sqrt((dx = entity.method_23317() - this.x) * dx + (dy = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.y) * dy + (dz = entity.method_23321() - this.z) * dz)) == 0.0) continue;
            dx /= dLen;
            dy /= dLen;
            dz /= dLen;
            double scaledExposure = (1.0 - unitDist) * (double)class_1927.method_17752((class_243)center, (class_1297)entity);
            entity.method_5643(this.damageSource, (float)((scaledExposure * scaledExposure + scaledExposure) / 2.0 * 7.0 * (double)reach + 1.0));
            double knockback = scaledExposure * (double)this.knockbackMod;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                knockback *= 1.0 - livingEntity.method_45325(class_5134.field_51580);
            }
            class_243 impact = new class_243(dx *= knockback, dy *= knockback, dz *= knockback);
            entity.method_18799(entity.method_18798().method_1019(impact));
            if (!(!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).method_7325() || playerEntity.method_7337() && playerEntity.method_31549().field_7479)) {
                this.affectedPlayers.put(playerEntity, impact);
            }
            entity.method_56918(this.entity);
        }
    }

    public void affectWorld() {
        class_1309 cause = this.getCausingEntity();
        int range = Math.max(2, (int)this.power / 2);
        for (class_2338 pos : class_2338.method_25996((class_2338)class_2338.method_49637((double)this.x, (double)this.y, (double)this.z), (int)range, (int)range, (int)range)) {
            class_2680 blockState = this.world.method_8320(pos);
            class_2248 block = blockState.method_26204();
            if (!(block instanceof MoonstoneStrikeableBlock)) continue;
            MoonstoneStrikeableBlock moonstoneStrikeableBlock = (MoonstoneStrikeableBlock)block;
            moonstoneStrikeableBlock.onMoonstoneStrike(this.world, pos, cause);
        }
    }

    @Nullable
    public class_1309 getCausingEntity() {
        class_1676 projectileEntity;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity;
        }
        class_12972 = this.entity;
        if (class_12972 instanceof class_1676 && (class_12972 = (projectileEntity = (class_1676)class_12972).method_24921()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity;
        }
        return null;
    }
}

