/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.status_effects;

import de.dafuqs.spectrum.cca.LastKillComponent;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.SleepStatusEffect;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_4081;
import net.minecraft.class_5131;
import org.jetbrains.annotations.NotNull;

public class FrenzyStatusEffect
extends class_1291 {
    public static final long REQUIRE_KILL_EVERY_X_TICKS = 200L;

    public FrenzyStatusEffect(class_4081 category, int color) {
        super(category, color);
    }

    public void method_52520(class_1309 entity, int amplifier) {
        if (!SpectrumStatusEffects.effectsAreGettingStacked && !entity.method_6059(SpectrumStatusEffects.FRENZY)) {
            super.method_52520(entity, amplifier);
        }
    }

    public void method_5562(class_5131 attributes) {
        if (!SpectrumStatusEffects.effectsAreGettingStacked) {
            super.method_5562(attributes);
        }
    }

    public boolean method_5552(int duration, int amplifier) {
        return true;
    }

    public boolean method_5572(class_1309 entity, int amplifier) {
        float potency;
        boolean scoredKillInTime;
        long lastKillTick = LastKillComponent.getLastKillTick(entity);
        long worldTime = entity.method_37908().method_8510();
        long lastKillTickDifference = worldTime - lastKillTick;
        boolean bl = scoredKillInTime = lastKillTick >= 0L && lastKillTickDifference < 200L;
        if (!scoredKillInTime && lastKillTickDifference % 200L == 0L) {
            this.updateAttributes(entity, amplifier, -1);
        }
        if ((potency = SleepStatusEffect.getSleepScaling(entity) * (float)(amplifier + 1) / 3.0f / 20.0f) > 0.0f && entity.method_6032() > potency) {
            entity.method_5643(SpectrumDamageTypes.sleep(entity.method_37908(), null), potency);
        }
        return true;
    }

    public void onKill(class_1309 livingEntity, int amplifier) {
        this.updateAttributes(livingEntity, amplifier, 1);
    }

    public void updateAttributes(@NotNull class_1309 entity, int amplifier, int increase) {
        class_5131 attributes = entity.method_6127();
        if (attributes != null) {
            this.method_55650(amplifier, (entry, modifier) -> {
                class_1324 entityInstance = attributes.method_45329(entry);
                if (entityInstance != null) {
                    class_1322 appliedModifier = entityInstance.method_6199(modifier.comp_2447());
                    double newBaseValue = appliedModifier == null ? modifier.comp_2449() : appliedModifier.comp_2449();
                    double newValue = this.adjustModifierAmount(newBaseValue, modifier.comp_2449(), amplifier, increase);
                    entityInstance.method_6202(modifier);
                    entityInstance.method_26837(new class_1322(modifier.comp_2447(), newValue, modifier.comp_2450()));
                    entityInstance.method_6194();
                }
            });
        }
    }

    public double adjustModifierAmount(double existingValue, double additionalValue, int amplifier, int increase) {
        if (increase > 0) {
            return existingValue + additionalValue * (double)(amplifier + increase);
        }
        return existingValue - additionalValue * (double)(amplifier - increase);
    }
}

