/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.features;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.worldgen.features.GilledFungusFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class GiantGilledFungusFeature
extends class_3031<GilledFungusFeatureConfig> {
    public GiantGilledFungusFeature(Codec<GilledFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<GilledFungusFeatureConfig> context) {
        int stemHeight;
        class_5281 world = context.method_33652();
        class_2338 blockPos = context.method_33655();
        GilledFungusFeatureConfig config = (GilledFungusFeatureConfig)context.method_33656();
        class_2248 validBaseBlock = config.validBase();
        class_2680 baseBlock = world.method_8320(blockPos.method_10074());
        if (!baseBlock.method_27852(validBaseBlock)) {
            return false;
        }
        class_5819 random = context.method_33654();
        class_2794 chunkGenerator = context.method_33653();
        int maxHeight = config.baseStemHeight().method_35008(random);
        class_2338.class_2339 mutable = blockPos.method_25503();
        int stemGirth = 1;
        for (stemHeight = 0; stemHeight < maxHeight && GiantGilledFungusFeature.isReplaceable((class_1936)world, (class_2338)mutable.method_10098(class_2350.field_11036), false); ++stemHeight) {
        }
        if ((float)stemHeight < (float)maxHeight / 1.667f) {
            return false;
        }
        stemGirth += (int)Math.floor((float)stemHeight / 33.0f);
        if (blockPos.method_10264() + stemHeight + 1 >= chunkGenerator.method_12104()) {
            return false;
        }
        world.method_8652(blockPos, class_2246.field_10124.method_9564(), 4);
        this.generateStemRing(blockPos.method_10087(3), config, (class_1936)world, random, stemGirth, stemHeight + 3, true);
        if (stemHeight > 60 || stemHeight > 30 && random.method_43056()) {
            this.generateHat((class_1936)world, random, config, blockPos, stemHeight, 1.0f);
            this.generateHat((class_1936)world, random, config, blockPos, Math.round((float)stemHeight * 0.65f), 0.7f);
        } else {
            this.generateHat((class_1936)world, random, config, blockPos, stemHeight, 1.0f);
        }
        int i = 0;
        while ((float)i < (float)stemHeight / 1.5f) {
            this.generateHat((class_1936)world, random, config, blockPos.method_10069(random.method_43048(stemGirth * 3), 0, random.method_43048(stemGirth * 3)), random.method_43048(stemHeight / 5) + 1, random.method_43057() / (float)(i + 1) * 0.5f + 0.5f);
            ++i;
        }
        return true;
    }

    private static boolean isReplaceable(class_1936 world, class_2338 pos, boolean replacePlants) {
        return world.method_16358(pos, state -> state.method_45474() || replacePlants);
    }

    private void generateStemRing(class_2338 blockPos, GilledFungusFeatureConfig config, class_1936 world, class_5819 random, int stemGirth, int stemHeight, boolean recursive) {
        class_2338.class_2339 stemPos = blockPos.method_25503();
        for (int x = -stemGirth; x <= stemGirth; ++x) {
            for (int z = -stemGirth; z <= stemGirth; ++z) {
                stemPos.method_25504((class_2382)blockPos, x, 0, z);
                if (Math.sqrt(stemPos.method_10262((class_2382)blockPos)) > (double)stemGirth) continue;
                this.generateStem(world, config, (class_2338)stemPos, stemHeight);
                if (!recursive || stemPos.equals((Object)blockPos) || !(random.method_43057() <= 0.2f)) continue;
                int height = Math.round((float)stemHeight * (random.method_43057() * 0.667f));
                int offsetX = (int)((float)x * (2.0f + random.method_43057()));
                int offsetZ = (int)((float)z * (2.0f + random.method_43057()));
                this.generateStemRing(stemPos.method_10069(offsetX, 0, offsetZ), config, world, random, stemGirth / 2, height, false);
                this.generateHat(world, random, config, stemPos.method_10069((int)((double)offsetX * 1.5), 0, (int)((double)offsetZ * 1.5)), height, 0.333f + random.method_43057() * 0.667f);
            }
        }
    }

    private void generateStem(class_1936 world, GilledFungusFeatureConfig config, class_2338 pos, int stemHeight) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680 blockState = config.stem().method_9564();
        int i = 0;
        for (int x = -i; x <= i; ++x) {
            for (int z = -i; z <= i; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    mutable.method_25504((class_2382)pos, x, y, z);
                    if (!GiantGilledFungusFeature.isReplaceable(world, (class_2338)mutable, true)) continue;
                    this.method_13153((class_1945)world, (class_2338)mutable, blockState);
                }
            }
        }
    }

    private void generateHat(class_1936 world, class_5819 random, GilledFungusFeatureConfig config, class_2338 pos, int stemHeight, float sizeMod) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int hatRadius = Math.round(Math.min((float)Math.round((float)random.method_43048(Math.round(1.0f + (float)stemHeight / 7.0f)) + (float)stemHeight / 7.0f + 3.0f) * sizeMod, 17.0f));
        class_2680 gillsState = config.gills().method_9564();
        class_2680 capState = config.cap().method_9564();
        int start = hatRadius > 11 ? -3 : -2;
        boolean firstLoop = true;
        for (int y = start; y < Math.max(Math.round((float)hatRadius / 3.0f), 2); ++y) {
            boolean isLowestLevel;
            boolean underHang = y < 0;
            boolean bl = isLowestLevel = y == 0;
            int currentRadius = underHang ? hatRadius : (int)Math.round((double)hatRadius / Math.pow(1.175, Math.max(y - 1, 0))) - (isLowestLevel ? 0 : 1);
            for (int x = -currentRadius; x <= currentRadius; ++x) {
                for (int z = -currentRadius; z <= currentRadius; ++z) {
                    boolean isCorner;
                    boolean bl2 = isCorner = Math.abs(x) == currentRadius && Math.abs(z) == currentRadius;
                    if (isCorner) continue;
                    mutable.method_25504((class_2382)pos, x, stemHeight + y, z);
                    if (!GiantGilledFungusFeature.isReplaceable(world, (class_2338)mutable, false)) continue;
                    double rad = Math.sqrt(mutable.method_10268((double)pos.method_10263(), (double)mutable.method_10264(), (double)pos.method_10260()));
                    if (underHang) {
                        if (random.method_43048(3) == 0 && firstLoop || !(rad <= (double)currentRadius) || !(rad > (double)(currentRadius - 1))) continue;
                        this.method_13153((class_1945)world, (class_2338)mutable, capState);
                        continue;
                    }
                    if (isLowestLevel) {
                        if (rad <= (double)((float)currentRadius / 1.5f) && rad >= (double)((float)currentRadius / 3.0f)) continue;
                        if (rad <= (double)(currentRadius - 1)) {
                            this.method_13153((class_1945)world, (class_2338)mutable, (class_2680)gillsState.method_11657((class_2769)class_2465.field_11459, (Comparable)(Math.abs(x) < Math.abs(z) ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051)));
                            continue;
                        }
                        if (!(rad <= (double)currentRadius)) continue;
                        this.method_13153((class_1945)world, (class_2338)mutable, capState);
                        continue;
                    }
                    if (!(rad <= (double)currentRadius)) continue;
                    this.method_13153((class_1945)world, (class_2338)mutable, capState);
                }
            }
            firstLoop = false;
        }
    }
}

