/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.features;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.worldgen.features.GilledFungusFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class GilledFungusFeature
extends class_3031<GilledFungusFeatureConfig> {
    public GilledFungusFeature(Codec<GilledFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<GilledFungusFeatureConfig> context) {
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        GilledFungusFeatureConfig hugeFungusFeatureConfig = (GilledFungusFeatureConfig)context.method_33656();
        class_2248 validBaseBlock = hugeFungusFeatureConfig.validBase();
        class_2680 baseBlock = structureWorldAccess.method_8320(blockPos.method_10074());
        if (!baseBlock.method_27852(validBaseBlock)) {
            return false;
        }
        class_5819 random = context.method_33654();
        class_2794 chunkGenerator = context.method_33653();
        int stemHeight = hugeFungusFeatureConfig.baseStemHeight().method_35008(random);
        if (random.method_43048(12) == 0) {
            stemHeight *= 2;
        }
        if (blockPos.method_10264() + stemHeight + 1 >= chunkGenerator.method_12104()) {
            return false;
        }
        structureWorldAccess.method_8652(blockPos, class_2246.field_10124.method_9564(), 4);
        this.generateStem((class_1936)structureWorldAccess, hugeFungusFeatureConfig, blockPos, stemHeight);
        this.generateHat((class_1936)structureWorldAccess, random, hugeFungusFeatureConfig, blockPos, stemHeight);
        return true;
    }

    private static boolean isReplaceable(class_1936 world, class_2338 pos, boolean replacePlants) {
        return world.method_16358(pos, state -> state.method_45474() || replacePlants);
    }

    private void generateStem(class_1936 world, GilledFungusFeatureConfig config, class_2338 pos, int stemHeight) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680 blockState = config.stem().method_9564();
        int i = 0;
        for (int x = -i; x <= i; ++x) {
            for (int z = -i; z <= i; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    mutable.method_25504((class_2382)pos, x, y, z);
                    if (!GilledFungusFeature.isReplaceable(world, (class_2338)mutable, true)) continue;
                    this.method_13153((class_1945)world, (class_2338)mutable, blockState);
                }
            }
        }
    }

    private void generateHat(class_1936 world, class_5819 random, GilledFungusFeatureConfig config, class_2338 pos, int stemHeight) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int hatRadius = Math.min(random.method_43048(1 + stemHeight / 5) + 4, 9);
        class_2680 gillsState = config.gills().method_9564();
        class_2680 capState = config.cap().method_9564();
        int start = hatRadius > 4 ? -2 : -1;
        boolean firstLoop = true;
        for (int y = start; y < Math.max(Math.round((float)hatRadius / 3.0f), 2); ++y) {
            boolean isLowestLevel;
            boolean underHang = y < 0;
            boolean bl = isLowestLevel = y == 0;
            int currentRadius = underHang ? hatRadius : (int)Math.round((double)hatRadius / Math.pow(1.175, Math.max(y - 1, 0))) - (isLowestLevel ? 0 : 1);
            for (int x = -currentRadius; x <= currentRadius; ++x) {
                for (int z = -currentRadius; z <= currentRadius; ++z) {
                    boolean isCorner;
                    boolean bl2 = isCorner = Math.abs(x) == currentRadius && Math.abs(z) == currentRadius;
                    if (isCorner) continue;
                    mutable.method_25504((class_2382)pos, x, stemHeight + y, z);
                    if (!GilledFungusFeature.isReplaceable(world, (class_2338)mutable, false)) continue;
                    double rad = Math.sqrt(mutable.method_10268((double)pos.method_10263(), (double)mutable.method_10264(), (double)pos.method_10260()));
                    if (underHang) {
                        if (random.method_43048(3) == 0 && firstLoop || !(rad <= (double)currentRadius) || !(rad > (double)(currentRadius - 1))) continue;
                        this.method_13153((class_1945)world, (class_2338)mutable, capState);
                        continue;
                    }
                    if (isLowestLevel) {
                        if (rad <= (double)(currentRadius - 1)) {
                            this.method_13153((class_1945)world, (class_2338)mutable, (class_2680)gillsState.method_11657((class_2769)class_2465.field_11459, (Comparable)(Math.abs(x) < Math.abs(z) ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051)));
                            continue;
                        }
                        if (!(rad <= (double)currentRadius)) continue;
                        this.method_13153((class_1945)world, (class_2338)mutable, capState);
                        continue;
                    }
                    if (!(rad <= (double)currentRadius)) continue;
                    this.method_13153((class_1945)world, (class_2338)mutable, capState);
                }
            }
            firstLoop = false;
        }
    }
}

