/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy;

import com.google.common.collect.Lists;
import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.status_effect.Incurable;
import de.dafuqs.spectrum.helpers.Support;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class InkPoweredStatusEffectInstance {
    public static final String NBT_KEY = "InkPoweredStatusEffects";
    public static final String UNIDENTIFIABLE_NBT_KEY = "Unidentifiable";
    public static final String INCURABLE_NBT_KEY = "Incurable";
    public static final String CUSTOM_COLOR_NBT_KEY = "CustomColor";
    private final class_1293 statusEffectInstance;
    private final InkCost cost;
    private final boolean unidentifiable;
    private final boolean incurable;
    private final int customColor;

    public InkPoweredStatusEffectInstance(class_1293 statusEffectInstance, InkCost cost, int customColor, boolean unidentifiable, boolean incurable) {
        this.statusEffectInstance = statusEffectInstance;
        this.cost = cost;
        this.customColor = customColor;
        this.unidentifiable = unidentifiable;
        this.incurable = incurable;
        if (incurable) {
            ((Incurable)statusEffectInstance).spectrum$setIncurable(true);
        }
    }

    public class_1293 getStatusEffectInstance() {
        return this.statusEffectInstance;
    }

    public InkCost getInkCost() {
        return this.cost;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        this.statusEffectInstance.method_5582(nbt);
        this.cost.writeNbt(nbt);
        if (this.customColor != -1) {
            nbt.method_10569(CUSTOM_COLOR_NBT_KEY, this.customColor);
        }
        if (this.unidentifiable) {
            nbt.method_10556(UNIDENTIFIABLE_NBT_KEY, true);
        }
        if (this.incurable) {
            nbt.method_10556(INCURABLE_NBT_KEY, true);
        }
        return nbt;
    }

    public static InkPoweredStatusEffectInstance fromNbt(class_2487 nbt) {
        class_1293 statusEffectInstance = class_1293.method_5583((class_2487)nbt);
        InkCost cost = InkCost.fromNbt(nbt);
        int customColor = -1;
        if (nbt.method_10573(CUSTOM_COLOR_NBT_KEY, 99)) {
            customColor = nbt.method_10550(CUSTOM_COLOR_NBT_KEY);
        }
        boolean unidentifiable = false;
        if (nbt.method_10545(UNIDENTIFIABLE_NBT_KEY)) {
            unidentifiable = nbt.method_10577(UNIDENTIFIABLE_NBT_KEY);
        }
        boolean incurable = false;
        if (nbt.method_10545(INCURABLE_NBT_KEY)) {
            incurable = nbt.method_10577(INCURABLE_NBT_KEY);
        }
        return new InkPoweredStatusEffectInstance(statusEffectInstance, cost, customColor, unidentifiable, incurable);
    }

    public static List<InkPoweredStatusEffectInstance> getEffects(class_1799 stack) {
        return InkPoweredStatusEffectInstance.getEffects(stack.method_7969());
    }

    public static List<InkPoweredStatusEffectInstance> getEffects(@Nullable class_2487 nbt) {
        ArrayList<InkPoweredStatusEffectInstance> list = new ArrayList<InkPoweredStatusEffectInstance>();
        if (nbt != null && nbt.method_10573(NBT_KEY, 9)) {
            class_2499 nbtList = nbt.method_10554(NBT_KEY, 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                InkPoweredStatusEffectInstance instance = InkPoweredStatusEffectInstance.fromNbt(nbtCompound);
                list.add(instance);
            }
        }
        return list;
    }

    public static void setEffects(class_1799 stack, Collection<InkPoweredStatusEffectInstance> effects) {
        if (!effects.isEmpty()) {
            class_2487 nbtCompound = stack.method_7948();
            class_2499 nbtList = nbtCompound.method_10554(NBT_KEY, 9);
            for (InkPoweredStatusEffectInstance effect : effects) {
                nbtList.add((Object)effect.toNbt());
            }
            nbtCompound.method_10566(NBT_KEY, (class_2520)nbtList);
        }
    }

    public static void buildTooltip(List<class_2561> tooltip, List<InkPoweredStatusEffectInstance> effects, class_5250 attributeModifierText, boolean showDuration) {
        if (!effects.isEmpty()) {
            ArrayList attributeModifiers = Lists.newArrayList();
            for (InkPoweredStatusEffectInstance entry : effects) {
                if (entry.isUnidentifiable()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.potion.tooltip.unidentifiable"));
                    continue;
                }
                class_1293 effect = entry.getStatusEffectInstance();
                if (effect == null) continue;
                InkCost cost = entry.getInkCost();
                if (effect == null) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.potion.tooltip.invalid"));
                    continue;
                }
                class_5250 mutableText = class_2561.method_43471((String)effect.method_5586());
                if (effect.method_5578() > 0) {
                    mutableText = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + effect.method_5578()))});
                }
                if (showDuration && effect.method_5584() > 20) {
                    mutableText = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableText, class_1292.method_5577((class_1293)effect, (float)1.0f)});
                }
                mutableText.method_27692(effect.method_5579().method_18792().method_18793());
                mutableText.method_10852((class_2561)class_2561.method_43469((String)"spectrum.tooltip.ink_cost", (Object[])new Object[]{Support.getShortenedNumberString(cost.getCost()), cost.getColor().getColoredInkName()}).method_27692(class_124.field_1080));
                if (entry.isIncurable()) {
                    mutableText.method_10852((class_2561)class_2561.method_43471((String)"item.spectrum.potion.tooltip.incurable"));
                }
                tooltip.add((class_2561)mutableText);
                Map map = effect.method_5579().method_5565();
                for (Map.Entry entityAttributeEntityAttributeModifierEntry : map.entrySet()) {
                    class_1322 entityAttributeModifier = (class_1322)entityAttributeEntityAttributeModifierEntry.getValue();
                    class_1322 entityAttributeModifier2 = new class_1322(entityAttributeModifier.method_6185(), effect.method_5579().method_5563(effect.method_5578(), entityAttributeModifier), entityAttributeModifier.method_6182());
                    attributeModifiers.add(new class_3545((Object)((class_1320)entityAttributeEntityAttributeModifierEntry.getKey()), (Object)entityAttributeModifier2));
                }
            }
            if (!attributeModifiers.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)attributeModifierText.method_27692(class_124.field_1064));
                for (class_3545 entityAttributeEntityAttributeModifierPair : attributeModifiers) {
                    class_1322 mutableText = (class_1322)entityAttributeEntityAttributeModifierPair.method_15441();
                    double statusEffect = mutableText.method_6186();
                    double d = mutableText.method_6182() != class_1322.class_1323.field_6330 && mutableText.method_6182() != class_1322.class_1323.field_6331 ? mutableText.method_6186() : mutableText.method_6186() * 100.0;
                    if (statusEffect > 0.0) {
                        tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + mutableText.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d), class_2561.method_43471((String)((class_1320)entityAttributeEntityAttributeModifierPair.method_15442()).method_26830())}).method_27692(class_124.field_1078));
                        continue;
                    }
                    if (!(statusEffect < 0.0)) continue;
                    tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + mutableText.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d *= -1.0), class_2561.method_43471((String)((class_1320)entityAttributeEntityAttributeModifierPair.method_15442()).method_26830())}).method_27692(class_124.field_1061));
                }
            }
        }
    }

    public int getColor() {
        if (this.customColor == -1) {
            return this.statusEffectInstance.method_5579().method_5556();
        }
        return this.customColor;
    }

    public boolean isUnidentifiable() {
        return this.unidentifiable;
    }

    public boolean isIncurable() {
        return this.incurable;
    }
}

