/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.energy.color;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.registries.SpectrumRegistries;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import org.joml.Vector3f;

public class InkColor {
    protected static final Map<class_1767, InkColor> DYE_TO_COLOR = new HashMap<class_1767, InkColor>();
    protected final class_1767 dyeColor;
    protected final int colorInt;
    protected final Vector3f colorVec;
    protected final int textColor;
    protected final Vector3f textColorVec;
    protected final class_2960 requiredAdvancement;

    protected InkColor(class_1767 dyeColor, int color, class_2960 requiredAdvancement) {
        this(dyeColor, color, color, requiredAdvancement);
    }

    protected InkColor(class_1767 dyeColor, int color, int textColor, class_2960 requiredAdvancement) {
        this.dyeColor = dyeColor;
        this.colorInt = color;
        this.colorVec = ColorHelper.colorIntToVec(color);
        this.textColor = textColor;
        this.textColorVec = ColorHelper.colorIntToVec(textColor);
        this.requiredAdvancement = requiredAdvancement;
        DYE_TO_COLOR.put(dyeColor, this);
    }

    public static InkColor ofDyeColor(class_1767 dyeColor) {
        return DYE_TO_COLOR.get(dyeColor);
    }

    public static Optional<InkColor> ofId(class_2960 id) {
        return SpectrumRegistries.INK_COLORS.method_17966(id);
    }

    public static Optional<InkColor> ofIdString(String idString) {
        try {
            class_2960 id = new class_2960(idString);
            return SpectrumRegistries.INK_COLORS.method_17966(id).or(() -> SpectrumRegistries.INK_COLORS.method_17966(SpectrumCommon.locate(idString)));
        }
        catch (class_151 ignored) {
            return Optional.empty();
        }
    }

    public class_1767 getDyeColor() {
        return this.dyeColor;
    }

    public String toString() {
        return this.getID().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InkColor that = (InkColor)o;
        return this.dyeColor.equals((Object)that.dyeColor);
    }

    public int hashCode() {
        return this.dyeColor.method_7789();
    }

    public class_5250 getName() {
        return class_2561.method_43471((String)this.getID().method_48747("ink", "name"));
    }

    public class_5250 getColoredName() {
        return this.getName().method_10862(class_2583.field_24360.method_36139(this.textColor));
    }

    public class_5250 getColoredInkName() {
        return class_2561.method_43469((String)"ink.suffix", (Object[])new Object[]{this.getName()}).method_10862(class_2583.field_24360.method_36139(this.textColor));
    }

    public Vector3f getColorVec() {
        return this.colorVec;
    }

    public int getColorInt() {
        return this.colorInt;
    }

    public int getTextColorInt() {
        return this.textColor;
    }

    public Vector3f getTextColorVec() {
        return this.textColorVec;
    }

    public class_2960 getRequiredAdvancement() {
        return this.requiredAdvancement;
    }

    public class_2960 getID() {
        return SpectrumRegistries.INK_COLORS.method_10221((Object)this);
    }

    public boolean isIn(class_6862<InkColor> tag) {
        return SpectrumRegistries.INK_COLORS.method_47983((Object)this).method_40220(tag);
    }
}

