/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import org.jetbrains.annotations.Nullable;

public interface PackEntity<T extends class_1308> {
    public boolean hasOthersInGroup();

    @Nullable
    public T getLeader();

    public boolean isCloseEnoughToLeader();

    public void leaveGroup();

    public void moveTowardLeader();

    public int getMaxGroupSize();

    public int getGroupSize();

    public void joinGroupOf(T var1);

    default public boolean hasLeader() {
        T leader = this.getLeader();
        return leader != null && leader.method_5805();
    }

    default public boolean isDifferentPack(PackEntity<T> other) {
        T thisLeader = this.getLeader();
        if (thisLeader == null) {
            return false;
        }
        T otherLeader = other.getLeader();
        if (otherLeader == null) {
            return false;
        }
        return !Objects.equals(this.getLeader(), other.getLeader());
    }

    default public boolean canHaveMoreInGroup() {
        return this.hasOthersInGroup() && this.getGroupSize() < this.getMaxGroupSize();
    }

    public static class FollowClanLeaderGoal<E extends class_1308>
    extends class_1352 {
        private static final int MIN_SEARCH_DELAY = 200;
        private final E entity;
        private int moveDelay;
        private int checkSurroundingDelay;

        public FollowClanLeaderGoal(E entity) {
            this.entity = entity;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(entity);
        }

        protected int getSurroundingSearchDelay(E fish) {
            return FollowClanLeaderGoal.method_38848((int)(200 + fish.method_6051().method_43048(200) % 20));
        }

        public boolean method_6264() {
            if (((PackEntity)this.entity).hasOthersInGroup()) {
                return false;
            }
            if (((PackEntity)this.entity).hasLeader()) {
                return true;
            }
            if (this.checkSurroundingDelay > 0) {
                --this.checkSurroundingDelay;
                return false;
            }
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.entity);
            this.createNewPack();
            return ((PackEntity)this.entity).hasLeader();
        }

        private void createNewPack() {
            List possiblePackmates = this.entity.method_37908().method_8390(this.entity.getClass(), this.entity.method_5829().method_1009(8.0, 8.0, 8.0), livingEntity -> {
                PackEntity packEntity;
                return livingEntity instanceof PackEntity && ((packEntity = (PackEntity)livingEntity).canHaveMoreInGroup() || !packEntity.hasLeader());
            });
            Optional<class_1308> newLeader = possiblePackmates.stream().filter(rec$ -> ((PackEntity)rec$).canHaveMoreInGroup()).findAny();
            if (newLeader.isEmpty()) {
                newLeader = possiblePackmates.stream().filter(e -> !((PackEntity)e).hasLeader()).findAny();
            }
            if (newLeader.isPresent()) {
                class_1308 leader = newLeader.get();
                possiblePackmates.stream().filter(e -> e != leader).filter(e -> !((PackEntity)e).hasLeader()).limit(((PackEntity)leader).getMaxGroupSize() - ((PackEntity)leader).getGroupSize()).forEach(e -> ((PackEntity)e).joinGroupOf(leader));
            }
        }

        public boolean method_6266() {
            return ((PackEntity)this.entity).hasLeader() && ((PackEntity)this.entity).isCloseEnoughToLeader();
        }

        public void method_6269() {
            this.moveDelay = 0;
        }

        public void method_6270() {
            ((PackEntity)this.entity).leaveGroup();
        }

        public void method_6268() {
            if (--this.moveDelay <= 0) {
                this.moveDelay = this.method_38847(10);
                ((PackEntity)this.entity).moveTowardLeader();
            }
        }
    }
}

