/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.api.item;

import de.dafuqs.spectrum.api.energy.InkCost;
import de.dafuqs.spectrum.api.energy.InkPoweredStatusEffectInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public interface InkPoweredPotionFillable {
    public int maxEffectCount();

    public int maxEffectAmplifier();

    default public long adjustFinalCostFor(@NotNull InkPoweredStatusEffectInstance instance) {
        return (long)Math.pow(instance.getInkCost().getCost(), 1 + instance.getStatusEffectInstance().method_5578());
    }

    default public void addOrUpgradeEffects(class_1799 potionFillableStack, List<InkPoweredStatusEffectInstance> newEffects) {
        if (!this.isFull(potionFillableStack)) {
            List<InkPoweredStatusEffectInstance> existingEffects = InkPoweredStatusEffectInstance.getEffects(potionFillableStack);
            int maxCount = this.maxEffectCount();
            int maxAmplifier = this.maxEffectAmplifier();
            for (InkPoweredStatusEffectInstance newEffect : newEffects) {
                class_1293 statusEffectInstance = newEffect.getStatusEffectInstance();
                if (statusEffectInstance.method_5578() > maxAmplifier) {
                    statusEffectInstance = new class_1293(statusEffectInstance.method_5579(), statusEffectInstance.method_5584(), maxAmplifier, statusEffectInstance.method_5591(), statusEffectInstance.method_5581());
                }
                if (existingEffects.size() == maxCount) break;
                InkCost adjustedCost = new InkCost(newEffect.getInkCost().getColor(), this.adjustFinalCostFor(newEffect));
                InkPoweredStatusEffectInstance modifiedInstance = new InkPoweredStatusEffectInstance(statusEffectInstance, adjustedCost, newEffect.getColor(), newEffect.isUnidentifiable(), newEffect.isIncurable());
                existingEffects.add(modifiedInstance);
            }
            InkPoweredStatusEffectInstance.setEffects(potionFillableStack, existingEffects);
        }
    }

    public static List<InkPoweredStatusEffectInstance> getEffects(class_1799 stack) {
        return InkPoweredStatusEffectInstance.getEffects(stack);
    }

    @Deprecated
    default public List<class_1293> getVanillaEffects(class_1799 stack) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        for (InkPoweredStatusEffectInstance instance : InkPoweredStatusEffectInstance.getEffects(stack)) {
            effects.add(instance.getStatusEffectInstance());
        }
        return effects;
    }

    default public boolean isFull(class_1799 itemStack) {
        return InkPoweredStatusEffectInstance.getEffects(itemStack).size() >= this.maxEffectCount();
    }

    default public boolean isAtLeastPartiallyFilled(class_1799 itemStack) {
        return InkPoweredStatusEffectInstance.getEffects(itemStack).size() > 0;
    }

    default public void clearEffects(class_1799 itemStack) {
        itemStack.method_7983("InkPoweredStatusEffects");
    }

    default public void appendPotionFillableTooltip(class_1799 stack, List<class_2561> tooltip, class_5250 attributeModifierText, boolean showDuration) {
        List<InkPoweredStatusEffectInstance> effects = InkPoweredStatusEffectInstance.getEffects(stack);
        InkPoweredStatusEffectInstance.buildTooltip(tooltip, effects, attributeModifierText, showDuration);
        int maxEffectCount = this.maxEffectCount();
        if (effects.size() < maxEffectCount) {
            if (maxEffectCount == 1) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.potion_pendant.tooltip_not_full_one"));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.potion_pendant.tooltip_not_full_count", (Object[])new Object[]{maxEffectCount}));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.potion_pendant.tooltip_max_level").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (this.maxEffectAmplifier() + 1)))));
        }
    }

    default public boolean isWeapon() {
        return false;
    }
}

