/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.fusion_shrine;

import de.dafuqs.spectrum.api.block.MultiblockCrafter;
import de.dafuqs.spectrum.api.block.PlayerOwned;
import de.dafuqs.spectrum.api.color.ColorRegistry;
import de.dafuqs.spectrum.api.recipe.FusionShrineRecipeWorldEffect;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlock;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumEventListeners;
import de.dafuqs.spectrum.registries.SpectrumRecipeTypes;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineBlockEntity
extends InWorldInteractionBlockEntity
implements PlayerOwned,
Upgradeable {
    protected static final int INVENTORY_SIZE = 7;
    private UUID ownerUUID;
    private Upgradeable.UpgradeHolder upgrades;
    private FusionShrineRecipe currentRecipe;
    private int craftingTime;
    private int craftingTimeTotal;
    private boolean inventoryChanged = true;
    public final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            FusionShrineBlockEntity.this.setLightForFluid(FusionShrineBlockEntity.this.field_11863, FusionShrineBlockEntity.this.field_11867, ((FluidVariant)this.variant).getFluid());
            FusionShrineBlockEntity.this.inventoryChanged();
            FusionShrineBlockEntity.this.method_5431();
        }
    };

    public FusionShrineBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.FUSION_SHRINE, pos, state, 7);
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        Optional<class_1767> optionalItemColor;
        int randomSlot;
        class_1799 randomStack;
        if (!fusionShrineBlockEntity.method_5442() && !(randomStack = fusionShrineBlockEntity.method_5438(randomSlot = world.method_8409().method_43048(fusionShrineBlockEntity.method_5439()))).method_7960() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(randomStack.method_7909())).isPresent()) {
            class_2400 particleEffect = SpectrumParticleTypes.getCraftingParticle(optionalItemColor.get());
            int particleAmount = (int)StrictMath.ceil((float)randomStack.method_7947() / 8.0f);
            for (int i = 0; i < particleAmount; ++i) {
                float randomX = 3.0f - world.method_8409().method_43057() * 7.0f;
                float randomZ = 3.0f - world.method_8409().method_43057() * 7.0f;
                world.method_8406((class_2394)particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264(), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.0, 0.0);
            }
        }
    }

    public void spawnCraftingParticles() {
        class_3611 fluid;
        Optional<class_1767> optionalFluidColor;
        class_2338 blockPos = this.method_11016();
        FusionShrineRecipe recipe = this.currentRecipe;
        if (recipe != null && this.field_11863 != null && (optionalFluidColor = ColorRegistry.FLUID_COLORS.getMapping(fluid = this.getFluidVariant().getFluid())).isPresent()) {
            class_2394 particleEffect = SpectrumParticleTypes.getFluidRisingParticle(optionalFluidColor.get());
            float randomX = 0.1f + this.field_11863.method_8409().method_43057() * 0.8f;
            float randomZ = 0.1f + this.field_11863.method_8409().method_43057() * 0.8f;
            this.field_11863.method_8406(particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)(blockPos.method_10264() + 1), (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.1, 0.0);
        }
    }

    public void scatterContents(@NotNull class_1937 world) {
        SpectrumS2CPacketSender.playParticleWithExactVelocity((class_3218)world, class_243.method_24953((class_2382)this.method_11016()), (class_2394)SpectrumParticleTypes.RED_CRAFTING, 1, new class_243(0.0, -0.5, 0.0));
        world.method_8396(null, this.method_11016(), SpectrumSoundEvents.CRAFTING_ABORTED, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.9f + world.field_9229.method_43057() * 0.2f);
        world.method_8396(null, this.method_11016(), class_3417.field_15197, class_3419.field_15245, 0.9f + world.field_9229.method_43057() * 0.2f, 0.5f + world.field_9229.method_43057() * 0.2f);
        FusionShrineBlock.scatterContents(world, this.method_11016());
        this.inventoryChanged();
    }

    public static void serverTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, FusionShrineBlockEntity fusionShrineBlockEntity) {
        FusionShrineRecipeWorldEffect effect;
        FusionShrineRecipe recipe;
        if (fusionShrineBlockEntity.upgrades == null) {
            fusionShrineBlockEntity.calculateUpgrades();
        }
        if (fusionShrineBlockEntity.inventoryChanged) {
            FusionShrineRecipe previousRecipe = fusionShrineBlockEntity.currentRecipe;
            fusionShrineBlockEntity.currentRecipe = FusionShrineBlockEntity.calculateRecipe(world, fusionShrineBlockEntity);
            if (fusionShrineBlockEntity.currentRecipe != previousRecipe) {
                fusionShrineBlockEntity.craftingTime = 0;
                if (fusionShrineBlockEntity.currentRecipe == null) {
                    SpectrumS2CPacketSender.sendCancelBlockBoundSoundInstance((class_3218)world, fusionShrineBlockEntity.field_11867);
                } else {
                    fusionShrineBlockEntity.craftingTimeTotal = (int)Math.ceil((float)fusionShrineBlockEntity.currentRecipe.getCraftingTime() / fusionShrineBlockEntity.upgrades.getEffectiveValue(Upgradeable.UpgradeType.SPEED));
                }
                fusionShrineBlockEntity.updateInClientWorld();
            }
            fusionShrineBlockEntity.inventoryChanged = false;
        }
        if ((recipe = fusionShrineBlockEntity.currentRecipe) == null) {
            return;
        }
        if (fusionShrineBlockEntity.craftingTime % 60 == 0) {
            boolean structureCompleteWithSky;
            class_1657 lastInteractedPlayer = fusionShrineBlockEntity.getOwnerIfOnline();
            boolean recipeConditionsMet = recipe.canPlayerCraft(lastInteractedPlayer) && recipe.areConditionMetCurrently((class_3218)world, blockPos);
            boolean structureComplete = FusionShrineBlock.verifyStructure(world, blockPos, null);
            boolean bl = structureCompleteWithSky = FusionShrineBlock.verifySkyAccess((class_3218)world, blockPos) && structureComplete;
            if (!recipeConditionsMet || !structureCompleteWithSky) {
                if (!structureCompleteWithSky) {
                    fusionShrineBlockEntity.scatterContents(world);
                }
                fusionShrineBlockEntity.craftingTime = 0;
                return;
            }
        }
        ++fusionShrineBlockEntity.craftingTime;
        if (fusionShrineBlockEntity.craftingTime == 1 && fusionShrineBlockEntity.craftingTimeTotal > 1) {
            SpectrumS2CPacketSender.sendPlayBlockBoundSoundInstance(SpectrumSoundEvents.FUSION_SHRINE_CRAFTING, (class_3218)world, fusionShrineBlockEntity.method_11016(), fusionShrineBlockEntity.craftingTimeTotal - fusionShrineBlockEntity.craftingTime);
        }
        if ((effect = recipe.getWorldEffectForTick(fusionShrineBlockEntity.craftingTime, fusionShrineBlockEntity.craftingTimeTotal)) != null) {
            effect.trigger((class_3218)world, blockPos);
        }
        if (fusionShrineBlockEntity.craftingTime == fusionShrineBlockEntity.craftingTimeTotal) {
            FusionShrineBlockEntity.craft(world, blockPos, fusionShrineBlockEntity, recipe);
            fusionShrineBlockEntity.inventoryChanged();
        } else {
            SpectrumS2CPacketSender.sendPlayFusionCraftingInProgressParticles(world, blockPos);
        }
        fusionShrineBlockEntity.method_5431();
    }

    @Nullable
    private static FusionShrineRecipe calculateRecipe(@NotNull class_1937 world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        if (fusionShrineBlockEntity.currentRecipe != null && fusionShrineBlockEntity.currentRecipe.matches(fusionShrineBlockEntity, world)) {
            return fusionShrineBlockEntity.currentRecipe;
        }
        return world.method_8433().method_8132(SpectrumRecipeTypes.FUSION_SHRINE, (class_1263)fusionShrineBlockEntity, world).orElse(null);
    }

    private static void craft(class_1937 world, class_2338 blockPos, FusionShrineBlockEntity fusionShrineBlockEntity, FusionShrineRecipe recipe) {
        recipe.craft(world, fusionShrineBlockEntity);
        if (recipe.shouldPlayCraftingFinishedEffects()) {
            SpectrumS2CPacketSender.sendPlayFusionCraftingFinishedParticles(world, blockPos, recipe.craft(fusionShrineBlockEntity, world.method_30349()));
            fusionShrineBlockEntity.playSound(SpectrumSoundEvents.FUSION_SHRINE_CRAFTING_FINISHED, 1.4f);
        }
        FusionShrineBlockEntity.scatterContents(world, blockPos.method_10084(), fusionShrineBlockEntity);
        fusionShrineBlockEntity.fluidStorage.variant = FluidVariant.blank();
        fusionShrineBlockEntity.fluidStorage.amount = 0L;
        world.method_8652(blockPos, (class_2680)world.method_8320(blockPos).method_11657((class_2769)FusionShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    public static void scatterContents(class_1937 world, class_2338 pos, FusionShrineBlockEntity blockEntity) {
        class_1264.method_17349((class_1937)world, (class_2338)pos, blockEntity.getItems());
        world.method_8455(pos, world.method_8320(pos).method_26204());
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fluidStorage.variant = FluidVariant.fromNbt((class_2487)nbt.method_10562("FluidVariant"));
        this.fluidStorage.amount = nbt.method_10537("FluidAmount");
        this.craftingTime = nbt.method_10568("CraftingTime");
        this.craftingTimeTotal = nbt.method_10568("CraftingTimeTotal");
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentRecipe = null;
        this.currentRecipe = MultiblockCrafter.getRecipeFromNbt(this.field_11863, nbt, FusionShrineRecipe.class);
        this.upgrades = nbt.method_10573("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.method_10554("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("FluidVariant", (class_2520)((FluidVariant)this.fluidStorage.variant).toNbt());
        nbt.method_10544("FluidAmount", this.fluidStorage.amount);
        nbt.method_10575("CraftingTime", (short)this.craftingTime);
        nbt.method_10575("CraftingTimeTotal", (short)this.craftingTimeTotal);
        if (this.upgrades != null) {
            nbt.method_10566("Upgrades", (class_2520)this.upgrades.toNbt());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.method_10582("CurrentRecipe", this.currentRecipe.method_8114().toString());
        }
    }

    public void playSound(class_3414 soundEvent, float volume) {
        if (this.field_11863 != null) {
            class_5819 random = this.field_11863.field_9229;
            this.field_11863.method_43128(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), soundEvent, class_3419.field_15245, volume, 0.9f + random.method_43057() * 0.15f);
        }
    }

    public void grantPlayerFusionCraftingAdvancement(class_1799 stack, int experience) {
        class_3222 serverPlayerEntity = (class_3222)this.getOwnerIfOnline();
        if (serverPlayerEntity != null) {
            SpectrumAdvancementCriteria.FUSION_SHRINE_CRAFTING.trigger(serverPlayerEntity, stack, experience);
        }
    }

    @NotNull
    public FluidVariant getFluidVariant() {
        if (this.fluidStorage.amount > 0L) {
            return (FluidVariant)this.fluidStorage.variant;
        }
        return FluidVariant.blank();
    }

    @NotNull
    public SingleVariantStorage<FluidVariant> getFluidStorage() {
        return this.fluidStorage;
    }

    private void setLightForFluid(class_1937 world, class_2338 blockPos, class_3611 fluid) {
        int fluidLight = SpectrumEventListeners.getFluidLuminance(fluid);
        world.method_8652(blockPos, (class_2680)world.method_8320(blockPos).method_11657((class_2769)FusionShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(fluidLight)), 3);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(class_1657 playerEntity) {
        this.ownerUUID = playerEntity.method_5667();
        this.method_5431();
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.method_5431();
    }

    @Override
    public void calculateUpgrades() {
        this.upgrades = Upgradeable.calculateUpgradeMods4(this.field_11863, this.field_11867, 2, 0, this.ownerUUID);
        this.method_5431();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.inventoryChanged = true;
        this.craftingTime = 0;
    }
}

