/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.item_bowl;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.color.ColorRegistry;
import de.dafuqs.spectrum.blocks.InWorldInteractionBlockEntity;
import de.dafuqs.spectrum.events.ExactPositionSource;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.effect.ColoredTransmission;
import de.dafuqs.spectrum.particle.effect.ColoredTransmissionParticleEffect;
import de.dafuqs.spectrum.registries.SpectrumBlockEntities;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5716;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class ItemBowlBlockEntity
extends InWorldInteractionBlockEntity {
    protected static final int INVENTORY_SIZE = 1;

    public ItemBowlBlockEntity(class_2338 pos, class_2680 state) {
        super(SpectrumBlockEntities.ITEM_BOWL, pos, state, 1);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (!this.deserializeLootTable(nbt)) {
            class_1262.method_5429((class_2487)nbt, (class_2371)this.items);
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.serializeLootTable(nbt)) {
            class_1262.method_5426((class_2487)nbt, (class_2371)this.items);
        }
    }

    @Override
    public class_2487 method_16887() {
        this.checkLootInteraction(null);
        return super.method_16887();
    }

    public static void clientTick(@NotNull class_1937 world, class_2338 blockPos, class_2680 blockState, ItemBowlBlockEntity itemBowlBlockEntity) {
        Optional<class_1767> optionalItemColor;
        class_1799 storedStack = itemBowlBlockEntity.method_5438(0);
        if (!storedStack.method_7960() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(storedStack.method_7909())).isPresent()) {
            int particleCount = Support.getIntFromDecimalWithChance(Math.max(0.1, (double)((float)storedStack.method_7947() / (float)(storedStack.method_7914() * 2))), world.field_9229);
            ItemBowlBlockEntity.spawnRisingParticles(world, blockPos, storedStack, particleCount);
        }
    }

    public static void spawnRisingParticles(class_1937 world, class_2338 blockPos, class_1799 itemStack, int amount) {
        Optional<class_1767> optionalItemColor;
        if (amount > 0 && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(itemStack.method_7909())).isPresent()) {
            class_2394 particleEffect = SpectrumParticleTypes.getSparkleRisingParticle(optionalItemColor.get());
            for (int i = 0; i < amount; ++i) {
                float randomX = 0.1f + world.field_9229.method_43057() * 0.8f;
                float randomZ = 0.1f + world.field_9229.method_43057() * 0.8f;
                world.method_8406(particleEffect, (double)((float)blockPos.method_10263() + randomX), (double)blockPos.method_10264() + 0.75, (double)((float)blockPos.method_10260() + randomZ), 0.0, 0.05, 0.0);
            }
        }
    }

    public int decrementBowlStack(class_243 orbTargetPos, int amount, boolean doEffects) {
        class_1799 storedStack = this.method_5438(0);
        if (storedStack.method_7960()) {
            return 0;
        }
        int decrementAmount = Math.min(amount, storedStack.method_7947());
        class_1799 remainder = storedStack.getRecipeRemainder();
        if (!remainder.method_7960()) {
            if (storedStack.method_7947() == 1) {
                this.method_5447(0, remainder);
            } else {
                this.method_5438(0).method_7934(decrementAmount);
                remainder.method_7939(decrementAmount);
                class_1542 itemEntity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5, remainder);
                itemEntity.method_5762(0.0, 0.1, 0.0);
                this.field_11863.method_8649((class_1297)itemEntity);
            }
        } else {
            this.method_5438(0).method_7934(decrementAmount);
        }
        if (decrementAmount > 0) {
            if (doEffects) {
                this.spawnOrbParticles(orbTargetPos);
            }
            this.updateInClientWorld();
            this.method_5431();
        }
        return decrementAmount;
    }

    public void spawnOrbParticles(class_243 orbTargetPos) {
        Optional<class_1767> optionalItemColor;
        class_1799 storedStack = this.method_5438(0);
        if (!storedStack.method_7960() && (optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(storedStack.method_7909(), class_1767.field_7945)).isPresent()) {
            class_2394 sparkleRisingParticleEffect = SpectrumParticleTypes.getSparkleRisingParticle(optionalItemColor.get());
            class_1937 class_19372 = this.method_10997();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)this.field_11863, new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5), sparkleRisingParticleEffect, 50, new class_243(0.4, 0.2, 0.4), new class_243(0.06, 0.16, 0.06));
                SpectrumS2CPacketSender.playColorTransmissionParticle(serverWorld, new ColoredTransmission(new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5), new ExactPositionSource(orbTargetPos), 20, optionalItemColor.get()));
            } else {
                class_19372 = this.method_10997();
                if (class_19372 instanceof class_638) {
                    class_638 clientWorld = (class_638)class_19372;
                    for (int i = 0; i < 50; ++i) {
                        float randomOffsetX = (float)this.field_11867.method_10263() + 0.3f + this.field_11863.field_9229.method_43057() * 0.6f;
                        float randomOffsetY = (float)this.field_11867.method_10264() + 0.3f + this.field_11863.field_9229.method_43057() * 0.6f;
                        float randomOffsetZ = (float)this.field_11867.method_10260() + 0.3f + this.field_11863.field_9229.method_43057() * 0.6f;
                        float randomVelocityX = 0.03f - this.field_11863.field_9229.method_43057() * 0.06f;
                        float randomVelocityY = this.field_11863.field_9229.method_43057() * 0.16f;
                        float randomVelocityZ = 0.03f - this.field_11863.field_9229.method_43057() * 0.06f;
                        clientWorld.method_8406(sparkleRisingParticleEffect, (double)randomOffsetX, (double)randomOffsetY, (double)randomOffsetZ, (double)randomVelocityX, (double)randomVelocityY, (double)randomVelocityZ);
                    }
                    ColoredTransmissionParticleEffect sphereParticleEffect = new ColoredTransmissionParticleEffect((class_5716)new ExactPositionSource(orbTargetPos), (Integer)20, optionalItemColor.get());
                    clientWorld.method_8406((class_2394)sphereParticleEffect, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5, (orbTargetPos.method_10216() - (double)this.field_11867.method_10263()) * 0.045, 0.0, (orbTargetPos.method_10215() - (double)this.field_11867.method_10260()) * 0.045);
                }
            }
            this.field_11863.method_8396(null, this.field_11867, SpectrumSoundEvents.CRAFTING_DING, class_3419.field_15245, SpectrumCommon.CONFIG.BlockSoundVolume, 0.7f + this.field_11863.field_9229.method_43057() * 0.6f);
        }
    }
}

