/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.mob_head;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumSkullBlockEntity;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumSkullBlockItem;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumSkullType;
import de.dafuqs.spectrum.blocks.mob_head.SpectrumWallSkullBlock;
import de.dafuqs.spectrum.helpers.Support;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2484;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_2715;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpectrumSkullBlock
extends class_2484 {
    public static BiMap<SpectrumSkullType, class_2248> MOB_HEADS = EnumHashBiMap.create(SpectrumSkullType.class);
    private static Map<class_1299<?>, SpectrumSkullType> ENTITY_TYPE_TO_SKULL_TYPE = new Object2ObjectOpenHashMap();
    @Nullable
    private static class_2700 witherBossPattern;

    public SpectrumSkullBlock(SpectrumSkullType skullType, class_4970.class_2251 settings) {
        super((class_2484.class_2485)skullType, settings);
        MOB_HEADS.put((Object)skullType, (Object)this);
        ENTITY_TYPE_TO_SKULL_TYPE.put(skullType.getEntityType(), skullType);
    }

    public SpectrumSkullType getSkullType() {
        return (SpectrumSkullType)super.method_9327();
    }

    public static Optional<class_1299<?>> getEntityTypeOfSkullStack(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof SpectrumSkullBlockItem) {
            SpectrumSkullBlockItem spectrumSkullBlockItem = (SpectrumSkullBlockItem)item;
            return Optional.of(spectrumSkullBlockItem.type.getEntityType());
        }
        if (class_1802.field_8681 == item) {
            return Optional.of(class_1299.field_6046);
        }
        if (class_1802.field_8712 == item) {
            return Optional.of(class_1299.field_6116);
        }
        if (class_1802.field_8470 == item) {
            return Optional.of(class_1299.field_6051);
        }
        if (class_1802.field_8398 == item) {
            return Optional.of(class_1299.field_6137);
        }
        if (class_1802.field_8791 == item) {
            return Optional.of(class_1299.field_6076);
        }
        if (class_1802.field_41304 == item) {
            return Optional.of(class_1299.field_22281);
        }
        return Optional.empty();
    }

    public static Optional<class_2484.class_2485> getSkullType(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof SpectrumSkullBlockItem) {
            SpectrumSkullBlockItem spectrumSkullBlockItem = (SpectrumSkullBlockItem)item;
            return Optional.of(spectrumSkullBlockItem.type);
        }
        if (class_1802.field_8681 == item) {
            return Optional.of(class_2484.class_2486.field_11507);
        }
        if (class_1802.field_8712 == item) {
            return Optional.of(class_2484.class_2486.field_11511);
        }
        if (class_1802.field_8470 == item) {
            return Optional.of(class_2484.class_2486.field_11508);
        }
        if (class_1802.field_8398 == item) {
            return Optional.of(class_2484.class_2486.field_11512);
        }
        if (class_1802.field_8791 == item) {
            return Optional.of(class_2484.class_2486.field_11513);
        }
        if (class_1802.field_41304 == item) {
            return Optional.of(class_2484.class_2486.field_41313);
        }
        return Optional.empty();
    }

    public static Optional<class_2248> getBlock(class_2484.class_2485 skullType) {
        if (skullType instanceof SpectrumSkullType) {
            SpectrumSkullType spectrumSkullType = (SpectrumSkullType)skullType;
            return Optional.of((class_2248)MOB_HEADS.get((Object)spectrumSkullType));
        }
        if (class_2484.class_2486.field_11507 == skullType) {
            return Optional.of(class_2246.field_10042);
        }
        if (class_2484.class_2486.field_11511 == skullType) {
            return Optional.of(class_2246.field_10337);
        }
        if (class_2484.class_2486.field_11508 == skullType) {
            return Optional.of(class_2246.field_10241);
        }
        if (class_2484.class_2486.field_11512 == skullType) {
            return Optional.of(class_2246.field_10481);
        }
        if (class_2484.class_2486.field_11513 == skullType) {
            return Optional.of(class_2246.field_10177);
        }
        if (class_2484.class_2486.field_41313 == skullType) {
            return Optional.of(class_2246.field_41305);
        }
        return Optional.empty();
    }

    public static SpectrumSkullType getSkullType(class_2248 block) {
        if (block instanceof SpectrumWallSkullBlock) {
            return (SpectrumSkullType)((Object)SpectrumWallSkullBlock.MOB_WALL_HEADS.inverse().get((Object)block));
        }
        return (SpectrumSkullType)((Object)MOB_HEADS.inverse().get((Object)block));
    }

    public static Optional<class_2484.class_2485> getSkullType(class_1299<?> entityType) {
        if (class_1299.field_6046 == entityType) {
            return Optional.of(class_2484.class_2486.field_11507);
        }
        if (class_1299.field_6116 == entityType) {
            return Optional.of(class_2484.class_2486.field_11511);
        }
        if (class_1299.field_6051 == entityType) {
            return Optional.of(class_2484.class_2486.field_11508);
        }
        if (class_1299.field_6137 == entityType) {
            return Optional.of(class_2484.class_2486.field_11512);
        }
        if (class_1299.field_6076 == entityType) {
            return Optional.of(class_2484.class_2486.field_11513);
        }
        if (class_1299.field_22281 == entityType) {
            return Optional.of(class_2484.class_2486.field_41313);
        }
        return Optional.ofNullable((class_2484.class_2485)ENTITY_TYPE_TO_SKULL_TYPE.get(entityType));
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<class_2248> getMobHeads() {
        return MOB_HEADS.values();
    }

    private static class_2700 getWitherSkullPattern() {
        if (witherBossPattern == null) {
            witherBossPattern = class_2697.method_11701().method_11702(new String[]{"^^^", "###", "~#~"}).method_11700('#', pos -> pos.method_11681().method_26164(class_3481.field_22274)).method_11700('^', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)SpectrumSkullBlock.getBlock(SpectrumSkullType.WITHER).get()).or((Predicate)class_2715.method_11758((class_2248)SpectrumWallSkullBlock.getMobWallHead(SpectrumSkullType.WITHER))))).method_11700('~', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10124))).method_11704();
        }
        return witherBossPattern;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpectrumSkullBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (this.getSkullType().equals((Object)SpectrumSkullType.WITHER) && placer instanceof class_3222) {
            class_2700 blockPattern;
            class_2700.class_2702 result;
            class_3222 serverPlayerEntity = (class_3222)placer;
            if (pos.method_10264() >= world.method_31607() && (result = (blockPattern = SpectrumSkullBlock.getWitherSkullPattern()).method_11708((class_4538)world, pos)) != null) {
                Support.grantAdvancementCriterion(serverPlayerEntity, "midgame/build_wither_using_wither_heads", "built_wither_using_wither_heads");
            }
        }
    }
}

