/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.PastelRenderHelper;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3829;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Math;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ClientPastelNetworkManager
implements PastelNetworkManager<class_638, PastelNetwork<class_638>>,
class_3829 {
    protected static final int MAX_RENDER_DISTANCE_SQUARED = 2304;
    private final List<PastelNetwork<class_638>> networks = new ArrayList<PastelNetwork<class_638>>();

    @Override
    public Optional<? extends PastelNetwork<class_638>> getNetwork(UUID uuid) {
        return this.networks.stream().filter(n -> n.uuid.equals(uuid)).findFirst();
    }

    @Override
    public PastelNetwork<class_638> createNetwork(class_638 world, UUID uuid) {
        PastelNetwork<class_638> network = new PastelNetwork<class_638>(world, uuid);
        this.networks.add(network);
        return network;
    }

    public void renderLines(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        class_1297 cameraEntity = client.field_1719;
        if (cameraEntity == null) {
            return;
        }
        class_2338 cameraEntityPos = cameraEntity.method_24515();
        for (PastelNetwork<class_638> network : this.networks) {
            if (network.getWorld().method_8597() != context.world().method_8597()) continue;
            Graph<class_2338, DefaultEdge> graph = network.getGraph();
            int color = network.getColor();
            float[] colors = PastelRenderHelper.unpackNormalizedColor(color);
            for (DefaultEdge edge : graph.edgeSet()) {
                class_2338 source = (class_2338)graph.getEdgeSource((Object)edge);
                class_2338 target = (class_2338)graph.getEdgeTarget((Object)edge);
                if (cameraEntityPos.method_10262((class_2382)source) > 2304.0 && cameraEntityPos.method_10262((class_2382)target) > 2304.0) continue;
                class_4587 matrices = context.matrixStack();
                class_243 pos = context.camera().method_19326();
                matrices.method_22903();
                matrices.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
                class_2338 cross = source.method_10075((class_2382)target);
                float interval = (float)((long)(cross.method_10263() + cross.method_10264() + cross.method_10260()) + ((class_638)network.world).method_8510()) % 1000000.0f;
                double alpha = 1.0 - Math.max((double)((double)Math.sin((float)(interval / 17.0f)) * 2.5 - 2.0), (double)0.0);
                colors[0] = (float)alpha;
                PastelRenderHelper.renderLineTo(context.matrixStack(), context.consumers(), colors, source, target);
                if (client.field_1690.field_1866) {
                    class_243 offset = class_243.method_24953((class_2382)target).method_1020(class_243.method_24954((class_2382)source));
                    class_243 normalized = offset.method_1029();
                    Matrix4f positionMatrix = context.matrixStack().method_23760().method_23761();
                    PastelRenderHelper.renderDebugLine(context.consumers(), color, offset, normalized, positionMatrix);
                }
                matrices.method_22909();
            }
        }
    }

    public void method_5448() {
        this.networks.clear();
    }

    @Override
    public void removeNetwork(UUID uuid) {
        PastelNetwork<class_638> foundNetwork = null;
        for (PastelNetwork<class_638> network : this.networks) {
            if (!network.uuid.equals(uuid)) continue;
            foundNetwork = network;
            break;
        }
        if (foundNetwork != null) {
            this.networks.remove(foundNetwork);
        }
    }
}

