/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.pastel_network.network;

import de.dafuqs.spectrum.blocks.pastel_network.network.NodeRemovalReason;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelNetworkManager;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ServerPastelNetworkManager
extends class_18
implements PastelNetworkManager<class_3218, ServerPastelNetwork> {
    private static final String PERSISTENT_STATE_ID = "spectrum_pastel_network_manager";
    private final List<ServerPastelNetwork> networks = new ArrayList<ServerPastelNetwork>();

    public boolean method_79() {
        return true;
    }

    public static ServerPastelNetworkManager get(class_3218 world) {
        return (ServerPastelNetworkManager)world.method_17983().method_17924(ServerPastelNetworkManager::fromNbt, ServerPastelNetworkManager::new, PERSISTENT_STATE_ID);
    }

    @Override
    public ServerPastelNetwork createNetwork(class_3218 world, UUID uuid) {
        ServerPastelNetwork network = new ServerPastelNetwork(world, uuid);
        this.networks.add(network);
        return network;
    }

    @Override
    public Optional<ServerPastelNetwork> getNetwork(UUID uuid) {
        return this.networks.stream().filter(n -> n.uuid.equals(uuid)).findFirst();
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 networkList = new class_2499();
        for (ServerPastelNetwork network : this.networks) {
            networkList.add((Object)network.toNbt());
        }
        nbt.method_10566("Networks", (class_2520)networkList);
        return nbt;
    }

    public static ServerPastelNetworkManager fromNbt(class_2487 nbt) {
        ServerPastelNetworkManager manager = new ServerPastelNetworkManager();
        for (class_2520 element : nbt.method_10554("Networks", 10)) {
            Optional<ServerPastelNetwork> network = ServerPastelNetwork.fromNbt((class_2487)element);
            network.ifPresent(manager.networks::add);
        }
        return manager;
    }

    public void tick() {
        for (int i = 0; i < this.networks.size(); ++i) {
            this.networks.get(i).tick();
        }
    }

    @Contract(value="_, null -> new")
    public PastelNetwork<class_3218> joinOrCreateNetwork(PastelNodeBlockEntity node, @Nullable UUID uuid) {
        if (uuid != null) {
            for (int i = 0; i < this.networks.size(); ++i) {
                ServerPastelNetwork network = this.networks.get(i);
                if (!network.getUUID().equals(uuid)) continue;
                network.addNode(node);
                return network;
            }
        }
        ServerPastelNetwork network = this.createNetwork((class_3218)node.method_10997(), uuid);
        network.addNode(node);
        return network;
    }

    public boolean toggleNodeConnection(PastelNodeBlockEntity firstNode, PastelNodeBlockEntity secondNode) {
        Optional<ServerPastelNetwork> firstNetwork = firstNode.getServerNetwork();
        Optional<ServerPastelNetwork> secondNetwork = secondNode.getServerNetwork();
        if (secondNetwork.isPresent() && secondNetwork.equals(firstNetwork)) {
            return firstNetwork.get().removeEdge(firstNode, secondNode) || firstNetwork.get().addEdge(firstNode, secondNode);
        }
        if (firstNetwork.isEmpty() && secondNetwork.isEmpty()) {
            ServerPastelNetwork newNetwork = this.createNetwork((class_3218)firstNode.method_10997(), firstNode.getNodeId());
            newNetwork.addNode(secondNode);
            secondNode.setNetworkUUID(newNetwork.getUUID());
            newNetwork.addNodeAndConnect(firstNode, secondNode);
            return true;
        }
        if (firstNetwork.isPresent() && secondNetwork.isPresent()) {
            ServerPastelNetwork smallerNetwork;
            ServerPastelNetwork biggerNetwork;
            boolean firstIsBigger;
            boolean bl = firstIsBigger = firstNetwork.get().graph.vertexSet().size() > secondNetwork.get().graph.vertexSet().size();
            if (firstIsBigger) {
                biggerNetwork = firstNode.getServerNetwork().get();
                smallerNetwork = secondNode.getServerNetwork().get();
            } else {
                smallerNetwork = firstNode.getServerNetwork().get();
                biggerNetwork = secondNode.getServerNetwork().get();
            }
            biggerNetwork.incorporate(smallerNetwork, firstIsBigger ? firstNode.method_11016() : secondNode.method_11016());
            biggerNetwork.addEdge(firstNode, secondNode);
            this.networks.remove(smallerNetwork);
            SpectrumS2CPacketSender.syncPastelNetworkEdges(biggerNetwork, firstNode.method_11016());
            return true;
        }
        if (firstNetwork.isPresent()) {
            ServerPastelNetwork n = firstNetwork.get();
            n.addNodeAndConnect(secondNode, firstNode);
        } else {
            ServerPastelNetwork n = secondNetwork.get();
            n.addNodeAndConnect(firstNode, secondNode);
        }
        return true;
    }

    @Override
    public void removeNetwork(UUID uuid) {
        ServerPastelNetwork foundNetwork = null;
        for (ServerPastelNetwork network : this.networks) {
            if (!network.uuid.equals(uuid)) continue;
            foundNetwork = network;
            break;
        }
        if (foundNetwork != null) {
            this.networks.remove(foundNetwork);
            SpectrumS2CPacketSender.syncPastelNetworkRemoved(foundNetwork);
        }
    }

    public void removeNode(PastelNodeBlockEntity node, NodeRemovalReason reason) {
        Optional<ServerPastelNetwork> optional = node.getServerNetwork();
        if (optional.isPresent()) {
            ServerPastelNetwork network = optional.get();
            network.removeNode(node, reason);
        }
    }
}

