/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.blocks.present;

import de.dafuqs.spectrum.blocks.present.PresentBlock;
import de.dafuqs.spectrum.items.tooltip.PresentTooltipData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;

public class PresentItem
extends class_1747 {
    private static final String ITEMS_KEY = "Items";
    public static final int MAX_STORAGE_STACKS = 5;
    private static final int ITEM_BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);

    public PresentItem(class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    protected boolean method_7709(class_1750 context, class_2680 state) {
        return PresentItem.isWrapped(context.method_8041()) && super.method_7709(context, state);
    }

    public static boolean isWrapped(class_1799 itemStack) {
        return PresentItem.isWrapped(itemStack.method_7969());
    }

    public static boolean isWrapped(class_2487 compound) {
        return compound != null && compound.method_10577("Wrapped");
    }

    public static void setWrapper(class_1799 itemStack, class_1657 giver) {
        PresentItem.setWrapper(itemStack, giver.method_5667(), giver.method_5477().getString());
    }

    public static void setWrapper(class_1799 itemStack, UUID uuid, String name) {
        class_2487 compound = itemStack.method_7948();
        compound.method_25927("GiverUUID", uuid);
        compound.method_10582("Giver", name);
        itemStack.method_7980(compound);
    }

    public static Optional<class_3545<UUID, String>> getWrapper(class_1799 itemStack) {
        return PresentItem.getWrapper(itemStack.method_7969());
    }

    public static Optional<class_3545<UUID, String>> getWrapper(class_2487 compound) {
        if (compound != null && compound.method_10545("GiverUUID") && compound.method_10573("Giver", 8)) {
            return Optional.of(new class_3545((Object)compound.method_25926("GiverUUID"), (Object)compound.method_10558("Giver")));
        }
        return Optional.empty();
    }

    public static Map<class_1767, Integer> getColors(class_1799 itemStack) {
        return PresentItem.getColors(itemStack.method_7969());
    }

    public static Map<class_1767, Integer> getColors(class_2487 compound) {
        HashMap<class_1767, Integer> colors = new HashMap<class_1767, Integer>();
        if (compound != null && compound.method_10573("Colors", 9)) {
            for (class_2520 e : compound.method_10554("Colors", 10)) {
                class_2487 c = (class_2487)e;
                colors.put(class_1767.valueOf((String)c.method_10558("Color").toUpperCase(Locale.ROOT)), c.method_10550("Amount"));
            }
        }
        return colors;
    }

    public static void wrap(class_1799 itemStack, PresentBlock.WrappingPaper wrappingPaper, Map<class_1767, Integer> colors) {
        class_2487 compound = itemStack.method_7948();
        PresentItem.setWrapped(compound);
        PresentItem.setVariant(compound, wrappingPaper);
        PresentItem.setColors(compound, colors);
        itemStack.method_7980(compound);
    }

    public static void setWrapped(class_2487 compound) {
        compound.method_10556("Wrapped", true);
    }

    public static void setColors(class_2487 compound, Map<class_1767, Integer> colors) {
        if (!colors.isEmpty()) {
            class_2499 colorList = new class_2499();
            for (Map.Entry<class_1767, Integer> colorEntry : colors.entrySet()) {
                class_2487 colorCompound = new class_2487();
                colorCompound.method_10582("Color", colorEntry.getKey().method_7792());
                colorCompound.method_10569("Amount", colorEntry.getValue().intValue());
                colorList.add((Object)colorCompound);
            }
            compound.method_10566("Colors", (class_2520)colorList);
        }
    }

    public static void setVariant(class_2487 compound, PresentBlock.WrappingPaper wrappingPaper) {
        compound.method_10582("Variant", wrappingPaper.method_15434());
    }

    public static PresentBlock.WrappingPaper getVariant(class_2487 compound) {
        if (compound != null && compound.method_10573("Variant", 8)) {
            return PresentBlock.WrappingPaper.valueOf(compound.method_10558("Variant").toUpperCase(Locale.ROOT));
        }
        return PresentBlock.WrappingPaper.RED;
    }

    public boolean method_31565(class_1799 present, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        if (itemStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            PresentItem.removeFirstStack(present).ifPresent(removedStack -> PresentItem.addToPresent(present, slot.method_32756(removedStack)));
        } else if (itemStack.method_7909().method_31568()) {
            class_1799 slotStack = slot.method_32753(itemStack.method_7947(), 64, player);
            int acceptedStacks = PresentItem.addToPresent(present, slotStack);
            slotStack.method_7934(acceptedStacks);
            if (!slotStack.method_7960()) {
                slot.method_48931(slotStack);
            }
            if (acceptedStacks > 0) {
                this.playInsertSound((class_1297)player);
            }
        }
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player) && !this.isCraftingInventory(slot)) {
            if (otherStack.method_7960()) {
                PresentItem.removeFirstStack(stack).ifPresent(itemStack -> {
                    this.playRemoveOneSound((class_1297)player);
                    cursorStackReference.method_32332(itemStack);
                });
            } else {
                int i = PresentItem.addToPresent(stack, otherStack);
                if (i > 0) {
                    this.playInsertSound((class_1297)player);
                    otherStack.method_7934(i);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isCraftingInventory(class_1735 slot) {
        return slot.field_7871 instanceof class_1715;
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_7843(stack, world, player);
        if (player != null) {
            PresentItem.setWrapper(stack, player);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (PresentItem.isWrapped(itemStack)) {
            super.method_7836(world, user, hand);
        }
        return class_1271.method_22430((Object)itemStack);
    }

    public boolean method_31567(class_1799 stack) {
        return !PresentItem.isWrapped(stack) && PresentItem.getBundledStacks(stack).findAny().isPresent();
    }

    public int method_31569(class_1799 stack) {
        return Math.min(1 + (int)(12.0f * ((float)PresentItem.getBundledStacks(stack).count() / 5.0f)), 13);
    }

    public int method_31571(class_1799 stack) {
        return ITEM_BAR_COLOR;
    }

    public static int addToPresent(class_1799 present, class_1799 stackToAdd) {
        if (!stackToAdd.method_7960() && stackToAdd.method_7909().method_31568()) {
            class_2487 nbt = present.method_7948();
            if (!nbt.method_10545(ITEMS_KEY)) {
                nbt.method_10566(ITEMS_KEY, (class_2520)new class_2499());
            }
            class_2499 nbtList = nbt.method_10554(ITEMS_KEY, 10);
            int originalCount = stackToAdd.method_7947();
            for (int i = 0; i < 5; ++i) {
                int additionalAmount;
                class_1799 storedStack = class_1799.method_7915((class_2487)nbtList.method_10602(i));
                if (storedStack.method_7960()) {
                    class_2487 leftoverCompound = new class_2487();
                    stackToAdd.method_7953(leftoverCompound);
                    nbtList.add((Object)leftoverCompound);
                    present.method_7980(nbt);
                    return originalCount;
                }
                if (!class_1799.method_31577((class_1799)stackToAdd, (class_1799)storedStack) || (additionalAmount = Math.min(stackToAdd.method_7947(), storedStack.method_7914() - storedStack.method_7947())) <= 0) continue;
                stackToAdd.method_7934(additionalAmount);
                storedStack.method_7933(additionalAmount);
                class_2487 newCompound = new class_2487();
                storedStack.method_7953(newCompound);
                nbtList.method_10606(i, (class_2520)newCompound);
                if (!stackToAdd.method_7960()) continue;
                present.method_7980(nbt);
                return originalCount;
            }
            return originalCount - stackToAdd.method_7947();
        }
        return 0;
    }

    private static Optional<class_1799> removeFirstStack(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(ITEMS_KEY)) {
            return Optional.empty();
        }
        class_2499 nbtList = nbt.method_10554(ITEMS_KEY, 10);
        if (nbtList.isEmpty()) {
            return Optional.empty();
        }
        int i = 0;
        class_2487 nbtCompound2 = nbtList.method_10602(i);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        nbtList.method_10536(i);
        if (nbtList.isEmpty()) {
            stack.method_7983(ITEMS_KEY);
        }
        return Optional.of(itemStack);
    }

    public static Stream<class_1799> getBundledStacks(class_1799 stack) {
        return PresentItem.getBundledStacks(stack.method_7969());
    }

    public static Stream<class_1799> getBundledStacks(class_2487 nbtCompound) {
        if (nbtCompound == null) {
            return Stream.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, 10);
        Stream stream = nbtList.stream();
        Objects.requireNonNull(class_2487.class);
        return stream.map(class_2487.class::cast).map(class_1799::method_7915);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        boolean wrapped = PresentItem.isWrapped(stack);
        if (wrapped) {
            return Optional.empty();
        }
        ArrayList<class_1799> list = new ArrayList<class_1799>(5);
        PresentItem.getBundledStacks(stack).forEachOrdered(list::add);
        while (list.size() < 5) {
            list.add(class_1799.field_8037);
        }
        return Optional.of(new PresentTooltipData(list));
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        boolean wrapped = PresentItem.isWrapped(stack);
        if (wrapped) {
            Optional<class_3545<UUID, String>> giver = PresentItem.getWrapper(stack);
            if (giver.isPresent()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"block.spectrum.present.tooltip.wrapped.giver", (Object[])new Object[]{giver.get().method_15441()}).method_27692(class_124.field_1080));
                if (context.method_8035()) {
                    tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + ((UUID)giver.get().method_15442()).toString())).method_27692(class_124.field_1080));
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"block.spectrum.present.tooltip.wrapped").method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"block.spectrum.present.tooltip.description").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)"block.spectrum.present.tooltip.description2").method_27692(class_124.field_1080));
            class_2371 defaultedList = class_2371.method_10211();
            Stream<class_1799> bundledStacks = PresentItem.getBundledStacks(stack);
            bundledStacks.forEach(arg_0 -> defaultedList.add(arg_0));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{defaultedList.size(), 5}).method_27692(class_124.field_1080));
        }
    }

    public boolean method_31568() {
        return false;
    }

    public void method_33261(class_1542 entity) {
        class_5328.method_33263((class_1542)entity, PresentItem.getBundledStacks(entity.method_6983()));
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }
}

