/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.compat.travelersbackpack;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import de.dafuqs.spectrum.compat.SpectrumIntegrationPacks;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumFluids;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3611;

public class TravelersBackpackCompat
extends SpectrumIntegrationPacks.ModIntegrationPack {
    @Override
    public void register() {
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new SpectrumEffectFluid("spectrum:mud", SpectrumFluids.MUD.method_15751()){

            public void affectDrinker(FluidVariantWrapper fluidVariantWrapper, class_1937 world, class_1297 entity) {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    livingEntity.method_6092(new class_1293(class_1294.field_5916, 200));
                    livingEntity.method_6092(new class_1293(class_1294.field_5907, 400, 2));
                    livingEntity.method_6092(new class_1293(class_1294.field_5909, 600, 3));
                }
            }
        });
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new SpectrumEffectFluid("spectrum:liquid_crystal", SpectrumFluids.LIQUID_CRYSTAL.method_15751()){

            public void affectDrinker(FluidVariantWrapper fluidStack, class_1937 world, class_1297 entity) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    player.method_6092(new class_1293(class_1294.field_5924, 400, 1));
                }
            }
        });
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new SpectrumEffectFluid("spectrum:midnight_solution", SpectrumFluids.MIDNIGHT_SOLUTION.method_15751()){

            public void affectDrinker(FluidVariantWrapper fluidStack, class_1937 world, class_1297 entity) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    player.method_7255(-20);
                    ArrayList equipment = new ArrayList();
                    player.method_5743().forEach(equipment::add);
                    Collections.shuffle(equipment);
                    for (class_1799 equip : equipment) {
                        Map enchants = class_1890.method_8222((class_1799)equip);
                        if (enchants.isEmpty()) continue;
                        Set enchantments = enchants.keySet();
                        class_1887 enchantment = enchantments.stream().skip(new Random().nextInt(enchantments.size())).findFirst().orElse(null);
                        SpectrumEnchantmentHelper.removeEnchantments(equip, enchantment);
                    }
                }
            }
        });
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new SpectrumEffectFluid("spectrum:dragonrot", SpectrumFluids.DRAGONROT.method_15751()){

            public void affectDrinker(FluidVariantWrapper fluidStack, class_1937 world, class_1297 entity) {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    livingEntity.method_6092(new class_1293(SpectrumStatusEffects.LIFE_DRAIN, 600, 3));
                    livingEntity.method_5643(SpectrumDamageTypes.dragonrot(world), 1000.0f);
                }
            }
        });
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerClient() {
    }

    public static abstract class SpectrumEffectFluid
    extends EffectFluid {
        public SpectrumEffectFluid(String id, class_3611 fluid) {
            super(id, fluid, 81000);
        }

        public boolean canExecuteEffect(FluidVariantWrapper stack, class_1937 world, class_1297 entity) {
            return stack.getAmount() >= (long)this.amountRequired;
        }
    }
}

