/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.deeper_down;

import com.google.common.collect.ImmutableMap;
import de.dafuqs.spectrum.registries.SpectrumBiomes;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.SleepStatusEffect;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class DarknessEffects {
    public static final float INTERP_TICKS = 160.0f;
    private static final Map<class_5321<class_1959>, Float> INTERP_MULTIPLIERS;
    private static final Map<class_5321<class_1959>, Float> FOG_MULTIPLIERS;
    private static final Map<class_5321<class_1959>, float[]> TRANS_MULTIPLIERS;
    public static boolean isInDarkenedBiome;
    public static boolean sleepAfflicted;
    public static boolean forceFogEffects;
    public static int darkenTicks;
    public static int darken;
    public static int lastDarkenTicks;
    public static int interpInterpTicks;
    public static float interpTarget;
    public static float interp;
    public static float lastInterpTarget;
    public static float fogTarget;
    public static float fogDarkness;
    public static float lastFogTarget;
    public static float nearTarget;
    public static float near;
    public static float lastNearTarget;
    public static float farTarget;
    public static float far;
    public static float lastFarTarget;
    public static float redTarget;
    public static float red;
    public static float lastRedTarget;
    public static float greenTarget;
    public static float green;
    public static float lastGreenTarget;
    public static float blueTarget;
    public static float blue;
    public static float lastBlueTarget;
    public static float blendTarget;
    public static float blend;
    public static float lastBlendTarget;
    private static class_6880<class_1959> currentBiome;
    private static final class_310 client;
    private static boolean shouldUpdate;
    private static boolean forceBiomeUpdate;

    public static void clientTick(class_638 world, class_1297 entity, class_6880<class_1959> biome) {
        if (client.method_1493()) {
            return;
        }
        lastDarkenTicks = darkenTicks;
        float sleepPotency = -1.0f;
        class_1291 sleepEffect = null;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            sleepPotency = SleepStatusEffect.getSleepScaling(livingEntity);
            sleepEffect = SleepStatusEffect.getStrongestSleepEffect(livingEntity);
        }
        if (shouldUpdate) {
            float targets = class_3532.method_15363((float)(sleepPotency / 2.0f), (float)0.0f, (float)1.0f);
            interpInterpTicks = 0;
            shouldUpdate = false;
            DarknessEffects.updateTargets();
            if (sleepEffect == SpectrumStatusEffects.FATAL_SLUMBER) {
                sleepAfflicted = true;
                blendTarget = 1.0f;
                interpTarget = 1.0f;
                redTarget = 0.05490196f;
                greenTarget = 0.015686275f;
                blueTarget = 0.105882354f;
                nearTarget = -10.0f;
                farTarget = 0.25f;
                forceFogEffects = true;
            } else if (sleepEffect == SpectrumStatusEffects.ETERNAL_SLUMBER) {
                sleepAfflicted = true;
                blendTarget = targets;
                interpTarget = targets;
                redTarget = 0.28627452f;
                greenTarget = 0.14117648f;
                blueTarget = 0.4509804f;
                nearTarget = -2.0f;
                farTarget = 0.9f;
                forceFogEffects = true;
            } else if (sleepEffect == SpectrumStatusEffects.SOMNOLENCE) {
                sleepAfflicted = true;
                blendTarget = targets;
                interpTarget = targets;
                redTarget = 0.7647059f;
                greenTarget = 0.37254903f;
                blueTarget = 0.93333334f;
                nearTarget = -5.0f;
                forceFogEffects = true;
            } else {
                sleepAfflicted = false;
                blendTarget = 0.0f;
                redTarget = 0.0f;
                greenTarget = 0.0f;
                blueTarget = 0.0f;
                currentBiome = null;
                forceFogEffects = false;
                forceBiomeUpdate = true;
            }
        } else if (currentBiome == null || !currentBiome.method_40230().equals(biome.method_40230())) {
            if (forceBiomeUpdate) {
                forceBiomeUpdate = false;
            }
            class_5321 biomeKey = biome.method_40230().orElse(null);
            currentBiome = biome;
            DarknessEffects.updateTargets();
            interpTarget = INTERP_MULTIPLIERS.getOrDefault(biomeKey, Float.valueOf(0.0f)).floatValue();
            fogTarget = FOG_MULTIPLIERS.getOrDefault(biomeKey, Float.valueOf(1.0f)).floatValue();
            float[] targets = TRANS_MULTIPLIERS.getOrDefault(biomeKey, new float[]{1.0f, 1.0f});
            nearTarget = targets[0];
            farTarget = targets[1];
            interpInterpTicks = 0;
        }
        if (interpInterpTicks < Math.round(106.666664f)) {
            ++interpInterpTicks;
        }
        interp = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastInterpTarget, (float)interpTarget);
        fogDarkness = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastFogTarget, (float)fogTarget);
        near = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastNearTarget, (float)nearTarget);
        far = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastFarTarget, (float)farTarget);
        red = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastRedTarget, (float)redTarget);
        green = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastGreenTarget, (float)greenTarget);
        blue = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastBlueTarget, (float)blueTarget);
        blend = class_3532.method_16439((float)((float)interpInterpTicks / (float)Math.round(106.666664f)), (float)lastBlendTarget, (float)blendTarget);
        isInDarkenedBiome = INTERP_MULTIPLIERS.containsKey(biome.method_40230().orElse(null));
        if (isInDarkenedBiome || sleepAfflicted) {
            if ((float)darkenTicks < 160.0f) {
                ++darkenTicks;
            } else if ((float)darkenTicks > 160.0f) {
                --darkenTicks;
            }
        } else if (darkenTicks > 0) {
            --darkenTicks;
        }
    }

    private static void updateTargets() {
        lastInterpTarget = interp;
        lastFogTarget = fogDarkness;
        lastNearTarget = near;
        lastFarTarget = far;
        lastRedTarget = red;
        lastGreenTarget = green;
        lastBlueTarget = blue;
        lastBlendTarget = blend;
    }

    public static void markForEffectUpdate() {
        shouldUpdate = true;
    }

    public static float getInterp() {
        if (DarknessEffects.client.field_1719 == null) {
            return interp;
        }
        double y = class_3532.method_16436((double)client.method_1488(), (double)DarknessEffects.client.field_1719.field_5971, (double)DarknessEffects.client.field_1719.method_23318());
        float adjustedInterp = y > -116.0 ? (float)class_3532.method_15390((double)0.175f, (double)interp, (double)((y + 64.0) / -52.0)) : (y < -256.0 ? (float)Math.max((double)interp, Math.min((double)0.825f, (double)interp + (y + 256.0) / -256.0)) : interp);
        return adjustedInterp;
    }

    public static float getNear(float start) {
        if (DarknessEffects.client.field_1719 == null) {
            return near;
        }
        double y = class_3532.method_16436((double)client.method_1488(), (double)DarknessEffects.client.field_1719.field_5971, (double)DarknessEffects.client.field_1719.method_23318());
        float distance = y < -272.0 ? (float)class_3532.method_15390((double)0.0, (double)1.334f, (double)((y + 272.0) / -48.0)) * near : near;
        return distance * start;
    }

    public static float getFar(float end) {
        if (DarknessEffects.client.field_1719 == null) {
            return far;
        }
        return far * end;
    }

    public static float getDarknessInterpolation() {
        return class_3532.method_16439((float)class_310.method_1551().method_1488(), (float)darkenTicks, (float)lastDarkenTicks) / 160.0f * DarknessEffects.getInterp();
    }

    static {
        fogTarget = 1.0f;
        fogDarkness = 1.0f;
        lastFogTarget = 1.0f;
        nearTarget = 1.0f;
        near = 1.0f;
        lastNearTarget = 1.0f;
        farTarget = 1.0f;
        far = 1.0f;
        lastFarTarget = 1.0f;
        client = class_310.method_1551();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(SpectrumBiomes.BLACK_LANGAST, (Object)Float.valueOf(0.7f));
        builder.put(SpectrumBiomes.DEEP_BARRENS, (Object)Float.valueOf(0.325f));
        builder.put(SpectrumBiomes.DEEP_DRIPSTONE_CAVES, (Object)Float.valueOf(0.1f));
        builder.put(SpectrumBiomes.NOXSHROOM_FOREST, (Object)Float.valueOf(0.05f));
        INTERP_MULTIPLIERS = builder.build();
        ImmutableMap.Builder fogBuilder = ImmutableMap.builder();
        fogBuilder.put(SpectrumBiomes.NOXSHROOM_FOREST, (Object)Float.valueOf(0.125f));
        fogBuilder.put(SpectrumBiomes.DEEP_DRIPSTONE_CAVES, (Object)Float.valueOf(0.25f));
        fogBuilder.put(SpectrumBiomes.DEEP_BARRENS, (Object)Float.valueOf(0.55f));
        fogBuilder.put(SpectrumBiomes.BLACK_LANGAST, (Object)Float.valueOf(0.0125f));
        FOG_MULTIPLIERS = fogBuilder.build();
        ImmutableMap.Builder transMultiplier = ImmutableMap.builder();
        transMultiplier.put(SpectrumBiomes.NOXSHROOM_FOREST, (Object)new float[]{1.25f, 1.0f});
        transMultiplier.put(SpectrumBiomes.HOWLING_SPIRES, (Object)new float[]{-10.0f, 0.85f});
        transMultiplier.put(SpectrumBiomes.DEEP_BARRENS, (Object)new float[]{-1.0f, 0.5f});
        transMultiplier.put(SpectrumBiomes.BLACK_LANGAST, (Object)new float[]{0.8f, 0.8f});
        transMultiplier.put(SpectrumBiomes.DRAGONROT_SWAMP, (Object)new float[]{-5.0f, 0.8f});
        TRANS_MULTIPLIERS = transMultiplier.build();
    }
}

