/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.api.entity.NonLivingAttackable;
import de.dafuqs.spectrum.enchantments.ImprovedCriticalEnchantment;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.entity.BidentBaseEntity;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.tools.DraconicTwinswordItem;
import de.dafuqs.spectrum.mixin.accessors.TridentEntityAccessor;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class DraconicTwinswordEntity
extends BidentBaseEntity
implements NonLivingAttackable {
    private static final class_2940<Boolean> HIT = class_2945.method_12791(DraconicTwinswordEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PROPELLED = class_2945.method_12791(DraconicTwinswordEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> REBOUND = class_2945.method_12791(DraconicTwinswordEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> MAX_PIERCE = class_2945.method_12791(DraconicTwinswordEntity.class, (class_2941)class_2943.field_13327);
    private static final class_4048 initialSize = class_4048.method_18384((float)1.5f, (float)1.5f);
    private static final class_4048 shortSize = class_4048.method_18384((float)1.0f, (float)1.0f);
    private static final class_4048 tallSize = class_4048.method_18384((float)1.0f, (float)1.8f);
    private final Set<class_1297> piercedEntities = new HashSet<class_1297>();
    private int travelingTicks = 0;
    private int jiggleTicks = 20;
    private int jiggleIntensity = 8;
    private float damageMult = 1.0f;
    private float velMult = 1.0f;

    public DraconicTwinswordEntity(class_1937 world) {
        this(SpectrumEntityTypes.DRACONIC_TWINSWORD, world);
    }

    public DraconicTwinswordEntity(class_1299<? extends class_1685> entityType, class_1937 world) {
        super(entityType, world);
    }

    public boolean method_5863() {
        return true;
    }

    public void method_5773() {
        block4: {
            block3: {
                if (!this.isPropelled() || this.isRebounding()) break block3;
                if (this.travelingTicks >= 12) break block4;
                ++this.travelingTicks;
                if (this.travelingTicks <= 6 || !(this.method_18798().method_1027() > 2.0)) break block4;
                this.method_18799(this.method_18798().method_1021(0.5));
                this.field_6007 = true;
                this.field_6037 = true;
                break block4;
            }
            if (this.field_7588) {
                this.damageMult = 1.0f;
                this.velMult = 1.0f;
                if (this.jiggleTicks < 15) {
                    ++this.jiggleTicks;
                    float intensity = 1.0f - (float)this.jiggleTicks / 15.0f;
                    this.field_6004 = this.method_36455();
                    this.method_36457(this.field_6004 + (float)this.jiggleIntensity * intensity / 2.0f * (float)(this.field_5974.method_43048(3) - 1));
                    this.field_5982 = this.method_36454();
                    this.method_36456(this.field_5982 + (float)this.jiggleIntensity * intensity * (float)(this.field_5974.method_43048(3) - 1));
                }
                for (class_1297 thornCandidate : this.method_37908().method_8333((class_1297)this, this.method_33332(), x$0 -> this.method_26958((class_1297)x$0))) {
                    if (!((Boolean)this.field_6011.method_12789(HIT)).booleanValue() || thornCandidate instanceof class_1542 || !thornCandidate.method_5643(this.method_48923().method_48818((class_1297)this), 4.0f)) continue;
                    this.method_5783(class_3417.field_14663, 1.0f, 0.9f + this.field_5974.method_43057() * 0.2f);
                }
            }
        }
        super.method_5773();
    }

    @Override
    protected class_3414 method_7440() {
        return class_3417.field_15104;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 striker = source.method_5529();
        if (striker == null) {
            return false;
        }
        if (!((Boolean)this.field_6011.method_12789(HIT)).booleanValue()) {
            if (this.isPropelled()) {
                this.applyInertiaEffects(this.getTrackedStack());
            }
            this.travelingTicks = 0;
            this.setVelocity(striker.method_36455(), striker.method_36454(), 0.0f, 3.0f * this.velMult);
            this.method_36457(striker.method_36455());
            this.method_36456(striker.method_36454());
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.setPropelled(true);
            this.setRebounding(false);
            ((TridentEntityAccessor)((Object)this)).spectrum$setDealtDamage(false);
            this.method_5783(SpectrumSoundEvents.METAL_HIT, 0.8f, 0.8f + this.field_5974.method_43057() * 0.4f);
        } else {
            this.jiggleTicks = 0;
            this.jiggleIntensity = 8;
            this.method_5783(class_3417.field_15104, 1.0f, 1.0f);
        }
        return false;
    }

    public boolean method_5732() {
        return true;
    }

    @Override
    public class_238 method_33332() {
        if (this.isPropelled()) {
            return super.method_33332();
        }
        if (this.isRebounding()) {
            return shortSize.method_30757(this.method_19538());
        }
        if (this.field_7588) {
            float absPitch = Math.abs(this.method_36455());
            if (absPitch > 55.0f) {
                return tallSize.method_30757(this.method_19538());
            }
            return shortSize.method_30757(this.method_19538());
        }
        return initialSize.method_30757(this.method_19538());
    }

    public void setVelocity(float pitch, float yaw, float roll, float speed) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        this.method_18799(new class_243((double)f, (double)g, (double)h).method_1021((double)speed));
        this.field_6007 = true;
        this.field_6037 = true;
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1282 damageSource;
        class_1297 attacked = entityHitResult.method_17782();
        if (attacked.method_5864() == class_1299.field_6091) {
            return;
        }
        boolean propelled = this.isPropelled();
        class_1799 stack = this.getTrackedStack();
        int channeling = class_1890.method_8225((class_1887)class_1893.field_9117, (class_1799)stack);
        class_1297 owner = this.method_24921();
        if (this.piercedEntities.contains(attacked)) {
            return;
        }
        float damage = propelled ? 2.0f : 1.0f;
        damage = this.adjustDamage(damage, channeling);
        boolean crit = false;
        if (attacked instanceof class_1309) {
            class_1309 livingAttacked = (class_1309)attacked;
            damage *= this.getDamage(stack) + class_1890.method_8218((class_1799)stack, (class_1310)livingAttacked.method_6046());
        }
        if (!attacked.method_24828() && propelled) {
            damage *= 3.0f + ImprovedCriticalEnchantment.getAddtionalCritDamageMultiplier(SpectrumEnchantmentHelper.getUsableLevel(SpectrumEnchantments.IMPROVED_CRITICAL, stack, owner));
            crit = true;
        }
        if (attacked.method_5643(damageSource = SpectrumDamageTypes.impaling(this.method_37908(), (class_1297)this, owner), damage) && attacked instanceof class_1309) {
            class_1309 livingAttacked = (class_1309)attacked;
            if (owner instanceof class_1309) {
                class_1890.method_8210((class_1309)livingAttacked, (class_1297)owner);
                class_1890.method_8213((class_1309)((class_1309)owner), (class_1297)livingAttacked);
            }
            this.method_7450(livingAttacked);
        }
        if (crit) {
            this.method_5783(SpectrumSoundEvents.CRITICAL_CRUNCH, 1.0f, 1.0f);
            this.method_5783(SpectrumSoundEvents.IMPACT_BASE, 1.8f, 0.5f);
        } else {
            this.method_5783(SpectrumSoundEvents.IMPALING_HIT, 1.0f, 0.9f + this.field_5974.method_43057() * 0.2f);
        }
        if (this.getMaxPierce() > 0) {
            this.damageMult *= 0.8f;
            this.piercedEntities.add(attacked);
            this.setMaxPierce(this.getMaxPierce() - 1);
            return;
        }
        ((TridentEntityAccessor)((Object)this)).spectrum$setDealtDamage(true);
        this.applyChannelingAOE(channeling, damage, attacked, damageSource);
        this.applyInertiaEffects(stack);
        this.method_18799(this.method_18798().method_18805(-1.0, -1.0, -1.0));
        this.travelingTicks = 0;
        this.setPropelled(false);
        if (owner != null) {
            this.rebound(owner.method_19538(), 0.105, 0.15);
        }
    }

    private void applyInertiaEffects(class_1799 stack) {
        int inertia = class_1890.method_8225((class_1887)SpectrumEnchantments.INERTIA, (class_1799)stack);
        if (inertia > 0) {
            this.damageMult += (float)inertia * 0.1675f;
            if (this.velMult < 2.0f) {
                this.velMult += 0.1f;
            }
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        double boost;
        class_2338 pos = blockHitResult.method_17777();
        class_2680 state = this.method_37908().method_8320(pos);
        class_1799 stack = this.getTrackedStack();
        int channeling = class_1890.method_8225((class_1887)class_1893.field_9117, (class_1799)stack);
        float damage = this.adjustDamage(this.getDamage(stack), channeling);
        class_1282 damageSource = SpectrumDamageTypes.impaling(this.method_37908(), (class_1297)this, this.method_24921());
        boolean slime = state.method_27852(class_2246.field_10030);
        boolean bounce = (state.method_27852(class_2246.field_10030) || state.method_26214((class_1922)this.method_37908(), pos) >= 25.0f) && !state.method_26164(class_3481.field_15471) && !state.method_26164(class_3481.field_29822);
        double d = boost = this.method_18798().method_1033() < 1.0 || slime ? 1.4 : 0.9;
        if (this.isPropelled() && bounce && this.method_18798().method_1027() > 1.0) {
            switch (blockHitResult.method_17780().method_10166()) {
                case field_11048: {
                    this.method_18799(this.method_18798().method_18805(-boost, boost, boost));
                    break;
                }
                case field_11052: {
                    this.method_18799(this.method_18798().method_18805(boost, -boost, boost));
                    break;
                }
                case field_11051: {
                    this.method_18799(this.method_18798().method_18805(boost, boost, -boost));
                }
            }
            this.method_5783(SpectrumSoundEvents.METAL_TAP, 1.0f, 1.5f);
            this.applyChannelingAOE(channeling, damage, null, damageSource);
            this.travelingTicks = 0;
            return;
        }
        if (!this.isRebounding() && !this.isPropelled() && bounce) {
            this.travelingTicks = 0;
            this.rebound(this.method_24921().method_19538(), 0.105, 0.15);
            this.method_5783(SpectrumSoundEvents.METAL_TAP, 1.0f, 1.5f);
            return;
        }
        super.method_24920(blockHitResult);
        if (((Boolean)this.field_6011.method_12789(HIT)).booleanValue() || this.method_7441()) {
            return;
        }
        if (this.isPropelled()) {
            this.applyChannelingAOE(channeling, damage * 2.0f, null, damageSource);
        }
        this.setRebounding(false);
        this.setPropelled(false);
        this.field_6011.method_12778(HIT, (Object)true);
        this.jiggleTicks = 0;
        this.jiggleIntensity = 4;
    }

    private float adjustDamage(float damage, int channeling) {
        return damage *= this.damageMult * (channeling > 0 ? 0.75f : 1.0f);
    }

    private void applyChannelingAOE(int channeling, float damage, @Nullable class_1297 except, class_1282 damageSource) {
        if (channeling > 0 && !this.method_37908().method_8608()) {
            class_3218 world = (class_3218)this.method_37908();
            class_238 hitbox = this.method_33332().method_1014(2.5 + (double)channeling * 1.5);
            List entities = this.method_37908().method_8335((class_1297)this, hitbox);
            float spreadingDamage = damage * (1.0f - 1.0f / ((float)channeling + 2.0f));
            boolean anyHit = false;
            for (class_1297 entity : entities) {
                class_1309 living;
                if (!(entity instanceof class_1309) || (living = (class_1309)entity) == except || living == this.method_24921() || !living.method_5643(damageSource, spreadingDamage / Math.max(entity.method_5739((class_1297)this) / 2.0f, 1.0f))) continue;
                for (int i = 0; i < 8; ++i) {
                    world.method_14199((class_2394)class_2398.field_11208, living.method_23322(1.25), living.method_23318() + (double)(living.method_17682() * this.field_5974.method_43057()), living.method_23325(1.25), 1 + this.field_5974.method_43048(2), 0.0, (double)(this.field_5974.method_43057() / 6.0f), 0.0, 0.0);
                }
                anyHit = true;
            }
            if (anyHit) {
                for (int i = 0; i < 10 * channeling; ++i) {
                    world.method_14199((class_2394)class_2398.field_28479, this.method_23322(1.0), this.method_23318() + (double)(this.method_17682() * this.field_5974.method_43057()), this.method_23325(1.0), 1 + this.field_5974.method_43048(2), 0.0, (double)(this.field_5974.method_43057() + 0.25f), 0.0, 0.0);
                }
                world.method_47967(null, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, SpectrumSoundEvents.ELECTRIC_DISCHARGE, class_3419.field_15248, 1.0f, 0.6f + this.field_5974.method_43057() * 0.2f, 0L);
            }
        }
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)currentPosition, (class_243)nextPosition, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
    }

    private float getDamage(class_1799 stack) {
        return (float)stack.method_7926(class_1304.field_6173).get((Object)class_5134.field_23721).stream().mapToDouble(class_1322::method_6186).sum();
    }

    public void method_7446() {
    }

    public boolean isPropelled() {
        return (Boolean)this.field_6011.method_12789(PROPELLED);
    }

    public boolean isRebounding() {
        return (Boolean)this.field_6011.method_12789(REBOUND);
    }

    public void setPropelled(boolean propelled) {
        this.field_6011.method_12778(PROPELLED, (Object)propelled);
    }

    public void setRebounding(boolean rebounding) {
        this.field_6011.method_12778(REBOUND, (Object)rebounding);
    }

    public void rebound(class_243 target, double xMod, double yMod) {
        this.setRebounding(true);
        class_243 yPos = this.method_19538();
        double heightDif = Math.abs(yPos.field_1351 - target.field_1351);
        class_243 velocity = target.method_1020(yPos);
        float finalMult = (this.velMult - 1.0f) / 2.0f + 1.0f;
        yMod = Math.max(0.0725, yMod * (1.0 - heightDif * 0.024));
        this.method_18799(velocity.method_18805(xMod, yMod, xMod).method_1021((double)finalMult).method_1031(0.0, 0.3, 0.0));
        this.method_36456(-this.method_36454());
        this.method_36457(-this.method_36455());
        this.field_6037 = true;
        this.field_6007 = true;
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1799 rootStack = this.getRootStack();
        if (!rootStack.method_7960()) {
            SpectrumItems.DRACONIC_TWINSWORD.markReserved(rootStack, false);
        }
        super.method_5650(reason);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HIT, (Object)false);
        this.field_6011.method_12784(PROPELLED, (Object)false);
        this.field_6011.method_12784(REBOUND, (Object)false);
        this.field_6011.method_12784(MAX_PIERCE, (Object)0);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(HIT, (Object)nbt.method_10577("hit"));
        this.setTrackedStack(class_1799.method_7915((class_2487)nbt));
        this.setPropelled(nbt.method_10577("propelled"));
        this.setRebounding(nbt.method_10577("rebounding"));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.getTrackedStack().method_7953(nbt);
        nbt.method_10556("hit", ((Boolean)this.field_6011.method_12789(HIT)).booleanValue());
        nbt.method_10556("propelled", this.isPropelled());
        nbt.method_10556("rebounding", this.isRebounding());
    }

    public void setMaxPierce(int pierce) {
        this.field_6011.method_12778(MAX_PIERCE, (Object)pierce);
    }

    public int getMaxPierce() {
        return (Integer)this.field_6011.method_12789(MAX_PIERCE);
    }

    private class_1799 getRootStack() {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            class_1799 rootStack = DraconicTwinswordItem.findThrownStack(player, this.field_6021);
            return rootStack;
        }
        return class_1799.field_8037;
    }

    public void method_5694(class_1657 player) {
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        return this.method_34713(player) ? class_1269.field_5812 : class_1269.field_5814;
    }

    protected boolean method_34713(class_1657 player) {
        if (player != this.method_24921()) {
            player.method_5643(this.method_48923().method_48818((class_1297)this), 20.0f);
            this.method_5783(class_3417.field_14663, 1.0f, 0.9f + this.field_5974.method_43057() * 0.2f);
            return false;
        }
        class_1799 rootStack = DraconicTwinswordItem.findThrownStack(player, this.field_6021);
        if (!rootStack.method_7960()) {
            if (this.method_37908().method_8608()) {
                return true;
            }
            SpectrumItems.DRACONIC_TWINSWORD.markReserved(rootStack, false);
            player.method_6103((class_1297)this, 1);
            player.method_5783(class_3417.field_15197, 1.0f, 1.0f);
            this.method_31472();
            return true;
        }
        this.method_31472();
        return false;
    }

    @Nullable
    public class_1542 method_5775(class_1799 stack) {
        return null;
    }

    @Nullable
    public class_1542 method_5699(class_1799 stack, float yOffset) {
        return null;
    }
}

