/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.entity.entity;

import de.dafuqs.spectrum.api.block.ColorableBlock;
import de.dafuqs.spectrum.api.energy.color.InkColor;
import de.dafuqs.spectrum.api.energy.color.InkColors;
import de.dafuqs.spectrum.api.interaction.EntityColorProcessorRegistry;
import de.dafuqs.spectrum.blocks.idols.FirestarterIdolBlock;
import de.dafuqs.spectrum.compat.claims.GenericClaimModsCompat;
import de.dafuqs.spectrum.entity.SpectrumEntityTypes;
import de.dafuqs.spectrum.entity.entity.MagicProjectileEntity;
import de.dafuqs.spectrum.helpers.BlockVariantHelper;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumDamageTypes;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1890;
import net.minecraft.class_1900;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;

public class InkProjectileEntity
extends MagicProjectileEntity {
    private static final int COLOR_SPLAT_RANGE = 2;
    private static final int SPELL_POTENCY = 2;
    private static final float DAMAGE_PER_POTENCY = 0.5f;
    private static final class_2940<Integer> COLOR = class_2945.method_12791(InkProjectileEntity.class, (class_2941)class_2943.field_13327);

    public InkProjectileEntity(class_1299<InkProjectileEntity> type, class_1937 world) {
        super(type, world);
    }

    public InkProjectileEntity(double x, double y, double z, class_1937 world) {
        this(SpectrumEntityTypes.INK_PROJECTILE, world);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
    }

    public InkProjectileEntity(class_1937 world, class_1309 owner) {
        this(owner.method_23317(), owner.method_23320() - 0.1, owner.method_23321(), world);
        this.method_7432((class_1297)owner);
        this.method_5710(owner.method_36454(), owner.method_36455());
    }

    public static void shoot(class_1937 world, class_1309 entity, InkColor color) {
        InkProjectileEntity projectile = new InkProjectileEntity(world, entity);
        projectile.method_24919((class_1297)entity, entity.method_36455(), entity.method_36454(), 0.0f, 2.0f, 1.0f);
        projectile.setColor(color);
        world.method_8649((class_1297)projectile);
    }

    protected void method_5693() {
        this.field_6011.method_12784(COLOR, (Object)-1);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    @Override
    public InkColor getInkColor() {
        return InkColor.ofDyeColor(class_1767.method_7791((int)((Integer)this.field_6011.method_12789(COLOR))));
    }

    public void setColor(InkColor inkColor) {
        this.field_6011.method_12778(COLOR, (Object)inkColor.getDyeColor().method_7789());
    }

    protected void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        int color = this.getColor();
        if (color != -1) {
            nbt.method_10569("Color", color);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Color", 99)) {
            this.setColor(nbt.method_10550("Color"));
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.spawnParticles(1);
    }

    private void spawnParticles(int amount) {
        int colorOrdinal = this.getColor();
        if (colorOrdinal != -1 && amount > 0) {
            class_1767 dyeColor = class_1767.method_7791((int)colorOrdinal);
            for (int j = 0; j < amount; ++j) {
                this.method_37908().method_8406((class_2394)SpectrumParticleTypes.getCraftingParticle(dyeColor), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1282 damageSource;
        super.method_7454(entityHitResult);
        class_1297 entity = entityHitResult.method_17782();
        if (EntityColorProcessorRegistry.colorEntity(entity, this.getInkColor().getDyeColor())) {
            entity.method_37908().method_43129(null, entity, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
        }
        float velocity = (float)this.method_18798().method_1033();
        int damage = class_3532.method_15384((double)class_3532.method_15350((double)((double)velocity * 0.5 * 2.0), (double)0.0, (double)2.147483647E9));
        class_1297 entity2 = this.method_24921();
        if (entity2 == null) {
            damageSource = SpectrumDamageTypes.inkProjectile(this, (class_1297)this);
        } else {
            damageSource = SpectrumDamageTypes.inkProjectile(this, entity2);
            if (entity2 instanceof class_1309) {
                ((class_1309)entity2).method_6114(entity);
            }
        }
        if (entity.method_5643(damageSource, (float)damage)) {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (!this.method_37908().method_8608() && entity2 instanceof class_1309) {
                    class_1890.method_8210((class_1309)livingEntity, (class_1297)entity2);
                    class_1890.method_8213((class_1309)((class_1309)entity2), (class_1297)livingEntity);
                }
                this.onHit(livingEntity);
                if (livingEntity != entity2 && livingEntity instanceof class_1657 && entity2 instanceof class_3222 && !this.method_5701()) {
                    ((class_3222)entity2).field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                }
                if (!this.method_37908().method_8608() && entity2 instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)entity2;
                    if (!entity.method_5805()) {
                        SpectrumAdvancementCriteria.KILLED_BY_INK_PROJECTILE.trigger(serverPlayerEntity, List.of(entity));
                    }
                }
            }
            this.method_5783(this.getHitSound(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
            this.method_31472();
        } else {
            this.method_18799(this.method_18798().method_1021(-0.1));
            this.method_36456(this.method_36454() + 180.0f);
            this.field_5982 += 180.0f;
            if (!this.method_37908().method_8608() && this.method_18798().method_1027() < 1.0E-7) {
                this.method_31472();
            }
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        class_243 vec3d = blockHitResult.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3d);
        class_243 vec3d2 = vec3d.method_1029().method_1021(0.05);
        this.method_23327(this.method_23317() - vec3d2.field_1352, this.method_23318() - vec3d2.field_1351, this.method_23321() - vec3d2.field_1350);
        this.method_5783(this.getHitSound(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        int colorOrdinal = this.getColor();
        if (colorOrdinal != -1) {
            class_1767 dyeColor = class_1767.method_7791((int)colorOrdinal);
            for (class_2338 blockPos : class_2338.method_25996((class_2338)blockHitResult.method_17777(), (int)2, (int)2, (int)2)) {
                class_2248 class_22482 = this.method_37908().method_8320(blockPos).method_26204();
                if (class_22482 instanceof ColorableBlock) {
                    ColorableBlock colorableBlock = (ColorableBlock)class_22482;
                    if (!GenericClaimModsCompat.canModify(this.method_37908(), blockPos, this.method_24921())) continue;
                    colorableBlock.color(this.method_37908(), blockPos, dyeColor);
                    continue;
                }
                class_2680 coloredBlockState = BlockVariantHelper.getCursedBlockColorVariant(this.method_37908(), blockPos, dyeColor);
                if (!coloredBlockState.method_26215()) {
                    this.method_37908().method_8501(blockPos, coloredBlockState);
                }
                if (this.getInkColor() != InkColors.ORANGE || this.method_37908().method_8320(blockPos).method_26204() != class_2246.field_10477) continue;
                this.method_37908().method_8501(blockPos, class_2246.field_10124.method_9564());
            }
            if (this.getInkColor() == InkColors.ORANGE) {
                FirestarterIdolBlock.causeFire((class_3218)this.method_37908(), blockHitResult.method_17777(), blockHitResult.method_17780());
            }
            this.affectEntitiesInRange(this.method_24921());
        }
        this.method_31472();
    }

    protected void onHit(class_1309 target) {
        int colorOrdinal = this.getColor();
        if (colorOrdinal != -1) {
            class_1309 entity = target;
            if (this.getInkColor() == InkColors.ORANGE) {
                entity.method_5639(2);
            } else {
                class_243 vec3d = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021(1.7999999999999998);
                if (vec3d.method_1027() > 0.0) {
                    entity.method_5762(vec3d.field_1352, 0.1, vec3d.field_1350);
                }
            }
            this.affectEntitiesInRange(this.method_24921());
        }
        this.method_31472();
    }

    public void affectEntitiesInRange(class_1297 attacker) {
        this.method_37908().method_33596((class_1297)this, class_5712.field_28162, class_2338.method_49637((double)this.method_19538().field_1352, (double)this.method_19538().field_1351, (double)this.method_19538().field_1350));
        double posX = this.method_19538().field_1352;
        double posY = this.method_19538().field_1351;
        double posZ = this.method_19538().field_1350;
        float q = 4.0f;
        double k = class_3532.method_15357((double)(posX - (double)q - 1.0));
        double l = class_3532.method_15357((double)(posX + (double)q + 1.0));
        int r = class_3532.method_15357((double)(posY - (double)q - 1.0));
        int s = class_3532.method_15357((double)(posY + (double)q + 1.0));
        int t = class_3532.method_15357((double)(posZ - (double)q - 1.0));
        int u = class_3532.method_15357((double)(posZ + (double)q + 1.0));
        List list = this.method_37908().method_8335((class_1297)this, new class_238(k, (double)r, (double)t, l, (double)s, (double)u));
        class_243 vec3d = new class_243(posX, posY, posZ);
        for (class_1297 entity : list) {
            double ac;
            double z;
            double y;
            double x;
            double aa;
            double w;
            if (!GenericClaimModsCompat.canInteract(this.method_37908(), entity, attacker)) continue;
            if (EntityColorProcessorRegistry.colorEntity(entity, this.getInkColor().getDyeColor())) {
                entity.method_37908().method_43129(null, entity, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
            }
            if (entity.method_5659() || !((w = Math.sqrt(entity.method_5707(vec3d)) / (double)q) <= 1.0) || (aa = Math.sqrt((x = entity.method_23317() - posX) * x + (y = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - posY) * y + (z = entity.method_23321() - posZ) * z)) == 0.0) continue;
            x /= aa;
            y /= aa;
            z /= aa;
            double ab = class_1927.method_17752((class_243)vec3d, (class_1297)entity);
            double ad = ac = (1.0 - w) * ab;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                ad = class_1900.method_8237((class_1309)livingEntity, (double)ac);
            }
            entity.method_18799(entity.method_18798().method_1031(x * ad, y * ad, z * ad));
        }
    }

    @Override
    public void spawnImpactParticles() {
        class_1767 dyeColor = this.getInkColor().getDyeColor();
        class_1937 world = this.method_37908();
        class_243 targetPos = this.method_19538();
        class_243 velocity = this.method_18798();
        world.method_8406(SpectrumParticleTypes.getExplosionParticle(dyeColor), targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 0.0, 0.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            world.method_8406((class_2394)SpectrumParticleTypes.getCraftingParticle(dyeColor), targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, -velocity.field_1352 * 3.0, -velocity.field_1351 * 3.0, -velocity.field_1350 * 3.0);
        }
    }
}

